#!/usr/bin/env python
#
#    FlipCalendar for Maemo by CJ Manoj Kumar > shin@talk.maemo.org, 
#
#    FlipCalendar for Maemo is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    FlipCalendar for Maemo is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with FlipCalendar for Maemo.  If not, see <http://www.gnu.org/licenses/>.
#
    
# All the necessary imports
import sys, os
import pango
import pygtk
pygtk.require('2.0')
import gtk
from gtk import gdk
import gobject
import cairo
import datetime
import locale
import commands
import traceback
import re
from ConfigParser import *
import hildondesktop
        
IMAGE_DIR = "/usr/lib/flipcalendar/themes/default"
BACKGROUND_NAME = "calendar.png"
alpha_channel = False

class FlipCalendar(hildondesktop.HomeItem):

    # settings
    p_layout = None
    day = ''


    # constructor
    def __init__(self):
        hildondesktop.HomeItem.__init__(self)

        self.set_resize_type(hildondesktop.HOME_ITEM_RESIZE_BOTH)

        self.set_size_request(200, 200)
        self.connect("settings", self._DoSettings)
        self.inbackground = False
        
        # Initialize background Cairo surface from PNG
        self.buffer = cairo.ImageSurface.create_from_png(os.path.join(IMAGE_DIR, BACKGROUND_NAME))

        # Create Cairo Context using the Surface with PNG
        cr = cairo.Context(self.buffer)
        cr.set_operator(cairo.OPERATOR_OVER)
        cr.scale(2.0,2.0)
        cr.save()

        self.connect("expose-event", self.expose)
        self.connect("screen-changed", self.screen_changed)
        #self.add(self.label)
        self.show_all()

        # set a timeout to change the images
        self.timer = gobject.timeout_add(6000, self.update)

        self.connect ("background", self.background)
        self.connect ("foreground", self.foreground)

    def _DoSettings(self,widget,data=None):
        menuitem = gtk.MenuItem("FlipCalendar")
        menuitem.connect_object("activate", self._ShowSettings,None)
        return menuitem

    def _color_to_string(self,c):
        t = "#"

        if len(hex(c.red)[2:4])==1:
            t = t+'0'+hex(c.red)[2:4]
        else:
            t = t+hex(c.red)[2:4]
        if len(hex(c.green)[2:4])==1:
            t = t+'0'+hex(c.green)[2:4]
        else:
            t = t+hex(c.green)[2:4]
        if len(hex(c.blue)[2:4])==1:
            t = t+'0'+hex(c.blue)[2:4]
        else:
            t = t+hex(c.blue)[2:4]
        return t

    def _validate(self,widget,*data):
        self._prefSave('coldate',self._color_to_string(self._widgetTree.get_widget("color_date").get_current_color()))
        self._prefSave('colday',self._color_to_string(self._widgetTree.get_widget("color_day").get_current_color()))
        self._prefSave('title',self._color_to_string(self._widgetTree.get_widget("color_title").get_current_color()))
        self._prefSave('coldate_alpha',str(self._widgetTree.get_widget("color_date").get_current_alpha()))
        self._prefSave('colday_alpha',str(self._widgetTree.get_widget("color_day").get_current_alpha()))
        self._prefSave('title_alpha',str(self._widgetTree.get_widget("color_title").get_current_alpha()))
        self._prefSave('font',self._widgetTree.get_widget("fontselection").get_font_name())
        self._window.destroy()

    def _cancel(self,widget,*data):
        self._window.destroy()

    def _closebox(self,widget,*data):
        self._window.destroy()

    def _prefRead(self,key):
        default = {'coldate':'#000000','coldate_alpha':'32767','colday':'#FFFFFF','colday_alpha':'65535','title':'#FFAB00','title_alpha':'65535','font':'Sans 16'}
        c = ConfigParser(default)
        c.read('/home/user/.flipcalendar')
        return c.get("DEFAULT", key)

    def _prefSave(self,key,value):

        default = {'coldate':'#000000','coldate_alpha':'32767','colday':'#FFFFFF','colday_alpha':'65535','title':'#FFAB00','title_alpha':'65535','font':'Sans 16'}
        c = ConfigParser(default)
        c.read('/home/user/.flipcalendar')
        c.set('DEFAULT',key,value)
        fp = open('/home/user/.flipcalendar','w')
        c.write(fp)
        fp.close()

    def _ShowSettings(self,widget,data=None):
        import gtk.glade
        self._widgetTree = gtk.glade.XML('/usr/lib/flipcalendar/prefs.glade')
        self._window = self._widgetTree.get_widget("prefs")
        self._widgetTree.get_widget("color_date").set_current_color(gtk.gdk.color_parse(self._prefRead('coldate')))
        self._widgetTree.get_widget("color_date").set_has_opacity_control(True)
        self._widgetTree.get_widget("color_date").set_current_alpha(int(self._prefRead('coldate_alpha')))
        self._widgetTree.get_widget("color_day").set_current_color(gtk.gdk.color_parse(self._prefRead('colday')))
        self._widgetTree.get_widget("color_day").set_current_alpha(int(self._prefRead('colday_alpha')))
        self._widgetTree.get_widget("color_day").set_has_opacity_control(True)
        self._widgetTree.get_widget("color_title").set_current_color(gtk.gdk.color_parse(self._prefRead('title')))
        self._widgetTree.get_widget("color_title").set_current_alpha(int(self._prefRead('title_alpha')))
        self._widgetTree.get_widget("color_title").set_has_opacity_control(True)
        self._widgetTree.get_widget("fontselection").set_font_name(self._prefRead('font'))

        callbackMapping = {
            # Signal
          "on_bCancel_clicked": self._cancel,
          "on_bValidate_clicked": self._validate,
        }
        self._widgetTree.signal_autoconnect(callbackMapping)
        self._window.connect("delete-event", self._closebox)

        self._window.show()

        return True

    def expose(self, widget, event):
    
        global alpha_channel
        
        alloc = self.get_allocation()
        self.width, self.height = (alloc.width * 0.0082), (alloc.height * 0.0082)

        ctx = widget.window.cairo_create()

        ctx.set_source_rgba(0.0, 0.0, 0.0, 0.0) # Set context/widget background to Transparent
        ctx.scale(self.width, self.height) # To display the FlipCalendar based on resized parameter

        ctx.set_source_surface( self.buffer, 0, 0 )

        ctx.set_operator(cairo.OPERATOR_SOURCE)
        ctx.paint()

        self.DrawCalendar(ctx)

        return True

    def screen_changed(self, widget, old_screen=None):
        global alpha_channel

        screen = widget.get_screen()
        colormap = screen.get_rgba_colormap()
        if colormap == None:
            colormap = screen.get_rgb_colormap()
            alpha_channel = False
        else:
            alpha_channel = True

        widget.set_colormap(colormap)

        return False

    def update(self):

        self.queue_draw()
        return not self.inbackground

    def background(self, widget, data=None):

        self.inbackground = True
        if self.timer != None:
            gobject.source_remove(self.timer)
            self.timer = None

    def foreground(self, widget, data=None):

        self.set_resize_type(hildondesktop.HOME_ITEM_RESIZE_BOTH)

        self.inbackground = False
        self.timer = gobject.timeout_add(6000, self.update)

    def unrealize(self, widget, date=None):
        # cancel timeout
        v = gobject.source_remove(self.timer)

    def DrawCalendar(self, ctx):

        # Get Color parameters
        date_color=gtk.gdk.color_parse(self._prefRead('coldate'))
        day_color=gtk.gdk.color_parse(self._prefRead('colday'))
        title_color=gtk.gdk.color_parse(self._prefRead('title'))
        
        # Get date
        date = self.get_date_info() # [day, month, adate, year]
        
        # Set size
        
        ctx.scale(1.0, 1.0)
        self.p_layout = ctx.create_layout()
        ctx.update_layout(self.p_layout) 
        
        p_fdesc = pango.FontDescription(self._prefRead('font'))
        ctx.rotate(-0.20)
        ctx.save()
        
        # Draw the Title-Month on the Calendar 
        ctx.translate(5, 42)        
        p_fdesc.set_size(10 * pango.SCALE)
        self.p_layout.set_font_description(p_fdesc)  
        self.p_layout.set_width((self.width) * pango.SCALE)
        self.p_layout.set_alignment(pango.ALIGN_LEFT)
        self.p_layout.set_markup(date[1][:3]) 

        ctx.set_source_rgba (title_color.red / 65535.0, title_color.green/65535.0, title_color.blue/65535.0, float(self._prefRead('title_alpha'))/65535.0)        
        ctx.show_layout(self.p_layout)

        ctx.restore()
        ctx.save()
        
        # Draw the Title-Year on the Calendar
        ctx.translate(35, 32)
        p_fdesc.set_size(8 * pango.SCALE)
        self.p_layout.set_font_description(p_fdesc)
        self.p_layout.set_width((self.width) * pango.SCALE)
        self.p_layout.set_alignment(pango.ALIGN_LEFT)
        self.p_layout.set_markup(str(date[3])) 

        ctx.set_source_rgba (title_color.red / 65535.0, title_color.green/65535.0, title_color.blue/65535.0, float(self._prefRead('title_alpha'))/65535.0)                
        ctx.show_layout(self.p_layout)

        ctx.restore()
        ctx.save()

        
        # Draw the day of the week
        ctx.translate(66, 60)
        p_fdesc.set_size(9 * pango.SCALE)
        self.p_layout.set_font_description(p_fdesc)
        self.p_layout.set_width((self.width) * pango.SCALE)
        self.p_layout.set_alignment(pango.ALIGN_LEFT)
        self.p_layout.set_markup( str(date[0][:3]))
    
        ctx.set_source_rgba (day_color.red / 65535.0, day_color.green/65535.0, day_color.blue/65535.0, float(self._prefRead('colday_alpha'))/65535.0)
        ctx.show_layout(self.p_layout)

        ctx.restore()
        ctx.save()
        
        # Draw the Date on the Calendar
        ctx.translate(20, 62)
        p_fdesc.set_size(30 * pango.SCALE)
        self.p_layout.set_font_description(p_fdesc)             
        self.p_layout.set_width((self.width) * pango.SCALE)
        self.p_layout.set_alignment(pango.ALIGN_LEFT)
        self.p_layout.set_markup(str(date[2]))  

        ctx.set_source_rgba (date_color.red / 65535.0, date_color.green/65535.0, date_color.blue/65535.0, float(self._prefRead('coldate_alpha'))/65535.0)        
        ctx.show_layout(self.p_layout)

        ctx.save()
        ctx.restore()
   
        return True 

    def get_date_info(self):

        now = datetime.datetime.now()
        day = now.strftime("%A")
        month = now.strftime("%b")
        adate = now.strftime("%d")
        year = now.strftime("%Y")
        
        return [day, month, adate, year]


def hd_plugin_get_objects():
    plugin = FlipCalendar()
    return [plugin]

if __name__ == "__main__":
    print FlipCalendar()
    print FlipCalendar().update()
    print FlipCalendar()._ShowSettings('a')
    gtk.main()
    