from distutils.core import setup
import os

def create_mo(lang):
    base = os.path.join("po", lang)
    source = os.path.join(base, "feedcircuit.po")
    dest = os.path.join(base, "feedcircuit.mo")
    if not os.path.exists(dest) or os.path.getmtime(source) > os.path.getmtime(dest):
        print "creating " + dest
        os.spawnlp(os.P_WAIT, "msgfmt", "msgfmt", "-o", dest, source)


create_mo("ru")

setup(
    name = "feedcircuit",
    version = "0.6.2",
    description = "RSS and Atom feeds grabber",
    author = "George Kibardin",
    author_email = "george-kibardin@yandex.ru",
    url = "http://feedcircuit.garage.maemo.org",
    packages = ["feedcircuit"],
    scripts = ["feedcircuit-gui", "feedcircuit-cli"],
    data_files = [
        ("share/icons/hicolor/64x64/hildon", ["icons/64x64/feedcircuit.png"]),
        ("share/icons/hicolor/26x26/hildon", ["icons/26x26/feedcircuit.png"]),
        ("share/applications/hildon", ["feedcircuit.desktop"]),
        ("share/dbus-1/services", ["feedcircuit.service"]),
        ("share/locale/ru/LC_MESSAGES", ["po/ru/feedcircuit.mo"])
    ]
)
