import os.path
import os
import gpe_service
import gpe_event
import google_service
import google_event
import datetime
import time
import string
import gtk, hildon
import gdata.service

from utils import *

class ProcessEventsObj:

    def __init__(self, googleAccess, GPEAccess, current_cfg):
	self.google_access = googleAccess
	self.gpe_access = GPEAccess
	self.currentcfg = current_cfg

    def init_Profile(self, profile_name):
        #Load the profile
        self.current_count = 0
        self.total_count = 0
        
        profile = self.currentcfg.get_profile(profile_name)

        self.profile_name = profile['name']
        self.profile_googlecalendarid = profile['googlecalendarid']
        self.profile_gpecalendarid = profile['gpecalendarid']
        self.profile_timezone_name = profile['timezone_name']
        self.profile_gpeupdate = profile['gpeupdate']
        self.profile_googleupdate = profile['googleupdate']
        self.profile_startdate = profile['startdate']
        self.profile_accesslevel = profile['accesslevel']

    def reset_progressbar(self):
        if (self.progressbar != None):
            self.current_count = 0;
            self.progressbar.set_fraction(0.0)
	    while gtk.events_pending():
                gtk.main_iteration(False)

    def update_progressbar(self):
	if (self.progressbar != None):
	        self.current_count = self.current_count + 1
	        fraction = float(self.current_count)/self.total_count        
	        self.progressbar.set_fraction(fraction)
        
	        while gtk.events_pending():
        	            gtk.main_iteration(False)

    def set_progressbar_text(self, text):
        if (self.progressbar != None):
                self.progressbar.set_text(text)

    def reportError(self, message):
        if self.textMode:
            print message
        else:
            guimessage(message, self.parentWindow, gtk.STOCK_DIALOG_WARNING)


    def updateall(self, profile_name, parentwindow=None, 
                             progressbar=None, textMode=False, 
                             alwaysDelete=False):

        self.init_Profile(profile_name) 
        self.textMode = textMode
        self.progressbar = progressbar
        self.parentWindow = parentwindow
        
        gpe_newevents_count = self.gpe_access.getnewevents_count(
                                                 self.profile_gpecalendarid)
        gpe_deletedevents_count = self.gpe_access.getdeletedevents_count(
                                             self.profile_gpecalendarid)
        gpe_updatedevents_count = self.gpe_access.getupdatedevents_count(self.profile_gpecalendarid, self.profile_gpeupdate)

        invalid_events = \
            self.gpe_access.get_invalid_events(self.profile_gpecalendarid)
            
        # get local time and delta between local time and google time
        now_timestamp = time.time()
        timedelta = self.google_access.get_google_timestamp() - now_timestamp      
        printd("processevents : updateall : accesslevel : " + 
                                               str(self.profile_accesslevel))
        
        #If not a read only calendar
        if (self.profile_accesslevel != "read"):
            result = 0
            if (gpe_deletedevents_count > 0):
                if not textMode:
                    result = self.deleting_confirmation(parentwindow, 
                         gpe_deletedevents_count)
                else:
                    if alwaysDelete:
                        result = 1
                    else:
                        result = 0
            else:
                result = 1
                
            if (result == 1):
                if (len(invalid_events) > 0):
                
                    #Ouch, there are invalid events !!!!
                    printd("There are %s invalid event(s) !!" % (len(invalid_events)))
                    self.invalid_events = invalid_events
                    return 1 
                
                #There is no invalid event, go !!! 
                
                #Calculating the count of GPE event to process
                self.total_count = gpe_newevents_count + gpe_deletedevents_count\
                        + gpe_updatedevents_count
                self.current_count = 0
                
                     
                self.set_progressbar_text(self.profile_name +
                        " : Processing deleted GPE events")
                self.ProcessDeletedEvents()

                self.set_progressbar_text(self.profile_name + 
                        " : Processing updated GPE events")
                self.ProcessUpdatedEvents()

                self.set_progressbar_text(self.profile_name + 
                        " : Processing new GPE events")
                self.ProcessNewEvents()

                self.reset_progressbar()
                                            
        last_google_update = self.ImportGoogleEvents(self.profile_googleupdate, 
                now_timestamp + timedelta, self.profile_startdate)
        
        last_gpe_update = "%u" % (time.time())
        self.currentcfg.update_lastupdate(self.profile_name,
                                          last_gpe_update,
                                          last_google_update)

            
        return 0
    

        

    def ProcessDeletedEvents(self):
        """Process the deleted events of the profile name
        """
        gpe_deleted_events = \
            self.gpe_access.getdeletedevents(self.profile_gpecalendarid)
        
        for event in gpe_deleted_events:
            self.update_progressbar()
            self.google_access.delete_event(string.replace(event, "#", "%"))
            self.gpe_access.delete_deletedevent(event)
            

    def ProcessUpdatedEvents(self):
        """Process the updated events of the profile name
        """
        gpe_updated_events = \
            self.gpe_access.getupdatedevents(self.profile_gpecalendarid, self.profile_gpeupdate)
        
        for event in gpe_updated_events:
            self.update_progressbar()
            event.dump()
            try:
                if not self.google_access.updateevent(event):
                    self.reportError("Event \"" + event.title() +
                            "\" has not editLink!\nSkipped...")
            except gdata.service.RequestError :
                print "RE"
                # Google event can not be found
                printd("proccessevents : ProcessUpdatedEvents : " +\
                          "Can not update the event, I will create it")
                google_id = self.google_access.addevent(
                        self.profile_googlecalendarid, event)
                printd("proccessevents : ProcessUpdatedEvents : " +\
                           "old ID : " + str(event['eventid']))
                printd("proccessevents : ProcessUpdatedEvents : " +\
                           "new ID : " + str(google_id))
                self.gpe_access.change_id(event['eventid'], google_id)
            except IndexError:
                print "IE"
                #Google event found, but can not be updated
                printd("proccessevents : ProcessUpdatedEvents : " +\
                          "Other error when updating : " + str(event['eventid']))
                printd("proccessevents : ProcessUpdatedEvents : " +\
                          "deleting Google event : " + str(event['eventid']))
                self.google_access.delete_event(string.replace(event['eventid'],
                    "#", "%"))
                printd("proccessevents : ProcessUpdatedEvents : " +\
                          "creating a new Google event")
                google_id = self.google_access.addevent(
                        self.profile_googlecalendarid, event)
                printd("proccessevents : ProcessUpdatedEvents : " +\
                          "new Google eventid : " + str(google_id))
                printd("proccessevents : ProcessUpdatedEvents : " +\
                          "changing gpe eventid  from %s to %s" % (event['eventid'], google_id))
                self.gpe_access.change_id(event['eventid'], google_id)

    def ProcessNewEvents(self):
        """Process the new recurrent events of the profile name
        """
        gpe_new_recurrent_events = \
            self.gpe_access.getnewevents(self.profile_gpecalendarid)
        
        for event in gpe_new_recurrent_events:
            self.update_progressbar()
            event.dump()
            
            google_id = self.google_access.addevent(
                        self.profile_googlecalendarid, event)
                
            self.gpe_access.change_id(event['eventid'], google_id)
                

    def ImportGoogleEvents(self, updated_min, updated_max, start_min):
        """Import Google events in the GPE Calendar database
        """
        
        updated_max = time.strftime("%Y-%m-%dT%H:%M:%S", 
                time.gmtime(float(updated_max)))

        if (updated_min == ""): 
            updated_min = "1970-01-01T01:01:01.000Z"

        self.set_progressbar_text(self.profile_name + 
                " : Downloading Google events...")

        while gtk.events_pending():
                    gtk.main_iteration(False)

        google_events, last_update = \
            self.google_access.getevents(self.profile_googlecalendarid,
                                         updated_min, updated_max, start_min)

        self.set_progressbar_text(self.profile_name + 
                " : Processing Google events...")

        while gtk.events_pending():
                    gtk.main_iteration(False)
        #Calculating the count of Google event to process
        self.total_count = len(google_events)
        self.current_count = 0
            
        for event in google_events:
            self.update_progressbar()
            #Adding the gpe calendar where creating the event
            event["gpecalendarid"] = self.profile_gpecalendarid
            event["timezone"] = self.profile_timezone_name

            if ((event['status'] == "CONFIRMED") 
                    or (event['status'] == "TENTATIVE")):
                while gtk.events_pending():
                    gtk.main_iteration(False)
                self.AddGPEEvent(event)
            elif (event['status'] == "CANCELED"):     
                if event['single_event']:
                    print("processevent.ImportGoogleEvents : it's a canceled event")
                    self.DeleteGPEEvent(event['id'])
                else:
                    self.gpe_access.delete_occurence(event['id'], 
                                        event['start_date'])
                    print("processevents.ImportGoogleEvents : It's a deleted" +\
                                  " occurrence : " + str(event['id']))

        printd("processevent.ImportGoogleEvents : Exiting processevents.ImportGoogleEvents()")
        
        return last_update
        
    def DeleteGPEEvent(self, eventid):
        self.gpe_access.deleteevent(eventid)

        
    def AddGPEEvent(self, event):
        event.dump()
                
        if self.gpe_access.isevent(event['id']):
            printd("processevents.AddGPEEvent: The event exists in GPE database")
            self.gpe_access.update_event(event)
        else:
            printd("processevents.AddGPEEvent : The event does not exist in GPE database")
            self.gpe_access.add_event(event)

        printd("** Exiting in Processevents.CreateGPEEvent")
        
    
    def deleting_confirmation(self, parentwindow, events_count):
        """
        Display a confimation popup
        """
        message = "You are about to delete\n %s Google events" % (events_count)
        dialog = hildon.Note ("confirmation", (parentwindow, message, gtk.STOCK_DIALOG_WARNING) )
        dialog.set_button_texts ("Ok", "Abort") 
        response = dialog.run() 
        dialog.destroy() 
        if response == gtk.RESPONSE_OK: 
            printd("processevents : deleting_confirmation : continue")
            return 1
        else: 
            printd("processevents : deleting_confirmation : abort")
            return 0 
