#!/usr/bin/env python2.5

import datetime
import time
#import erminigcfg


    
def googledatetogpedate(googledate):
    googlehour = ""
    if 'T' in googledate:
        googlehour = googledate.split('T')[1][:8]
        googledate = googledate.split('T')[0]
        googledate = googledate + " " + googlehour
        googledate = \
            datetime.datetime.fromtimestamp(
            time.mktime(time.strptime(googledate, "%Y-%m-%d %H:%M:%S")))
    else:
        googledate = googledate.split('T')[0]
        googledate = \
            datetime.datetime.fromtimestamp(
            time.mktime(time.strptime(googledate,"%Y-%m-%d")))

    #print "Google date : %s" + googledate
    return googledate
    
    
def googledatetodatetime(googledate):
    if (('T' in googledate) and ('-' in googledate)):
        googledate = googledate[0:19]
        googledate = datetime.datetime.strptime(googledate, "%Y-%m-%dT%H:%M:%S")
    elif (('T' in googledate) and ('-' not in googledate)):
        googledate = googledate[0:15]
        googledate = datetime.datetime.strptime(googledate, "%Y%m%dT%H%M%S")
    elif (('T' not in googledate) and ('-' not in googledate)):
        googledate = googledate[0:8]
        googledate = datetime.datetime.strptime(googledate, "%Y%m%d")
    else:
        googledate = googledate.split('T')[0]
        googledate = datetime.datetime.strptime(googledate,"%Y-%m-%d")

    try:
        t = time.mktime(googledate.timetuple())
    except OverflowError:
        print "Warning: date out of range. Clipping to year 2037!"
        googledate = googledate.replace(year=2037)
        t = time.mktime(googledate.timetuple())

    googledate = datetime.datetime.fromtimestamp(t)

    return googledate

    

def exdate_to_rexception(exdate):
    """Convert an exdate 
    EXDATE;TZID=Etc/GMT:20070523T100000 or 
    to GPE UTC date : 2007-04-12 11:00:00
    Timezone support is automatic
    If 'Z' exists in the google_date string, it's already an UTC date, 
    else it's a local date"""
    
    exdates = exdate.split(":")[0].split(',')
    
    for a_exdate in exdates:
        #convert UTC exdate to local exdate
        #convert string to datetime
        print exdate
        a_exdate = datetime.datetime.strptime(a_exdate, "%Y%m%dT%H%M%S")
        a_exdate = datetime.datetime(a_exdate.year,
                                          a_exdate.month,
                                          a_exdate.day,
                                          a_exdate.hour,
                                          a_exdate.minute,
                                          a_exdate.second)
                                          
    
    if ('T' in google_date):
        if ('-' in google_date): 
            epoch_google_date = time.mktime(\
                    time.strptime(google_date[0:19], "%Y-%m-%dT%H:%M:%S"))
        else:
            epoch_google_date = time.mktime(\
                    time.strptime(google_date[0:15], "%Y%m%dT%H%M%S"))
        if ('Z' in google_date): 
            return (time.strftime("%Y-%m-%d %H:%M:%S",
                                               time.localtime(epoch_google_date)))
        else:
            return (time.strftime("%Y-%m-%d %H:%M:%S",
                                               time.gmtime(epoch_google_date)))
    else:
        if ('-' in google_date): 
            epoch_google_date = time.mktime(\
                    time.strptime(google_date[0:110], "%Y-%m-%d"))
        else:
            epoch_google_date = time.mktime(\
                    time.strptime(google_date[0:110], "%Y%m%d"))
        return (time.strftime("%Y-%m-%d",time.localtime(epoch_google_date)))

