#!/usr/bin/python

import os.path
import os
import sys
import socket
import gdata.calendar.service
import gdata.service
import atom.service
import gdata.calendar
import string, time, datetime
import erminigdates
import calendar
import google_event

from utils import *	

class GoogleConnector:
    def __init__(self):
        self.googlecalendars = []

    def init_google_params(self, config):
	self.googleConnected = False
        
        if (config.get_proxy_status()):
            #Set proxy parameters
            proxy_params = config.get_proxy_params()
            os.environ['http_proxy'] = proxy_params['http_proxy']
            os.environ['https_proxy'] = proxy_params['https_proxy']
            os.environ['proxy-username'] = proxy_params['user_proxy']
            os.environ['proxy-password'] = proxy_params['password_proxy']
        else:
            try:
                del os.environ['http_proxy']
            except:
                pass
            try:
                del os.environ['https_proxy']
            except:
                pass
            try:
                del os.environ['user-proxy']
            except:
                pass
            try:
                del os.environ['password-proxy']
            except:
                pass
        
        self.cal_client = gdata.calendar.service.CalendarService()
        self.cal_client.email = config.get_google_login()
        self.cal_client.password = config.get_google_password()
        self.cal_client.source = 'Google-Calendar_Python_Sample-1.0'

        res = (False, None)
        try:
            self.cal_client.ProgrammaticLogin()
	    self.googleConnected = True
            self.load_google_calendars()
            res = (True, None)
        except gdata.service.BadAuthentication:
	    self.googleConnected = False
            message = "Error: could not connect to Google!\n"
            message = message + "Please check your username and password.\n"
            message = message + "(error: BadAuthentication)"
            res = (False, message)
        except gdata.service.CaptchaRequired:
	    self.googleConnected = False
            message = "Error: could not connect to Google!\n"
            message = message + "Please check your username and password.\n"
            message = message + "(error: CaptchaRequired)"
            res = (False, message)
        except socket.gaierror:
	    self.googleConnected = False
            message = "Error: could not connect to Google!\n"
            message = message + "Please check Internet connectivity.\n"
            message = message + "(error: socket.gaierror)"
            res = (False, message)
        except:
            # catch this pesky string exception :s
            e = sys.exc_info()
            if e[0] == 'Error status=':
                message = "Error: could not connect to Google!\n"
                message = message + "Please check your Proxy settings.\n"
                message = message + "(error: Proxy error " + e[1] + ")"
                res = (False, message)
            else:
                raise

        return res
    
    def load_google_calendars(self, owner_only=True):
        """ owner_only : if true, we only list the calendar we own
        otherwise we list all the subscribed one.
        """
        self.isgoogleready = 0
        #Get the Google agendas
        try:
            feed = self.cal_client.GetCalendarListFeed()
        except:
            self.isgoogleready = 0
            return 0
        if owner_only:
            condition = lambda x: (('owner' in x.access_level.value) or
                                                ('editor' in x.access_level.value) or
                                                ('read' in x.access_level.value) or
                                                ('root' in x.access_level.value))
        else:
            condition = lambda x: True
        self.googlecalendars = \
            [(x.id.text[63:],x.title.text,x.timezone.value,x.access_level.value) \
                for x in feed.entry if condition(x)]
#        printd(self.googlecalendars, True)
        self.isgoogleready = 1
        return 1
        
    def get_google_calendars(self):
        return self.googlecalendars

    def delete_event(self, eventid):
        printd("Deleting google event : " + str(eventid))
        eventid = string.replace(eventid, "composite", "full")
        result = True
        try:
            deleted_event = self.cal_client.GetCalendarEventEntry(eventid)   
            self.cal_client.DeleteEvent(deleted_event.GetEditLink().href)
        except:
            result = False

        return result
        


    def addevent(self, calendarid, gpeevent):
        """Add an event in Google Calendar
        """
        event = gdata.calendar.CalendarEventEntry()
        event.author.append(atom.Author(name=atom.Name(text='CalendarExample')))
        event.title = atom.Title(text=gpeevent.title())
        event.content = atom.Content(text=gpeevent.content())
        event.where.append(gdata.calendar.Where(value_string=gpeevent.where()))
        if (gpeevent.rstring() <> None):
            printd( "google_service.addevent : generating rstring")
            #This is a recurrent event, I generate the rstring
            recurrence_data = gpeevent.rstring()
            event.recurrence = gdata.calendar.Recurrence(text=recurrence_data)
        else:
            #This is a single event
            event.when.append(
                  gdata.calendar.When(start_time=gpeevent.start_date(), 
                      end_time=gpeevent.end_date()))
        new_event = self.cal_client.InsertEvent(event,
                                               '/calendar/feeds/'
                                               + calendarid + '/private/full')
        printd("google_service.addevent : Google ID of created event : " + str(new_event.id.text))
        return new_event.id.text
      
    def updateevent(self, gpeevent):
        """Update an event in Google Calendar
        """
        #Loading the event to modify
        gpeevent['eventid'] = string.replace(gpeevent['eventid'], "composite", 
                "full")
        event = self.cal_client.GetCalendarEventEntry(gpeevent['eventid'])
        
        #Updating the properties
        event.title = atom.Title(text=gpeevent.title())
        event.content = atom.Content(text=gpeevent.content())
        event.location = gpeevent.where()
        for a_location in event.where:
            a_location.value_string = gpeevent.where()

        if (gpeevent.rstring() <> None):
            printd("generating rstring")
            #This is a recurrent event, I generate the rstring
            recurrence_data = gpeevent.rstring()
            event.recurrence = gdata.calendar.Recurrence(text=recurrence_data)
        else:
            #This is a single event
            event.when[0] = gdata.calendar.When(start_time=gpeevent.start_date(),
                    end_time=gpeevent.end_date())

        #Updating the event
        if event.GetEditLink() == None:
            return False
        else:
            self.cal_client.UpdateEvent(event.GetEditLink().href, event)
            return True


    def getevents(self, calendarid, updated_min, updated_max, start_min):

        query = gdata.calendar.service.CalendarEventQuery(calendarid,
                                                     'private', 'composite',
                                                     None, {"ctz":"utc"})
        # Adding 1 second to the google update date
        updated_min = \
            datetime.datetime.fromtimestamp(
            time.mktime(time.strptime(updated_min, "%Y-%m-%dT%H:%M:%S.000Z")))
        
        updated_min = updated_min + datetime.timedelta(seconds = 1)
        updated_min = updated_min.strftime("%Y-%m-%dT%H:%M:%S.000Z")
        printd(("google_service : getevents : date range query : %s, %s") % (updated_min, updated_max))
        query.updated_min = updated_min # Need to add 1 second
        query.updated_max = updated_max
        query.start_min = start_min
        query.start_max = '2037-12-31'
        query.max_results = "1000000"
        feed = self.cal_client.CalendarQuery(query)
        result_entries = []
        last_feed_update = feed.updated.text
        printd ("google_service : getevents : date of the feed : " + 
               str(last_feed_update))
        for event in feed.entry:
            the_event = google_event.GoogleEvent()
            id = event.id.text
            id = string.replace(id, "%", "#")
            the_event['id'] =  string.replace(id, "composite", "full")
            the_event['published'] = event.published.text
            the_event['updated'] = event.updated.text
            the_event['title'] = event.title.text

            # XXX How does this relate to the test below??
            try:
                the_event['content'] = event.content.text
            except:
                the_event['content'] = ""

            # XXX Multiple locations?
            for a_location in event.where:
                the_event['location'] = a_location.value_string

            for a_when in event.when:
                the_event['start_date'] = a_when.start_time
                the_event['end_date'] = a_when.end_time

            if the_event['content'] == None:
                the_event['content'] = ""

            if the_event['location'] == None:
                the_event['location'] = ""

            if event.recurrence <> None:
                the_event['recurrence'] = event.recurrence.text

            for exception in event.recurrence_exception:
                the_event['exceptions'].append(
                            exception.entry_link.entry.when[0].start_time)
            the_event['status'] = event.event_status.value
            the_event['raw'] = event

            result_entries.append(the_event)

        return result_entries, last_feed_update
        

    def get_google_timestamp(self):
        """ owner_only : if true, we only list the calendar we own
        otherwise we list all the subscribed one.
        """
        
        #Get the Google agendas
        feed = self.cal_client.GetCalendarListFeed()        

        printd("google_service.get_google_timestamp : feed : %s" % (feed))
        utc_google_time = time.strptime(feed.updated.text[0:19], "%Y-%m-%dT%H:%M:%S")
        
        printd("google_service.get_google_timestamp : utc Google time : %s"\
                        % (utc_google_time))
                        
        google_timestamp = calendar.timegm(utc_google_time)
        
        printd("google_service.get_google_timestamp : Google time : %s"\
                        % (google_timestamp))
                        
        return google_timestamp
    
