#!/usr/bin/python2.5

import sys
import gtk
import gtk.glade
import gobject
import os
import commands
import pickle
import hildon
import google_service
import gpe_service
import erminigcfg
import processevents
import datetime


class Profile:
    """This class represents all the cmd information"""

    def __init__(self, name=""
                 , googlecalendarid="", googlecalendartitle=""
                 , gpecalendarid="", gpecalendartitle=""
                 , timezone="", gpeupdate="", googleupdate=""
                 , enabled=False, startdate = ""):

        self.name = name
        self.googlecalendartitle = googlecalendartitle
        self.googlecalendarid = googlecalendarid
        self.gpecalendartitle = gpecalendartitle
        self.gpecalendarid = gpecalendarid
        self.timezone = timezone
        self.gpeupdate = gpeupdate
        self.googleupdate = googleupdate
        self.enabled = enabled
        self.startdate = startdate
                   

    def getList_cfg(self):
        """This function returns a list made up of the
        cmd information.  It is used to add a cmd to the
        cmdList easily"""
        return [self, self.name
                , self.googlecalendartitle
                , self.googlecalendarid
                , self.gpecalendartitle
                , self.gpecalendarid
                , self.timezone
                , self.gpeupdate
                , self.googleupdate
                , self.enabled
                , self.startdate]
        
        
    def getList_treeview(self):
        """This function returns a list made up of the
        cmd information.  It is used to add a cmd to the
        cmdList easily"""

        return [self, self.name
                , self.googlecalendartitle
                , self.googlecalendarid
                , self.gpecalendartitle
                , self.gpecalendarid
                , self.timezone
                , self.gpeupdate
                , self.googleupdate
                , self.enabled
                , self.icon()
                , self.lastupdate()]
        
        
    def icon(self):
        if (self.enabled == False):
            return gtk.STOCK_NO
        else:
            return gtk.STOCK_YES
            
    def lastupdate(self):
        print "gpe update : " + self.gpeupdate
        if ((self.gpeupdate == "") or 
             (self.gpeupdate == "0")):
            lastupdate = "Never"
        else:            
            lastupdate = datetime.datetime.fromtimestamp(float(self.gpeupdate))
        return lastupdate
        

if __name__ == "__main__":

    # Load configuration
    currentcfg = erminigcfg.conf()
    currentcfg.load_configuration()
    
    for profile in currentcfg.profiles:
            entry = currentcfg.get_profile(profile)
            print "cfg entry :"
            print (entry)
            profile = Profile(entry[0], entry[1], entry[2], entry[3]
                                     , entry[4], entry[5], entry[6]
                                     , entry[7], entry[8])
            if (profile.enabled == True):
                MyProcessEvent=processevents.ProcessEventsObj()
                result = MyProcessEvent.updateall(profile.name)
                                                                        
                                                                        
