#!/usr/bin/env python2.5
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# MA  02110-1301, USA.
#

from distutils.core import setup

version = '0.3.1'

# files to install
inst_service = [ 'erminig.service' ]
inst_desktop = [ 'erminig.desktop' ]
inst_icon_26 = ['pixmaps/26x26/erminig.png' ]
inst_icon_sca = ['pixmaps/scalable/erminig.png']
inst_icon_40 = ['pixmaps/40x40/erminig.png']
main_files = ['erminig.glade', 'erminigcfg.py', 'erminig', 'erminigdates.py', 'google_event.py', 'google_service.py', 'gpe_event.py', 'gpe_service.py', 'processevents.py', 'silent_update.py', 'utils.py']


data_files = [
  ('share/applications/hildon', inst_desktop),
  ('share/dbus-1/services', inst_service),
  ('share/icons/hicolor/40x40/hildon/', inst_icon_40),
  ('share/icons/hicolor/scalable/hildon/', inst_icon_sca),
  ('share/icons/hicolor/26x26/hildon/', inst_icon_26),  
  ('share/erminig', main_files), 
]

setup(
  name         = 'erminig',
  version      = version,
  description  = 'GPE Calendar <> Google Calendar synchronization',
  author       = 'Pascal Jermini',
  author_email = 'lorelei@garage.maemo.org',
  url          = 'http://erminig.garage.maemo.org/',
  data_files   = data_files
)
