import os.path
import os
import gpe_service
import gpe_event
import google_service
import erminigcfg
import google_event
import datetime
import time
import string
import gtk, hildon
import gdata.service

from utils import *

class ProcessEventsObj:

    def __init__(self, googleAccess, GPEAccess, current_cfg):
	self.google_access = googleAccess
	self.gpe_access = GPEAccess
	self.currentcfg = current_cfg

    def init_Profile(self, profile_name, progressbar):
        #Load the profile
        self.progressbar = progressbar
        self.current_count = 0
        self.total_count = 0

        (self.profile_name,
         self.profile_googlecalendarid,
         self.profile_googlecalendartitle,
         self.profile_gpecalendarid,
         self.profile_gpecalendartitle,
         self.profile_timezone_name,
         self.profile_gpeupdate,
         self.profile_googleupdate,
         enabled,
         self.profile_startdate,
         self.profile_accesslevel) = self.currentcfg.get_profile(profile_name)
        
        printd("ProccessEvents.init_Profile:profile_name:" + self.profile_name)
        printd("ProccessEvents.init_Profile:profile_gpecalendarid:" + \
              self.profile_gpecalendarid)
        
                                    
    def update_progressbar(self):
	if (self.progressbar != None):
	        self.current_count = self.current_count + 1
	        fraction = float(self.current_count)/self.total_count        
	        self.progressbar.set_fraction(fraction)
        
	        while gtk.events_pending():
        	            gtk.main_iteration(False)

    def updateall(self, profile_name, parentwindow=None, 
                             progressbar=None):
    
        self.init_Profile(profile_name, progressbar) 
        
        gpe_newevents_count = self.gpe_access.getnewevents_count(
                                                 self.profile_gpecalendarid)
        gpe_deletedevents_count = self.gpe_access.getdeletedevents_count(
                                             self.profile_gpecalendarid)
               
        invalid_events = \
            self.gpe_access.get_invalid_events(self.profile_gpecalendarid)
            
        timedelta = self.get_timedelta()
        
        now_timestamp = time.time()
        
        printd("processevents : updateall : accesslevel : " + 
                                                    self.profile_accesslevel)
        
        #If not a read only calendar
        if (self.profile_accesslevel != "read"):
            result =0
            if (gpe_deletedevents_count > 0):
                result = self.deleting_confirmation(parentwindow, 
                              gpe_deletedevents_count)
            else:
                result = 1
                
            if (result == 1):
                
                if (len(invalid_events) > 0):
                
                    #Ouch, there are invalid events !!!!
                    printd("There are %s invalid event(s) !!" % (len(invalid_events)))
                    self.invalid_events = invalid_events
                    return 1 
                
                #There is no invalid event, go !!! 
                
                #Calculating the count of GPE event to process
                self.total_count = self.gpe_access.getnewevents_count(
                                 self.profile_gpecalendarid)\
                                + self.gpe_access.getupdatedevents_count(
                                self.profile_gpecalendarid, self.profile_gpeupdate)\
                                + self.gpe_access.getdeletedevents_count(
                                self.profile_gpecalendarid)
                self.current_count = 0
                
                     
                printd("processevents.updateall : " +
                                          "I will enter in ProcessDeletedEvents()")
                if (self.progressbar != None):
                    self.progressbar.set_text(self.profile_name + 
                                  " : Processing deleted GPE events")
                self.ProcessDeletedEvents()
                printd("processevents.updateall : I will enter in ProcessUpdatedEvents()")
                if (self.progressbar != None):
                    self.progressbar.set_text(self.profile_name + 
                                  " : Processing updated GPE events")
                self.ProcessUpdatedEvents()
                printd("processevents.updateall : I will enter in ProcessNewEvents()")
                if (self.progressbar != None):
                    self.progressbar.set_text(self.profile_name + 
                                  " : Processing new GPE events")
                self.ProcessNewEvents()
                                            
        printd("processevents.updateall : I will enter in ImportGoogleEvents()")
        last_google_update = self.ImportGoogleEvents(self.profile_googleupdate,
                                             now_timestamp + timedelta, self.profile_startdate)
        
        printd("processevents.updateall : updating lastupdate of profile")
        last_gpe_update = "%u" % (time.time())
        self.currentcfg.update_lastupdate(self.profile_name,
                                          last_gpe_update,
                                          last_google_update)
            
        return 0
    

        

    def ProcessDeletedEvents(self):
        """Process the deleted events of the profile name
        """
        gpe_deleted_events = \
            self.gpe_access.getdeletedevents(self.profile_gpecalendarid)
        
        for event in gpe_deleted_events:
            self.update_progressbar()
            self.google_access.delete_event(string.replace(event, "#", "%"))
            self.gpe_access.delete_deletedevent(event)
            

    def ProcessUpdatedEvents(self):
        """Process the updated events of the profile name
        """
        gpe_updated_events = \
            self.gpe_access.getupdatedevents(self.profile_gpecalendarid, self.profile_gpeupdate)
        
        for event in gpe_updated_events:
            self.update_progressbar()
            #print event
            (uid, eventid, title, description, location,
                startdate, duration, recur,
                rend, rcount, rincrement, byday, rexceptions) = event
                
            eventid = string.replace(eventid, "#", "%")
             
            the_event = gpe_event.GpeEvent()
            the_event["start"] = startdate
            the_event["duration"] = duration
            the_event["recur"] = recur
            the_event["rend"] = rend
            the_event["eventid"] = eventid
            the_event["rcount"] = rcount
            the_event["rincrement"] = rincrement
            the_event["byday"] = byday
            the_event["rexceptions"] = rexceptions
            the_event["summary"] = title
            the_event["description"] = description
            the_event["location"] = location
            
            printd("   ***   The GPE event :   ***")
            printd("start : " + startdate)
            printd("duration : %s" % (duration))
            printd("recur : %s" % (recur))
            printd("rend : %s" % (rend))
            printd("eventid : " + eventid)
            printd("rcount : %s" % (rcount))
            printd("rincrement : %s" % (rincrement))
            printd("byday : " + byday)
            printd("rexceptions : " + rexceptions)
            printd("title : " + title)
            printd("description : " + description)
            printd("location : " + location)
            
            printd("   ***   The Google event :   ***")
            printd("start : " + the_event.start_date())
            printd("end : " + the_event.end_date())
            printd("title : " + the_event.title())
            printd("content : " + the_event.content())
            printd("where : " + the_event.where())
            printd("rstring : " + str(the_event.rstring()))
            
            try:
                self.google_access.updateevent(
                                           the_event.start_date(),
                                           the_event.end_date(),
                                           eventid,
                                           the_event.content(),
                                           the_event.title(),
                                           the_event.where(),
                                           the_event.rstring())
            except gdata.service.RequestError :
                # Google event can not be found
                printd("proccessevents : ProcessUpdatedEvents : " +\
                          "Can not update the event, I will create it")
                google_id = self.google_access.addevent(
                        self.profile_googlecalendarid, 
                        the_event.start_date(), 
                        the_event.end_date(),
                        eventid, 
                        the_event.content(), 
                        the_event.title(), 
                        the_event.where(),
                        the_event.rstring())      
                printd("proccessevents : ProcessUpdatedEvents : " +\
                           "old ID : " + eventid)
                printd("proccessevents : ProcessUpdatedEvents : " +\
                           "new ID : " + google_id)
                self.gpe_access.change_id(eventid, google_id)
            except IndexError:
                #Google event found, but can not be updated
                printd("proccessevents : ProcessUpdatedEvents : " +\
                          "Other error when updating : " + eventid)
                printd("proccessevents : ProcessUpdatedEvents : " +\
                          "deleting Google event : " + eventid)
                self.google_access.delete_event(string.replace(eventid, "#", "%"))
                printd("proccessevents : ProcessUpdatedEvents : " +\
                          "creating e new Google event")
                google_id = self.google_access.addevent(
                        self.profile_googlecalendarid, 
                        the_event.start_date(), 
                        the_event.end_date(),
                        eventid, 
                        the_event.content(), 
                        the_event.title(), 
                        the_event.where(),
                        the_event.rstring())
                printd("proccessevents : ProcessUpdatedEvents : " +\
                          "new Google eventid : " + google_id)
                printd("proccessevents : ProcessUpdatedEvents : " +\
                          "changing gpe eventid  from %s to %s" % (eventid, google_id))
                self.gpe_access.change_id(eventid, google_id)


    def ProcessNewEvents(self):
        """Process the new recurrent events of the profile name
        """
        printd("** Entering in ProcessEvents.ProcessNewRecurrentEvents")
        gpe_new_recurrent_events = \
            self.gpe_access.getnewevents(self.profile_gpecalendarid)
        
        for event in gpe_new_recurrent_events:
            self.update_progressbar()
            
            #print event
            (uid, eventid, title, description, location,
                startdate, duration, recur,
                rend, rcount, rincrement, byday, rexceptions) = event
             
            the_event = gpe_event.GpeEvent()
            the_event["start"] = startdate
            the_event["duration"] = duration
            the_event["recur"] = recur
            the_event["rend"] = rend
            the_event["eventid"] = eventid
            the_event["rcount"] = rcount
            the_event["rincrement"] = rincrement
            the_event["byday"] = byday
            the_event["rexceptions"] = rexceptions
            the_event["summary"] = title
            the_event["description"] = description
            the_event["location"] = location
            
            printd("   ***   The GPE event :   ***")
            printd("start : " + startdate)
            printd("duration : %s" % (duration))
            printd("recur : %s" % (recur))
            printd("rend : %s" % (rend))
            printd("eventid : " + eventid)
            printd("rcount : %s" % (rcount))
            printd("rincrement : %s" % (rincrement))
            printd("byday : " + byday)
            printd("rexceptions : " + rexceptions)
            printd("title : " + title)
            printd("description : " + description)
            printd("location : " + location)
            
            printd("   ***   The Google event :   ***")
            printd("start : " + the_event.start_date())
            printd("end : " + the_event.end_date())
            printd("title : " + the_event.title())
            printd("content : " + the_event.content())
            printd("where : " + the_event.where())
            printd("rstring : " + str(the_event.rstring()))
            
            google_id = self.google_access.addevent(
                        self.profile_googlecalendarid, 
                        the_event.start_date(), 
                        the_event.end_date(),
                        eventid, 
                        the_event.content(), 
                        the_event.title(), 
                        the_event.where(),
                        the_event.rstring())      
                
            self.gpe_access.change_id(eventid, google_id)
                

    def ImportGoogleEvents(self, updated_min, updated_max, start_min):
        """Import Google events in the GPE Calendar database
        """
        printd("processevent.ImportGoogleEvents : Entering in processevents.ImportGoogleEvents()")
        
        updated_max = time.strftime("%Y-%m-%dT%H:%M:%S", time.gmtime(float(updated_max)))
        if (updated_min == ""): updated_min = "1970-01-01T01:01:01.000Z"
        printd("processevents.ImportGoogleEvents : updated_min : " + updated_min)
        #updated_min = "2007-06-01T19:25:20"
        if (self.progressbar != None):
            self.progressbar.set_text(self.profile_name +
                                      " : Downloading Google events...")
        while gtk.events_pending():
                    gtk.main_iteration(False)
        google_events, last_update = \
            self.google_access.getevents(self.profile_googlecalendarid,
                                         updated_min, updated_max, start_min)
        if (self.progressbar != None):
            self.progressbar.set_text(self.profile_name +
                               " : Processing Google events...")
        while gtk.events_pending():
                    gtk.main_iteration(False)
        
        #Calculating the count of Google event to process
        self.total_count = len(google_events)
        self.current_count = 0
            
        for event in google_events:
            self.update_progressbar()
            #Adding the gpe calendar where creating the event
            event["gpecalendarid"] = self.profile_gpecalendarid
            event["id"] = string.replace(event["id"], "%", "#")
            event["id"] = string.replace(event["id"], "composite", "full")
            print event
            #self.CreateGPEEvent(event)
            if ((event['status'] == "CONFIRMED") or (event['status'] == "TENTATIVE")):
                printd("processevent.ImportGoogleEvents : it's a real event")
                while gtk.events_pending():
                    gtk.main_iteration(False)
                self.AddGPEEvent(event)
            elif (event['status'] == "CANCELED"):     
                try:
                    (event['google_event'].extension_elements[0].attributes['href'])
                    printd("processevents.ImportGoogleEvents : It's a deleted" +\
                                  " occurrence : " + event['id'])
                    self.gpe_access.delete_occurence(
                                    event['id'].split("_")[0],
                                    event['id'].split("_")[1][0:15])
                except:
                    printd("processevent.ImportGoogleEvents : it's a canceled event")
                    self.DeleteGPEEvent(event['id'])
        printd("processevent.ImportGoogleEvents : Exiting processevents.ImportGoogleEvents()")
        
        return last_update
        
    def DeleteGPEEvent(self, eventid):
        self.gpe_access.deleteevent(eventid)

        
    def AddGPEEvent(self, event):
            
        printd("processevents.AddGPEEvent : Entering in Processevents.CreateGPEEvent")
        
        
        
        the_event = google_event.GoogleEvent()
        the_event['id'] = event['id']
        the_event['start_date'] = event['startTime']
        the_event['end_date'] = event['endTime']
        the_event['title'] = event['title']
        the_event['content'] = event['content']
        the_event['location'] = event['location']
        gpe_calendarid = event['gpecalendarid']
        the_event['timezone'] = self.profile_timezone_name
        
        try: 
            event['rstring']
        except:
            pass
        else:
            the_event['recurrence'] = event['rstring']
        the_event['exceptions'] = event['rexceptions']
        the_event['updated'] = event['updated']
        
        printd("The Google event :")
        printd("id : " + the_event['id'])
        printd("start : " + the_event['start_date'])
        printd("end : " + the_event['end_date'])
        printd("title : " + str(the_event['title']))
        printd("content : " + str(the_event['content']))
        printd("location : " + the_event['location'])
        printd("modified : " + the_event['updated'])
        printd("recurrence : " + str(the_event['recurrence']))
        
        printd("The GPE event :")
        printd("eventid : " + the_event.eventid())
        printd("start : " + the_event.start_date())
        printd("rend : " + the_event.rend())
        printd("recur : " + the_event.recur())
        printd("summary : " + the_event.summary())
        printd("description : " + the_event.description())
        printd("duration : " + the_event.duration())
        printd("rincrement : " + the_event.rincrement())
        printd("location : " + the_event.location())
        printd("rcount : " + the_event.rcount())
        printd("modified : " + the_event.modified())
        printd("rexceptions : " + the_event.rexceptions())
        printd("byday : " + the_event.byday())
                
                
                
        if self.gpe_access.isevent(event['id']):
            printd("processevents.AddGPEEvent : The event exists in GPE database")
            self.gpe_access.update_event(
                            the_event.start_date(),
                            the_event.duration(),
                            the_event.recur(),
                            the_event.rend(),
                            gpe_calendarid,
                            the_event.eventid(),
                            the_event.rcount(),
                            the_event.rincrement(),
                            the_event.modified(),
                            the_event.byday(),
                            the_event.rexceptions(),
                            the_event.summary(),
                            the_event.description(),
                            the_event.modified(),
                            the_event.location(),
                            )
        else:
            printd("processevents.AddGPEEvent : The event does not exist in GPE database")
            self.gpe_access.add_event(
                            the_event.start_date(),
                            the_event.duration(),
                            the_event.recur(),
                            the_event.rend(),
                            gpe_calendarid,
                            the_event.eventid(),
                            the_event.rcount(),
                            the_event.rincrement(),
                            the_event.modified(),
                            the_event.byday(),
                            the_event.rexceptions(),
                            the_event.summary(),
                            the_event.description(),
                            the_event.modified(),
                            the_event.location(),
                            )
                 
        printd("** Exiting in Processevents.CreateGPEEvent")
        
    
    def get_timedelta(self):
        """return the timestamp difference between Google and local system"""
    
        google_timestamp = self.google_access.get_google_timestamp()
        system_timestamp = time.time()
        printd("processevents.get_timedelta : system timestamp : %s" % (system_timestamp))
        delta = google_timestamp  - system_timestamp        
        printd("processevents.get_timedelta : timedelta : %s" % (delta))
               
        return delta


    def deleting_confirmation(self, parentwindow, events_count):
        """
        Display a confimation popup
        """
        message = "You are about to delete\n %s Google events" % (events_count)
        dialog = hildon.Note ("confirmation", (parentwindow, message, gtk.STOCK_DIALOG_WARNING) )
        dialog.set_button_texts ("Ok", "Abort") 
        response = dialog.run() 
        dialog.destroy() 
        if response == gtk.RESPONSE_OK: 
            printd("processevents : deleting_confirmation : continue")
            return 1
        else: 
            printd("processevents : deleting_confirmation : abort")
            return 0 
