import os.path
import os
import sqlite
import sys
from erminigdates import exdate_to_rexception
import string
import time, datetime
import calendar

from utils import *

class GpeObj:

    def init_gpe_params(self):
        # Connection to the gpecalendar database
        if os.path.isfile("/home/user/.gpe/calendar"):
            self.gpeconnection = sqlite.connect('/home/user/.gpe/calendar')
        elif os.path.isfile("/home/pascal/.gpe/calendar"):
            self.gpeconnection = sqlite.connect('/home/pascal/.gpe/calendar')
        elif os.path.isfile('calendar'):
            self.gpeconnection = sqlite.connect('calendar')
        else:
            return False
            
        self.gpecursor = self.gpeconnection.cursor()
	return True
        

    def load_gpe_calendars(self):
        # Get the list of gpe calendars
        query = "SELECT ROWID,title FROM calendars"
        self.gpecursor.execute(query)
        self.gpecalendars = self.gpecursor.fetchall()
        printd(self.gpecalendars, False)
        return 1

    def isevent(self, eventid):
        query = "SELECT * FROM events WHERE eventid ='" + eventid + "'"
        printd("gpe_service.isevent : query : " + query)
        self.gpecursor.execute(query)
        tmpevents = self.gpecursor.fetchall()
        if (len(tmpevents) >0):
            return 1
        else:
            return 0
        
        
    def getnewevents_count(self, calendarid):
        """Return the count new events in GPE Calendar
        """
        printd("gpe_service.getnewevents_count : entering")
        new_recurrent_events=[]
        query = "SELECT * FROM events WHERE eventid NOT LIKE '%#%' AND calendar=" + calendarid
        printd("gpe_service.getnewevents_count : query : " + query)
        self.gpecursor.execute(query)
        tmpnewevents = self.gpecursor.fetchall()
        count = len(tmpnewevents)
        printd("gpe_service.getnewevents_count : new events count : %s" % (count))
        return count

    def getnewevents(self, calendarid):
        """Return the new events as a list of list
        (uid, title, description, location, startdate, duration)
        """
        printd("gpe_service.getnewevents : entering")
        new_recurrent_events=[]
        query = "SELECT * FROM events WHERE eventid NOT LIKE '%#%' AND calendar=" + calendarid
        printd("gpe_service.getnewevents : query : " + query)
        self.gpecursor.execute(query)
        tmpnewevents = self.gpecursor.fetchall()
        printd("GPE new updated events : ")
        printd(tmpnewevents, False)
        for event in tmpnewevents:
            uid = event[0]
            startdate = event[1]
            duration = event[2]
            eventid = event[7]
            recur = event[3]
            rend = event[4]
            rcount = event[8]
            rincrement = event[9]
            byday = event[11]
            rexceptions = event[12]

            # Get infos from calendar table
            query = "SELECT * FROM calendar WHERE uid=" + str(uid)
            printd(query)
            self.gpecursor.execute(query)    
            data = self.gpecursor.fetchall()
            gpeevents = []
            if data: gpeevents = [list(row) for row in data]
            printd(gpeevents, False)
            try:
                description = "%s" % [x[2] for x in gpeevents \
                                      if "description" in x][0]
            except:
                description = ''
            try:
                title = "%s" % [x[2] for x in gpeevents if "summary" in x][0]
            except:
                title = ''
            try:
                location = "%s" % [x[2] for x in gpeevents \
                                   if "location" in x][0]
            except:
                location = ''
            if (byday == None): byday = 'NULL';
            if (rexceptions == None): rexceptions = 'NULL';
            new_recurrent_events.append((uid, eventid, title, description,
                                         location, startdate, duration,
                                         recur, rend, rcount, rincrement,
                                         byday, rexceptions))

        printd(str(new_recurrent_events))

        return new_recurrent_events


    def getdeletedevents_count(self, calendarid):
        """Return the count deleted events in GPE Calendar
        """
        printd("gpe_service.getdeletedevents_count : entering")
        new_recurrent_events=[]
        query = "SELECT eventid FROM events_deleted WHERE \
                     calendar=" + calendarid + \
                                    " AND eventid LIKE '%#%'"
        printd("gpe_service.getdeletedevents_count : query : " + query)
        self.gpecursor.execute(query)
        tmpnewevents = self.gpecursor.fetchall()
        count = len(tmpnewevents)
        printd("gpe_service.getdeletedevents_count : deleted events count : %s" % (count))
        return count

    def getdeletedevents(self, calendarid):

        query = "SELECT eventid FROM events_deleted WHERE \
                     calendar=" + calendarid + \
                                    " AND eventid LIKE '%#%'"
        printd(query)
        self.gpecursor.execute(query)
        newevents = self.gpecursor.fetchall()
        newevents = [x[0] for x in newevents]
        printd("GPE deleted events : ")
        printd(newevents, True)
        return newevents
    
    
    def getupdatedevents_count(self, calendarid, modified_date):
        """Return the count updated events in GPE Calendar
        """
        printd("gpe_service.getupdatedevents_count : entering")
        new_recurrent_events=[]
        query = "SELECT * FROM events WHERE eventid LIKE '%#%'"\
                   " AND calendar=" + calendarid + " AND modified > " + modified_date
        printd("gpe_service.getupdatedevents_count : query : " + query)
        self.gpecursor.execute(query)
        tmpnewevents = self.gpecursor.fetchall()
        count = len(tmpnewevents)
        printd("gpe_service.getupdatedevents_count : updated events count : %s" % (count))
        return count

    def getupdatedevents(self, calendarid, modified_date):
        updatedevents=[]
        query = "SELECT * FROM events WHERE eventid LIKE '%#%'"\
                   " AND calendar=" + calendarid + " AND modified > " + modified_date
        printd("gpe_service.getupdatedevents : " + query)
        self.gpecursor.execute(query)
        tmp_updated_events = self.gpecursor.fetchall()
        printd("gpe_service.getupdatedevents : GPE new recurrent events : ")
        printd(tmp_updated_events, False)
        for event in tmp_updated_events:
            uid = event[0]
            startdate = event[1]
            duration = event[2]
            eventid = event[7]
            recur = event[3]
            rend = event[4]
            rcount = event[8]
            rincrement = event[9]
            byday = event[11]
            rexceptions = event[12]

            # Get infos from calendar table
            query = "SELECT * FROM calendar WHERE uid=" + str(uid)
            printd(query)
            self.gpecursor.execute(query)    
            data = self.gpecursor.fetchall()
            gpeevents = []
            if data: gpeevents = [list(row) for row in data]
            print gpeevents
            try:
                description = "%s" % [x[2] for x in gpeevents \
                                      if "description" in x][0]
            except:
                description = ''
            try:
                title = "%s" % [x[2] for x in gpeevents if "summary" in x][0]
            except:
                title = ''
            try:
                location = "%s" % [x[2] for x in gpeevents \
                                   if "location" in x][0]
            except:
                location = ''
            updatedevents.append((uid, eventid, title, description,
                                         location, startdate, duration,
                                         recur, rend, rcount, rincrement,
                                         byday, rexceptions))

        printd(str(updatedevents))

        return updatedevents


    def purgedeletedevents(self, calendarid):
        self.gpecursor.execute('DELETE FROM events_deleted where calendar=' \
                               + calendarid)
        # Execute the query
        self.gpeconnection.commit()
        # Purge the checkpoint table
        printd('GPE database : Delete events really deleted')

    def purgeevents(self, calendarid):
        printd("Entering in gpe.purgeevents()")
        query = 'select uid from events WHERE calendar = ' + calendarid
        printd (query)
        self.gpecursor.execute(query)
        events = self.gpecursor.fetchall()

        for event in events:
            query='DELETE FROM calendar WHERE uid=' + str(event[0])
            printd (query)
            self.gpecursor.execute(query)
            self.gpeconnection.commit()

        # Purge the events table
        query='DELETE FROM events where calendar=' + calendarid
        printd(query)
        self.gpecursor.execute(query)
        # Execute the query
        self.gpeconnection.commit()
        
        # Purge the deleted_events table
        query='DELETE FROM events_deleted'
        printd(query)
        self.gpecursor.execute(query)
        # Execute the query
        self.gpeconnection.commit()
        
        printd('GPE database emptied !!')
        

    def deleteevent(self, eventid):
        printd("Entering in gpe.deleteevent()")
        query = "select uid from events WHERE eventid = '" + eventid + "'"
        printd(query)
        self.gpecursor.execute(query)
        events = self.gpecursor.fetchall()

        for event in events:
            query = 'DELETE FROM calendar WHERE uid=' + str(event[0])
            printd (query)
            self.gpecursor.execute(query)
            self.gpeconnection.commit()
            query = 'DELETE FROM events WHERE uid=' + str(event[0])
            printd (query)
            self.gpecursor.execute(query)
            self.gpeconnection.commit()

        printd('GPE event deleted :' + eventid)
        

    def delete_deletedevent(self, eventid):
        printd("Entering in gpe.delete_deletedeventevent()")
        query = "DELETE FROM events_deleted WHERE eventid = '" + eventid + "'"
        self.gpecursor.execute(query)
        self.gpeconnection.commit()

        printd('GPE deleted event deleted :' + eventid)    

        
    def add_event(self, start, duration, recur, rend, calendar,
                            eventid, rcount, 
                            rincrement, modified, byday, rexceptions,
                            title, content, published, location):
        """Add an event in the GPE Calendar database"""
    
        printd("** Entering in gpe.add_recurrent_event()")
        
        query = """INSERT INTO events 
            (start, duration, recur, rend, alarm,
            calendar, eventid, rcount, rincrement,
            modified, byday, rexceptions)
            VALUES 
            ('%s', '%s', %s, %s, 0, %s, '%s', %s, %s, '%s',  '%s', '%s');""" \
            % (start, duration, recur, rend, calendar, eventid, \
                 rcount, rincrement, modified, byday, rexceptions)
        printd(query)
        self.gpecursor.execute(query)
        self.gpeconnection.commit()
        self.gpecursor.execute("SELECT uid FROM events WHERE eventid = '" \
                           + eventid + "' AND calendar=" + calendar)
        result = self.gpecursor.fetchall()
        printd("New uid : " + str(result[0][0]))
        query = "insert into calendar (uid, tag, value) VALUES ('" \
            + str(result[0][0]) + "','sequence','0');"
        printd(query)
        self.gpecursor.execute(query)
        self.gpeconnection.commit()
        query = "insert into calendar (uid, tag, value) VALUES ('" \
            + str(result[0][0]) + "','summary','" + title + "');"
        printd(query)
        self.gpecursor.execute(query)
        self.gpeconnection.commit()
        query = "insert into calendar (uid, tag, value) VALUES ('" \
            + str(result[0][0]) + "','description','" + content + "');"
        printd(query)
        self.gpecursor.execute(query)
        self.gpeconnection.commit()
        query = "insert into calendar (uid, tag, value) VALUES ('" \
            + str(result[0][0]) + "','location','" + location + "');"
        printd(query)
        self.gpecursor.execute(query)
        self.gpeconnection.commit()
        printd("** Exiting gpe.add_recurrent_event()")
        
    
    def update_event(self, start, duration, recur, rend, calendar,
                            eventid, rcount, 
                            rincrement, modified, byday, rexceptions,
                            title, content, published, location):
        """Update an event in the GPE Calendar database"""
    
        printd("** Entering in gpe.add_recurrent_event()")
        
        query = """UPDATE events SET 
            start='%s', duration='%s', recur='%s', rend=%s, alarm=0,
            calendar='%s', rcount='%s', rincrement='%s',
            modified='%s', byday='%s', rexceptions='%s' WHERE eventid='%s';""" \
            % (start, duration, recur, rend, calendar, \
                 rcount, rincrement, modified, byday, rexceptions, eventid)
        printd("gpe_service.update_event : update query : " + query)
        self.gpecursor.execute(query)
        self.gpeconnection.commit()
        
        self.gpecursor.execute("SELECT uid FROM events WHERE eventid = '" \
                           + eventid + "' AND calendar=" + calendar)
        result = self.gpecursor.fetchall()
        uid = str(result[0][0])
        printd("gpe_service.update_event : GPE uid to update : " + uid)

        query = """UPDATE calendar SET 
                     value='%s' 
                     WHERE uid='%s' AND tag='summary';""" % (title, uid)
        printd("gpe_service.update_event : update query : " + query)
        self.gpecursor.execute(query)
        self.gpeconnection.commit()
        
        query = """UPDATE calendar SET 
                     value='%s' 
                     WHERE uid='%s' AND tag='description';""" % (content, uid)
        printd("gpe_service.update_event : update query : " + query)
        self.gpecursor.execute(query)
        self.gpeconnection.commit()
        
        query = """UPDATE calendar SET 
                     value='%s' 
                     WHERE uid='%s' AND tag='location';""" % (location, uid)
        printd("gpe_service.update_event : update query : " + query)
        self.gpecursor.execute(query)
        self.gpeconnection.commit()        

        printd("gpe_service.update_event : Exiting gpe.add_recurrent_event()")
        

    def get_invalid_events(self, calendarid):
        """Get the list of events not supported for google import
        """
        invalid_events = []
        query = "SELECT * FROM events WHERE rcount > 0 AND calendar=" + calendarid
        printd("gpe_service : getinvalidevents : qurey : ")
        self.gpecursor.execute(query)
        tmp_invalid_events = self.gpecursor.fetchall()
        for event in tmp_invalid_events:
            uid = event[0]
            startdate = event[1]
            duration = event[2]
            eventid = event[7]
            recur = event[3]
            rend = event[4]
            rcount = event[8]
            rincrement = event[9]
            byday = event[11]
            rexceptions = event[12]

            # Get infos from calendar table
            query = "SELECT * FROM calendar WHERE uid=" + str(uid)
            printd(query)
            self.gpecursor.execute(query)    
            data = self.gpecursor.fetchall()
            gpeevents = []
            if data: gpeevents = [list(row) for row in data]
            printd(gpeevents, True)
            try:
                description = "%s" % [x[2] for x in gpeevents \
                                      if "description" in x][0]
            except:
                description = ''
            try:
                title = "%s" % [x[2] for x in gpeevents if "summary" in x][0]
            except:
                title = ''
            try:
                location = "%s" % [x[2] for x in gpeevents \
                                   if "location" in x][0]
            except:
                location = ''
            invalid_events.append((uid, eventid, title, description,
                                         location, startdate, duration,
                                         recur, rend, rcount, rincrement,
                                         byday, rexceptions))

        return invalid_events
    
    
    def change_id(self, old_id, new_id):
        """Change the ID of GPE event to another"""
        printd("gpe_service.change_id : Entering")
        new_id = string.replace(new_id, "%", "#")
        old_id = string.replace(old_id, "%", "#")
        query = "UPDATE events SET eventid='" + new_id +\
                            "' WHERE eventid='" + old_id + "'"
        printd("gpe_service.change_id : query : " + query)
        self.gpecursor.execute(query)
        self.gpeconnection.commit()
        printd("gpe_service.change_id : Exiting")
        
        
    def delete_occurence(self, eventid, occurrence):
        printd("gpe_service : delete_occurence : entering")
        printd("gpe_service : delete_occurence : eventid : " + eventid)
        printd("gpe_service : delete_occurence : occurrence : " + occurrence)
        if 'T' in occurrence : 
            occurrence = str(calendar.timegm(
                                      time.strptime(occurrence,"%Y%m%dT%H%M%S"))) + ","
            printd("gpe_service : delete_occurence : occurence : " + occurrence)
        else:
            occurrence = str((int(time.mktime(time.strptime(
                        occurrence, "%Y%m%d"))))) + ","
        printd("gpe_service.delete_occurence : occurence : "+ occurrence)
        
        self.gpecursor.execute("SELECT rexceptions FROM events WHERE eventid = '" \
                           + eventid + "'")
        result = self.gpecursor.fetchall()
        printd("gpe_service.delete_occurence : list of exceptions before : "\
                       + occurrence)
        if (result):
            rexceptions = str(result[0][0])
            rexceptions = rexceptions + ", " + occurrence
            printd("gpe_service.delete_occurence : list of exceptions after : "\
                           + rexceptions)
            query = "UPDATE events SET rexceptions='" + rexceptions +\
                                "' WHERE eventid='" + eventid + "'"
            printd("pe_service.delete_occurence : query : " + query)
            self.gpecursor.execute(query)
            self.gpeconnection.commit()
