import time, datetime
import string

class GpeEvent(dict):
    "Store a Gpe event"
    
    def __init__(self):
        self['start'] = None
        self['duration'] = None
        self['recur'] = None
        self['rend'] = None
        self['calendar'] = None
        self['eventid'] = None
        self['rcount'] = None
        self['rincrement'] = None
        self['modified'] = None   
        self['byday'] = None
        self['rexceptions'] = None
        self['summary'] = None
        self['description'] = None
        self['location'] = None
               

    def title(self):
        "Return GPE title as a Google title"
        return unicode( self['summary'], "utf-8" )
        
        
    def content(self):
        "Return GPE content as a Google description"
        return unicode( self['description'], "utf-8" )
        
        
    def where(self):
        "Return the Google location of the GPE event"    
        return unicode( self['location'], "utf-8" )
        
        
    def start_date(self):
        "Return the Google start date of the GPE event"
        startdate = self['start']
        if " " in startdate:
            startdate = string.replace(startdate, " ", "T")  + "Z"
            
            #startdate = datetime.datetime.fromtimestamp(
            #   time.mktime(time.strptime(startdate, "%Y-%m-%d %H:%M:%S")))
            # print "GPE Start date : %s" % startdate
            #startdate = startdate.strftime("%Y-%m-%dT%H:%M:%SZ")
        #else:
            #startdate = \
            #   datetime.datetime.fromtimestamp(
            #    time.mktime(time.strptime(startdate, "%Y-%m-%d")))
    
            #startdate = startdate.strftime("%Y-%m-%d")
        return (startdate)

        
    def end_date(self):
        "Return the Google end date of the GPE event"
        startdate = self['start']
        duration = self['duration']
        if (duration == 0): duration = 1
        if " " in startdate:
            startdate = \
                datetime.datetime.fromtimestamp(
                time.mktime(time.strptime(startdate, "%Y-%m-%d %H:%M:%S")))
            duration = datetime.timedelta(seconds=duration - 1)
            enddate = startdate + duration
            enddate = enddate.strftime("%Y-%m-%dT%H:%M:%SZ")
        else:
            startdate = \
                datetime.datetime.fromtimestamp(
                time.mktime(time.strptime(startdate, "%Y-%m-%d")))
        
            duration = datetime.timedelta(seconds=duration)
            enddate = startdate + duration
            enddate = enddate.strftime("%Y-%m-%d")
        return (enddate)
        
        
    def rstring(self):
        if (self['recur'] == 0): return None
        rstring = ""
        interval =""
        limit = self['rend']
        start_date = self.start_date()
        end_date = self.end_date()
        
        if (limit == None):
            limit = ""
        else:
            if (" " in limit):
                limit = (string.replace(limit.split(' ')[0], "-", "") + "T"
                    + (("%02d") % ((int(start_date.split('T')[1][0:2]))))
                    + start_date.split('T')[1][2:])
            else:
                limit = datetime.datetime.strptime(limit, "%Y-%m-%d")
                limit = limit - datetime.timedelta(days=1)
                limit = limit.strftime("%Y%m%d")
            limit = string.replace(limit, ":", "")
            limit = ";UNTIL=%s" % (limit)
        
        #The type of recurrency
        if (self['recur'] == 1):
            freq = "FREQ=DAILY"
        if (self['recur'] == 2):
            freq = "FREQ=WEEKLY"
        if (self['recur'] == 3):
            freq = "FREQ=MONTHLY"
        if (self['recur'] == 4):
            freq = "FREQ=YEARLY"
            
        #The incrementation
        if (self['rincrement'] > 1):
            interval = ";INTERVAL=%s" % (self['rincrement'])
            
        #The exceptions
        exceptions = string.split(self['rexceptions'], ",")
        #Sometimes, there is 0 in rexceptions, so I delete it
        print exceptions
        while "0" in exceptions: exceptions.remove("0")
        while "" in exceptions: exceptions.remove("")
        #sometimes exceptions only contains 0
        print len(exceptions)
        if (len(exceptions) == 0): exceptions = ["NULL"]
        print exceptions
        exdate =""
        if "NULL" not in exceptions[0]:            
            for a_exception in exceptions:
                if ("T" in start_date):
                    #It's not an all-day event
                    exception_date = \
                        datetime.datetime.utcfromtimestamp(float(a_exception))
                    exception_date = exception_date.strftime("%Y-%m-%dT%H:%M:%S")
                else:
                    #It's an all-day event
                    exception_date = \
                        datetime.date.fromtimestamp(float(a_exception))
                    exception_date = exception_date.strftime("%Y-%m-%d")
                exception_date = string.replace(exception_date, "-", "")
                exception_date = string.replace(exception_date, ":", "")
                exdate = exdate + "EXDATE;TZID=Etc/GMT:" + \
                                exception_date +"\r\n"
            print exdate
            
        start_date = string.replace(start_date, "-", "")
        start_date = string.replace(start_date, ":", "")
        end_date = string.replace(end_date, "-", "")
        end_date = string.replace(end_date, ":", "")
        
        rstring = ('DTSTART;TZID=Etc/GMT:%s\r\n'
        + 'DTEND;TZID=Etc/GMT:%s\r\n'
        + 'RRULE:%s%s%s\r\n%s') \
        % (start_date,end_date,freq,interval,limit,exdate)
        return rstring
        
        
if __name__=='__main__':

    pass
