#!/usr/bin/python

import ConfigParser
import os.path
import os
import gdata.calendar.service
import gdata.service
import atom.service
import gdata.calendar
import string, time, datetime
import erminigdates
import calendar

from utils import *	

class GoogleObj:

    def init_google_params(self, google_login, google_password, proxy_params):
	self.googleConnected = False
        
        if (proxy_params):
            #Set proxy parameters
            os.environ['http_proxy'] = proxy_params[0]
            os.environ['https_proxy'] = proxy_params[1]
            os.environ['proxy-username'] = proxy_params[2]
            os.environ['proxy-password'] = proxy_params[3]
            printd(os.environ.get('http_proxy'))
            printd(os.environ.get('https_proxy'))
            printd(os.environ.get('proxy-username'))
            printd(os.environ.get('proxy-password'))
        else:
            try:
                del os.environ['http_proxy']
            except:
                pass
            try:
                del os.environ['https_proxy']
            except:
                pass
            try:
                del os.environ['user-proxy']
            except:
                pass
            try:
                del os.environ['password-proxy']
            except:
                pass
        
        self.cal_client = gdata.calendar.service.CalendarService()
        self.cal_client.email = google_login
        self.cal_client.password = google_password
        self.cal_client.source = 'Google-Calendar_Python_Sample-1.0'
        try:
            self.cal_client.ProgrammaticLogin()
	    self.googleConnected = True
        except gdata.service.BadAuthentication, err:
            self.error = str(err)
	    self.googleConnected = False
        

        
    
    def load_google_calendars(self, owner_only=True):
        """ owner_only : if true, we only list the calendar we own
        otherwise we list all the subscribed one.
        """
        self.isgoogleready = 0
        #Get the Google agendas
        try:
            feed = self.cal_client.GetCalendarListFeed()
        except:
            self.isgoogleready = 0
            return 0
        printd(feed)
        if owner_only:
            condition = lambda x: (('owner' in x.access_level.value) or
                                                ('editor' in x.access_level.value) or
                                                ('read' in x.access_level.value) or
                                                ('root' in x.access_level.value))
        else:
            condition = lambda x: True
        self.googlecalendars = \
            [(x.id.text[63:],x.title.text,x.timezone.value,x.access_level.value) \
                for x in feed.entry if condition(x)]
        printd(self.googlecalendars, True)
        self.isgoogleready = 1
        return 1
        

    def delete_event(self, eventid):
        printd("Deleting google event : " + str(eventid))
        eventid = string.replace(eventid, "composite", "full")
        try:
            deleted_event = self.cal_client.GetCalendarEventEntry(eventid)   
            self.cal_client.DeleteEvent(deleted_event.GetEditLink().href)         
        except:
            pass
        


    def addevent(self, calendarid, startdate, enddate,
                                  eventid, description, title, location,
                                  rstring):
        """Add an event in Google Calendar
        """
        printd("events to import to Google : %s, %s, %s, %s, %s, %s, %s"\
              % (calendarid,startdate,enddate,eventid,description,title,location))
    
        event = gdata.calendar.CalendarEventEntry()
        event.author.append(atom.Author(name=atom.Name(text='CalendarExample')))
        event.title = atom.Title(text=title)
        event.content = atom.Content(text=description)
        event.where.append(gdata.calendar.Where(value_string=location))
        if (rstring <> None):
            printd( "google_service.addevent : generating rstring")
            #This is a recurrent event, I generate the rstring
            recurrence_data = rstring       
            event.recurrence = gdata.calendar.Recurrence(text=recurrence_data)
        else:
            #This is a single event
            event.when.append(
                  gdata.calendar.When(start_time=startdate, end_time=enddate))
        new_event = self.cal_client.InsertEvent(event,
                                               '/calendar/feeds/'
                                               + calendarid + '/private/full')
        printd("google_service.addevent : Google ID of created event : " + new_event.id.text)
        return new_event.id.text
      
    def updateevent(self, startdate, enddate,
                                  eventid, description, title, location,
                                  rstring):
        """Update an event in Google Calendar
        """
        printd("evenement a updater vers google : %s, %s, %s, %s, %s, %s"\
                         % (startdate,enddate,eventid,description,title,location))
        
        #Loading the event to modify
        eventid = string.replace(eventid, "composite", "full")
        event = self.cal_client.GetCalendarEventEntry(eventid)
        
        #Updating the properties
        event.title = atom.Title(text=title)
        event.content = atom.Content(text=description)
        event.location = location
        for a_location in event.where:
            a_location.value_string = location

        if (rstring <> None):
            printd("generating rstring")
            #This is a recurrent event, I generate the rstring
            recurrence_data = rstring       
            event.recurrence = gdata.calendar.Recurrence(text=recurrence_data)
        else:
            #This is a single event
            event.when[0] = gdata.calendar.When(start_time=startdate, end_time=enddate)

        #Updating the event
        self.cal_client.UpdateEvent(event.GetEditLink().href, event)


    def getevents(self, calendarid, updated_min, updated_max, start_min):

        printd("** Entering in GoogleObj.getevents")
        query = gdata.calendar.service.CalendarEventQuery(calendarid,
                                                     'private', 'composite',
                                                     None, {"ctz":"utc"})
        # Adding 1 second to the google update date
        printd(updated_min, True)
        updated_min = \
            datetime.datetime.fromtimestamp(
            time.mktime(time.strptime(updated_min, "%Y-%m-%dT%H:%M:%S.000Z")))
        
        updated_min = updated_min + datetime.timedelta(seconds = 1)
        updated_min = updated_min.strftime("%Y-%m-%dT%H:%M:%S.000Z")
        printd(("google_service : getevents : date range query : %s, %s") % (updated_min, updated_max))
        query.updated_min = updated_min # Need to add 1 second
        query.updated_max = updated_max
        query.start_min = start_min
        query.start_max = '2020-12-02'
        query.max_results = "1000000"
        feed = self.cal_client.CalendarQuery(query)
        result_entries = []
        #print feed
        last_feed_update = feed.updated.text
        printd ("google_service : getevents : date of the feed : " + 
               last_feed_update)
        
        for event in feed.entry:
            dentry = {}            
            dentry['id'] = event.id.text
            dentry['published'] = event.published.text
            dentry['updated'] = event.updated.text
            dentry['title'] = event.title.text
            try:
                dentry['content'] = event.content.text
            except:
                dentry['content'] = ""
            for a_location in event.where:
                dentry['location'] = a_location.value_string
            for a_when in event.when:
                dentry['startTime'] = a_when.start_time
                dentry['endTime'] = a_when.end_time
            if dentry['content'] == None:
                dentry['content'] = ""
            if dentry['location'] == None:
                dentry['location'] = ""
            if event.recurrence <> None:
                dentry['rstring'] = event.recurrence.text
            dentry['rexceptions'] = []
            for exception in event.recurrence_exception:
                dentry['rexceptions'].append(
                            exception.entry_link.entry.when[0].start_time)
            result_entries.append(dentry)
            dentry['status'] = event.event_status.value
            dentry['google_event'] = event
            printd("result_entries : ")
        printd(result_entries, True)
        printd("** Ending in GoogleObj.getevents")
        return result_entries, last_feed_update
        

    def get_google_timestamp(self):
        """ owner_only : if true, we only list the calendar we own
        otherwise we list all the subscribed one.
        """
        
        #Get the Google agendas
        feed = self.cal_client.GetCalendarListFeed()        

        printd("google_service.get_google_timestamp : feed : %s" % (feed))
        utc_google_time = time.strptime(feed.updated.text[0:19], "%Y-%m-%dT%H:%M:%S")
        
        printd("google_service.get_google_timestamp : utc Google time : %s"\
                        % (utc_google_time))
                        
        google_timestamp = calendar.timegm(utc_google_time)
        
        printd("google_service.get_google_timestamp : Google time : %s"\
                        % (google_timestamp))
                        
        return google_timestamp
    

if __name__=='__main__':
    import sys
    g_access = GoogleObj()
    g_access.init_google_params(sys.argv[1], sys.argv[2])
    g_access.load_google_calendars(False)
    

    
    

