
from erminigdates import googledatetodatetime
import time, string, datetime
from datetime import timedelta
import calendar


class GoogleEvent(dict):
    "Store a Google event"
    
    def __init__(self):
        self["updated"] = None
        self["title"] = None
        self["content"] = None
        self["recurrence"] = ""
        self["exceptions"] = None
        self["location"] = None
        self["start_date"] = None
        self["end_date"] = None
        self["id"] = None 
        self["timezone"] = None        
               

    def summary(self):
        "Return Google title as a GPE title"
        if (self['title'] == None):
            title =""
        else:
            title = string.replace(self['title'], "'", "''")        
        return title
        
        
    def description(self):
        "Return Google content as a GPE description"
        if (self['content'] == None):
            content =""
        else:
            content = string.replace(self['content'], "'", "''")        
        return content
        
        
    def duration(self):
        "Return the GPE duration of the Google event"    
        duration = googledatetodatetime(self["end_date"]) - \
                          googledatetodatetime(self["start_date"])
        if ("T" in self["start_date"]):
            #It's not an all-day event
            duration = str(duration.days*24*3600 + duration.seconds + 1)
        else:
            duration = str(duration.days*24*3600 + duration.seconds)
        return  duration
        
        
    def start_date(self):
        "Return the GPE start date of the Google event"
        print("google_event : start_date : entering")
        if self['recurrence']:
            #It's a recurrent event
            #I get the start date in the rstring
            print("google_event : start_date : It s a recurring event")
            print("google_event : start_date : rstring : " + self['recurrence'])
            rstring = self['recurrence'].split('\n')
            start_date = (rstring[0].split(':'))[1][0:15]  #Pas optimise
            print("google_event : start_date : parsed start date  : " + start_date)
            if ('T' in start_date):
                start_date = googledatetodatetime(start_date)
                start_date = start_date.strftime("%Y-%m-%d %H:%M:%S")
            else:
                start_date = googledatetodatetime(start_date)
                start_date = start_date.strftime("%Y-%m-%d")
        else:
            #It's a single event
            #I get the start date in usualy field
            print("google_event : start_date : It s a single event")
            start_date = string.replace(self['start_date'], "T", " ")
            start_date = start_date[0:19]
            
        print("google_event : start_date : return : " + start_date)
        return start_date
        
        
    def recur(self):
        "Return the GPE recur of the Google event"
        recur = 0
        if self['recurrence']:
            rstring = self['recurrence'].split('\n')
            #Sometime RRULE does not exists
            if len(rstring[2]) != 0 :
                for rrule in (rstring[2].split(':'))[1].split(';'):  #Pas optimise
                    if "FREQ" in rrule:
                        repeat = rrule.split("=")[1]
                        if (repeat == 'DAILY'): recur = 1
                        if (repeat == 'WEEKLY'): recur = 2
                        if (repeat == 'MONTHLY'): recur = 3
                        if (repeat == 'YEARLY'): recur = 4
            else:
                #If no RRULE, recur may be DAILY
                recur = 1
        return(str(recur))
        
        
    def eventid(self):
        "Return Google id as a GPE eventid"
        return self['id']
        
        
    def rend(self):
        "Return the GPE rend (limit) of the Google event"
        print "google_event : rend : entering : "
        print "google_event : rend : rstring : " + self['recurrence']
        rend ="NULL"
        
        if self['recurrence']:
            rstring = self['recurrence'].split('\n')
            #Sometime RRULE does not exists
            if len(rstring[2]) != 0 :
                rstring = self['recurrence'].replace(' ', '')
                rstring = rstring.replace("\n", '')
                rstring = rstring.split(';')
                print rstring
                for line in rstring:
                    if (("UNTIL" in line) and ("T" in self["start_date"])):
                        print("google_event : rend : UNTIL found")
                        until = line[6:21]
                        until = googledatetodatetime(until)                    
                        end_date = googledatetodatetime(self["end_date"])
                        #Need to concatene until date and end hour
                        print("google_event : rend : until date : %s" % (until))
                        print("google_event : rend : end date : %s" % (end_date))
                        rend = datetime.datetime.combine(until.date(), end_date.time())
                        rend = rend.strftime("'%Y-%m-%d %H:%M:%S'")
                        print("google_event : rend : combined date : %s" % (rend))
                    if (("UNTIL" in line) and ("T" not in self["start_date"])):
                        rend = line[6:14]
                        rend = datetime.datetime.strptime(rend, "%Y%m%d")
                        rend = rend + timedelta(days=1)
                        rend = rend.strftime("'%Y-%m-%d'")
                print "google_event : rend : rend : " + rend
            else :
                end_date = googledatetodatetime(self["end_date"])
                rend = end_date.strftime("'%Y-%m-%d %H:%M:%S'")
                    
                    
                    
        print "google_event : rend : exiting : "   
        return rend
    
    
    def rincrement(self):
        "Return the GPE recur of the Google event"
        interval =0
        if self['recurrence']:
            rstring = self['recurrence'].split('\n')
            interval = 1
            #Sometime RRULE does not exists
            if len(rstring[2]) != 0 :
                for rrule in (rstring[2].split(':'))[1].split(';'):
                    if "INTERVAL" in rrule:
                        interval = rrule.split("=")[1]
        return(str(interval))
        
        
    def modified(self):
        "Return the GPE recur of the Google event"
        tmp = "%u" % (time.time())
        return tmp
        
    def byday(self):
        "Return the GPE recur of the Google event"
        byday = "(NULL)"
        if self['recurrence']:
            rstring = self['recurrence'].split('\n')
            #Sometime RRULE does not exists
            if len(rstring[2]) != 0 :
                for rrule in (rstring[2].split(':'))[1].split(';'):
                    if "BYDAY" in rrule:
                        byday = rrule.split("=")[1]
        return(byday)
        
        
    def rcount(self):
        """Return the GPE rcount of the Google event
        Does not exist in Gogole Calendar"""
        return "0"
        
        
    def rexceptions(self):
        "Return the GPE rexceptions of the Google event"
        rexception = ""
        if "EXDATE" in self["recurrence"]:
            print "Recurrence : " + self["recurrence"]
            #Exceptions are in the rstring (EXDATE)
            rstring = self['recurrence'].split('\n')
            #exdate = "%s" % [x for x in rstring if "EXDATE" in x][0]
            exdate = [x for x in rstring if "EXDATE" in x]
            print "exdate : " + str(exdate)
            
            for a_exdate in exdate:
                a_exdate = a_exdate.split(':')[1]
                #If it's not an allday event
                #sometimes, EXDATE is invalid
                try:
                    print("google_event : rexceptions : google exception : " + a_exdate)
                    if (('T' in a_exdate) and ('Z' not in a_exdate)):                     
                        rexception = rexception + \
                                    str((int(time.mktime(time.strptime(
                                    a_exdate, "%Y%m%dT%H%M%S"))))) + ","
                    elif (('T' in a_exdate) and ('Z' in a_exdate)): 
                        rexception = rexception + \
                                    str((int(time.mktime(time.strptime(
                                    a_exdate, "%Y%m%dT%H%M%SZ"))))) + ","
                    else:
                        rexception = rexception + \
                                    str((int(time.mktime(time.strptime(
                                    a_exdate, "%Y%m%d"))))) + ","
                except:
                    print "google_event : rexceptions : Corrupt EXDATE detected"
                
        #Exceptions are in recurrence_exception attribute
        for a_exception in self["exceptions"]:
            if 'T' in a_exception:
                #It's not an allday event
                rexception = rexception + str(calendar.timegm(
                                      time.strptime(a_exception[0:19],"%Y-%m-%dT%H:%M:%S"))) + ","
                print rexception                
            else:
                #It's an allday event
                rexception = rexception + str((int(time.mktime(time.strptime(
                            a_exception[0:10], "%Y-%m-%d"))))) + ","
        
        return rexception[0:-1]
        
        
    def location(self):
        "Return Google location as a GPE location"
        if self['location']:
            location = string.replace(self['location'], "'", "''")
            return location
        else:
            return ""        
        
        
if __name__=='__main__':

    MyEvent = GoogleEvent()
    MyEvent['title'] = "Mon titre"
    #print MyEvent.title()
    
