#!/usr/bin/python

import ConfigParser
import os.path
import os
import string
from utils import *

class conf:

    def write_google_parameters(self,google_login,google_password):
        """Write the google parameters in the config file
        """
        config = ConfigParser.ConfigParser()
        try:
            config.read(os.path.expanduser('~/.erminig.cfg'))
        except:
            pass
        try:
            config.add_section('Google')
        except:
            pass
        config.set('Google', 'GoogleLogin', google_login)
        config.set('Google', 'GooglePassword', google_password)
        try:
            config.write(open(os.path.expanduser('~/.erminig.cfg'),'w'))
        except:
            return 0
        self.google_login = google_login
        self.google_password = google_password
        printd("GoogleLogin : " + google_login)
        printd("GooglePassword : ")

    def load_configuration(self):
        self.load_google_configuration()
        self.load_proxy_configuration()
        self.load_profiles()

    def load_google_configuration(self):
        """Loading the parameters from the configuration file
        """
        printd("Loading parameters from config file")
        config = ConfigParser.ConfigParser()
        try:
            config.read(os.path.expanduser('~/.erminig.cfg'))
        except:
            pass
        try:
            self.google_login = config.get('Google', 'GoogleLogin')
        except:
            self.google_login = ""
        try:
            self.google_password = config.get('Google', 'GooglePassword')
        except:
            self.google_password = ""

        printd("GoogleLogin : " + self.google_login)
        
        
    def load_proxy_configuration(self):
        """Loading the proxy parameters from the configuration file
        """
        printd("Loading parameters from config file")
        config = ConfigParser.ConfigParser()
        try:
            config.read(os.path.expanduser('~/.erminig.cfg'))
        except:
            pass
        try:
            self.http_proxy = config.get('Proxy', 'http')
        except:
            self.http_proxy = ""
        try:
            self.https_proxy = config.get('Proxy', 'http')
        except:
            self.https_proxy = ""
        try:
            self.user_proxy = config.get('Proxy', 'user')
        except:
            self.user_proxy = ""
        try:
            self.password_proxy = config.get('Proxy', 'password')
        except:
            self.password_proxy = ""

        
    def write_proxy_parameters(self,http_proxy,https_proxy,
                                                              user_proxy,password_proxy):
        """Write the proxy parameters in the config file
        """
        config = ConfigParser.ConfigParser()
        try:
            config.read(os.path.expanduser('~/.erminig.cfg'))
        except:
            pass
        try:
            config.add_section('Proxy')
        except:
            pass
        config.set('Proxy', 'http', http_proxy)
        config.set('Proxy', 'https', https_proxy)
        config.set('Proxy', 'user', user_proxy)
        config.set('Proxy', 'password', password_proxy)
        try:
            config.write(open(os.path.expanduser('~/.erminig.cfg'),'w'))
        except:
            return 0
        self.http_proxy = http_proxy
        self.https_proxy = https_proxy
        self.user_proxy = user_proxy
        self.password_proxy = password_proxy
        

    def load_profiles(self):
        """Loading the profiles from the configuration file
        """
        self.profiles = []
        #First we get the number of profiles
        printd("Loading profiles from config file")
        config = ConfigParser.ConfigParser()
        try:
            config.read(os.path.expanduser('~/.erminig.cfg'))
        except:
            pass
        try:
            profiles_count = config.get('Profiles', 'Count')
        except:
            profiles_count = 0
        if int(profiles_count) <> 0:
            try:
                profiles = config.get('Profiles', 'List')
                printd("Profiles list : " + profiles)
                self.profiles = string.split(profiles,';')
            except:
                return 0

    def delete_profile(self,profile_name):
        """Delete the profile
        """
        config = ConfigParser.ConfigParser()
        try:
            config.read(os.path.expanduser('~/.erminig.cfg'))
        except:
            return 0

        try:
            profiles_count = int(config.get('Profiles', 'Count'))
        except:
            return 0
        profiles_count=profiles_count-1

        try:
            profiles = config.get('Profiles', 'List')
            profiles_list = string.split(profiles,';')
        except:
            profiles_list = []
        profiles_list.remove(profile_name)

        config.set('Profiles', 'Count', str(profiles_count))
        config.set('Profiles',
                   'List', ";".join(["%s" % k for k in profiles_list]))
        config.remove_section(profile_name)
        try:
            config.write(open(os.path.expanduser('~/.erminig.cfg'),'w'))
        except:
            return 0

    def get_profile(self,profile_name):
        """Loading the profile parameters
        """
        printd("Loading profile " + profile_name)
        config = ConfigParser.ConfigParser()
        try:
            config.read(os.path.expanduser('~/.erminig.cfg'))
        except:
            return 0
        try:
            profile_gpecalendarid = config.get(profile_name, 'gpecalendarid')
        except:
            profile_gpecalendarid = ""
        try:
            profile_gpecalendartitle = config.get(profile_name,
                                                  'gpecalendartitle')
        except:
            profile_gpecalendartitle = ""
        try:
            profile_timezone_name = config.get(profile_name,
                                                  'Timezone_Name')
        except:
            profile_timezone_name = ""
        try:
            profile_googlecalendarid = config.get(profile_name,
                                                  'googlecalendarid')
        except:
            profile_googlecalendarid = ""
        try:
            profile_googlecalendartitle = config.get(profile_name,
                                                     'googlecalendartitle')
        except:
            profile_googlecalendartitle = ""
        try:
            profile_gpeupdate = config.get(profile_name,
                                                     'gpeupdate')
        except:
            profile_gpeupdate = "0"
        try:
            profile_googleupdate = config.get(profile_name,
                                                     'googleupdate')
        except:
            profile_googleupdate = "1970-01-01T01:01:01.000Z"
        try:
            profile_enabled = config.get(profile_name,
                                                     'enabled')
            if (profile_enabled == 'False'):
                profile_enabled = False
            else:
                profile_enabled = True
        except:
            profile_enabled = False
        try:
            profile_startdate = config.get(profile_name,
                                                     'startdate')
        except:
            profile_startdate = "1970-01-01"
        try:
            profile_accesslevel = config.get(profile_name,
                                                     'accesslevel')
        except:
            profile_accesslevel = ""


        if (profile_gpeupdate ==''): profile_gpeupdate = '0'
        return (profile_name, profile_googlecalendarid,
                profile_googlecalendartitle, profile_gpecalendarid,
                profile_gpecalendartitle, 
                profile_timezone_name, profile_gpeupdate, profile_googleupdate,
                profile_enabled, profile_startdate, profile_accesslevel)



    def write_profile(self, profilename, selectedgooglecalendartitle,
                      selectedgooglecalendarid, selectedgpecalendartitle,
                      selectedgpecalendarid, timezone_name,
                      gpeupdate, googleupdate, enabled, startdate,
                      accesslevel):

        config = ConfigParser.ConfigParser()
        try:
            config.read(os.path.expanduser('~/.erminig.cfg'))
        except:
            pass

        #find an existing profile
        profiles_list = self.profiles
        
        print profiles_list

        if profilename not in profiles_list:
            #Profile not found, we increment the profiles
            #counter and add the profile name to the list

            #get the profiles count
            try:
                profiles_count = int(config.get('Profiles', 'Count'))
            except:
                profiles_count = 0
            profiles_list.append(profilename)
            print profiles_list
            try:
                config.add_section('Profiles')
            except:
                pass
            config.set('Profiles', 'Count', str(profiles_count + 1))
            print ";".join(["%s" % k for k in profiles_list])
            config.set('Profiles',
                       'List', ";".join(["%s" % k for k in profiles_list]))
            try:
                config.write(open(os.path.expanduser('~/.erminig.cfg'),'w'))
            except:
                return 0

            #Now we write the profile
            #The profile does not exist, so we create a new section
            config.add_section(profilename)
        
        config.set(profilename, 'GoogleCalendarTitle',
                   selectedgooglecalendartitle)
        config.set(profilename, 'GoogleCalendarId', selectedgooglecalendarid)
        config.set(profilename, 'GpeCalendarTitle', selectedgpecalendartitle)
        config.set(profilename, 'GpeCalendarId', selectedgpecalendarid)
        config.set(profilename, 'Timezone_Name', timezone_name)
        config.set(profilename, 'gpeupdate', gpeupdate)
        config.set(profilename, 'googleupdate', googleupdate)
        config.set(profilename, 'enabled', enabled)
        config.set(profilename, 'startdate', startdate)
        config.set(profilename, 'accesslevel', accesslevel)
        try:
            config.write(open(os.path.expanduser('~/.erminig.cfg'),'w'))
        except:
            return 0

    def update_lastupdate(self, profilename, gpe_update, google_update):
        config = ConfigParser.ConfigParser()
        try:
            config.read(os.path.expanduser('~/.erminig.cfg'))
        except:
            pass
        config.set(profilename, 'gpeupdate', gpe_update)
        config.set(profilename, 'googleupdate', google_update)
        try:
            config.write(open(os.path.expanduser('~/.erminig.cfg'),'w'))
        except:
            return 0


if __name__=='__main__':
    a = conf()
    a.load_profiles()


