; guile-based config
;
; (for combo keys)
;
; Part of the Easy Debian chroot package
;

; F5 - Menu key
; F6 - Fullscreen key
; F7 - Plus key
; F8 - Minus key

; Minus followed by Fullscreen key works with all apps
; Minus followed by Menu toggles keyboard
; Minus followed by Plus toggles mini / full keyboard

(define (display-n str)
    "Display a string then newline"
  (display str)
  (newline))

(define (first-binding)
    "First binding"
  (xbindkey-function '(F8) second-binding))
                       
(define (reset-first-binding)
    "reset first binding"
  (display-n "reset first binding")
  (ungrab-all-keys)
  (remove-all-keys)
  (first-binding)
  (grab-all-keys))

(define (second-binding)
    "Second binding"
  (display "New binding")
  (ungrab-all-keys)
  (remove-all-keys)

; Menu key (F4)
  (xbindkey-function 'F4
                     (lambda ()
                       (run-command "/home/user/apps/kbd-toggle")
                       (reset-first-binding)))
; Plus key (F7)
  (xbindkey-function 'F7
                     (lambda ()
                       (run-command "/home/user/apps/kbd-mini")
                       (reset-first-binding)))
; Fullscreen key (F6)
  (xbindkey-function 'F6
                     (lambda ()
                       (run-command "wmctrl -r :ACTIVE: -b toggle,fullscreen")
                       (reset-first-binding)))
  (debug)
  (grab-all-keys))



(first-binding)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; End of xbindkeys configuration ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
