#!/usr/bin/python
#
# dyct - A simple Maemo GUI for the "dict" CLI tool
# Copyright (c) 2010-10-02 Thomas Perl <thpinfo.com>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in
#      the documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
# INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
# OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
# EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

import subprocess
import hildon
import gtk
import pango

try:
    w = hildon.StackableWindow()
except:
    w = gtk.Window()

w.set_title('Dictionary (dict)')

v = gtk.VBox()
w.add(v)

try:
    p = hildon.PannableArea()
except:
    p = gtk.ScrolledWindow()

v.pack_start(p)

try:
    t = hildon.TextView()
except:
    t = gtk.TextView()

p.add(t)

t.set_editable(False)
t.modify_font(pango.FontDescription('monospace bold 11'))

h = gtk.HBox(spacing=5)
v.pack_start(h, False)

h.pack_start(gtk.Label('Search:'), False)

try:
    e = hildon.Entry(0)
except:
    e = gtk.Entry()

h.pack_start(e)

b = gtk.ToolButton(gtk.image_new_from_icon_name('general_delete',
    gtk.ICON_SIZE_LARGE_TOOLBAR))
h.pack_start(b, False)

def do_clear(button, entry):
    entry.set_text('')
    entry.grab_focus()
b.connect('clicked', do_clear, e)

def do_search(entry, textview):
    p = subprocess.Popen(('dict', '--', entry.get_text()),
            stdout=subprocess.PIPE)
    stdout, stderr = p.communicate()
    textview.get_buffer().set_text(stdout)
    entry.select_region(0, -1)

e.connect('activate', do_search, t)
e.grab_focus()

w.connect('destroy', gtk.main_quit)
w.show_all()
gtk.main()

