#!/bin/sh

[ -z "$1" ] && exit 1

RS=`which run-standalone.sh 2> /dev/null|grep run-standalone.sh|grep -v no|wc -l|tr -d " "`

if [ "x$RS" == "x1" ]; then
	run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications   /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog string:"$1" uint32:0 string:'OK'
        exit 0;
fi;

KD=`which kdialog 2> /dev/null|grep kdialog|grep -v no|wc -l|tr -d " "`

if [ "x$KD" == "x1" ]; then
	kdialog --msgbox "$1"; 
	exit 0;
fi; 

ZN=`which zenity 2> /dev/null|grep zenity|grep -v no|wc -l|tr -d " "`

if [ "x$ZN" == "x1" ]; then
	zenity --info --text="$1"
	exit 0;
fi; 

XM=`which xmessage 2> /dev/null|grep xmessage|grep -v no|wc -l|tr -d " "`

if [ "x$XM" == "x1" ]; then
	xmessage "$1"
	exit 0;
fi; 

roxterm -T anyRemote -e "echo \"$1\";read"
