# -*- coding: utf-8 -*-
'''
Advanced Power Shell
2008-2009(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

try:
  import subprocess
except ImportError:
  import os

try: #most distros have a separate gconf
  import gconf
except ImportError: #but Maemo doesn't
  from gnome import gconf

try:
  import hildon
except ImportError:
  pass

import threading, thread
import gobject
gobject.threads_init()

from locale import Locale

class Shell():

  @staticmethod
  def run_async(func, args=(), kwargs={}):
    current_thread = threading.Thread(target=func, args=args, kwargs=kwargs)
    current_thread.start()

  @staticmethod
  def run_command(commandline, info_banner=None):
    if commandline:
      try: #using subprocess.call for python >= 2.5.2
        subprocess.call(commandline, shell=True)
      except NameError: #using os.system for python < 2.5.2
        os.system(commandline)
      if info_banner:
        info_banner.destroy()
        info_banner = None

  @staticmethod
  def run_command_async(commandline, info_banner=None):
    Shell.run_async(Shell.run_command, [commandline, info_banner])

class Format():

  @staticmethod
  def get_time(time, iter=0):
    tmp = ''
    if (time >= 60*60*24):
      tmp = '%s%s' % (str(time / (60*60*24)), Locale.get('time_days'))
      time = time % (60*60*24)
      if (time > 0):
        tmp = '%s, %s' % (tmp, Format.get_time(time, iter + 1))
    elif (time >= 60*60):
      tmp = str(time / (60*60))
      time = time % (60*60)
      if tmp == '0':
        tmp = Format.get_time(time, 1)
      elif time > 0:
        tmp = '%s:%s' % (tmp, Format.get_time(time, 2))
      else:
        tmp = '%s%s' % (tmp, Locale.get('time_hours'))
    elif (time >= 60):
      tmp = str(time / 60)
      time = time % (60)
      if iter < 2:
        tmp = '%s%s' % (tmp, Locale.get('time_minutes'))
      elif len(tmp) == 1:
        tmp = '0%s' % tmp
    else:
      if iter == 0:
        tmp = '<1%s' % Locale.get('time_minutes')
      else:
        tmp = '00'
    return tmp

  @staticmethod
  def get_filesize(value, precision=1):
    div = 1024.0
    tmp = ''
    if (value >= pow(div, 2)):
      tmp = str(round(value / pow(div, 2), precision))
      if tmp.endswith('.0'): tmp = tmp.rsplit('.')[0]
      tmp = '%s%s' % (tmp, Locale.get('GB'))
    elif (value >= div):
      tmp = str(round(value / div, precision))
      if tmp.endswith('.0'): tmp = tmp.rsplit('.')[0]
      tmp = '%s%s' % (tmp, Locale.get('MB'))
    else:
      tmp = '%s%s' % (str(value), Locale.get('KB'))
    return tmp

class Sound():

  system_volume_path = '/apps/osso/sound'
  commands = {'Play sound': 'play-sound'}

  def __init__(self, play_sound=True):
    self.gconf_client = gconf.client_get_default()
    self.sound = play_sound

  def set(self, flag):
    self.sound = flag

  def play(self, sound, override_system=False, volume=None):
    if self.sound and sound:
      if override_system and volume:
        #WHAT'S GOING ON HERE
        #Because of the async gconf work it's to be synced in the way of
        #setting proper values between playing sound.
        #As we need to wait until sound playing is finished only shell command to be used,
        #it's bloocking, so using threads is one of the things to be used here.
        #Since using play-sound shell command, we need to maximize the system alert volume,
        #because play-sounds is using it.
        #In the end we need to set all the volume values back.
        system_volume = self.gconf_client.get_int('%s/master_volume' % self.system_volume_path)
        cmdline = ''
        cmdline_end = ''
        if system_volume != volume:
          #Unfortunetelly setting value is async, so no benefit in this case.
#          self.gconf_client.set_int(self.system_volume_path + '/master_volume', self.config['settings']['sounds-volume']['value'])
          cmdline = '%sgconftool-2 -s -t int %s/master_volume -- %s && ' % (cmdline, self.system_volume_path, str(volume))
          cmdline_end = '%s && gconftool-2 -s -t int %s/master_volume -- %s' % (cmdline_end, self.system_volume_path, str(system_volume))
        else:
          self.play_handler(sound)
          return
        system_alert_volume = self.gconf_client.get_int('%s/system_alert_volume' % self.system_volume_path)
        if system_alert_volume != 2:
          cmdline = '%sgconftool-2 -s -t int %s/system_alert_volume -- 2 && ' % (cmdline, self.system_volume_path)
          cmdline_end = '%s && gconftool-2 -s -t int %s/system_alert_volume -- %s' % (cmdline_end, self.system_volume_path, str(system_alert_volume))
        cmdline = '%s%s %s' % (cmdline, self.commands['Play sound'], sound)
        cmdline = '%s%s &' % (cmdline, cmdline_end)
        Shell.run_command(cmdline)
      else:
        self.play_handler(sound)
        return

  def play_handler(self, sound):
    if hildon:
      hildon.hildon_play_system_sound(sound)
    else:
      Shell.run_command_async('%s %s' % (self.commands['Play sound'], sound))
