# -*- coding: utf-8 -*-
'''
Advanced Power UI Util
2008-2009(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

import gtk, hildon

class Banner():

  @staticmethod
  def show_information(widget, text=''):
    hildon.hildon_banner_show_information(widget, None, text)

  @staticmethod
  def show_animation(widget, text='', info_banner=None):
    if info_banner:
      info_banner.destroy()
    return hildon.hildon_banner_show_animation(widget, None, text)

class Dialog():

  @staticmethod
  def show_confirm(title, text, callback):
    cdialog = gtk.Dialog(title, None, gtk.DIALOG_MODAL | gtk.DIALOG_NO_SEPARATOR, (gtk.STOCK_YES, gtk.RESPONSE_OK, gtk.STOCK_NO, gtk.RESPONSE_NONE))
    cdialog.vbox.pack_start(gtk.Label(text), fill=True)
    cdialog.show_all()
    response = cdialog.run()
    cdialog.destroy()
    if response == gtk.RESPONSE_OK and callback:
      callback()
