using GLib;

namespace XMaeme {
	public class VBA : GLib.Object {
		public const string EXECUTABLE = "vba";
		public const string SOUND = "-sound";
		public const string FULLSCREEN = "-F";
		public const string SINGLERES = "-1";
		public const string DOUBLERES = "-2";
		public const string FSKIP = "-s";

		public static int launch(string romname, bool useSound, bool fullscreen, bool maxScale, uint frameskip) {
			string fullrom = XMaeme.getRomFullPath(romname, RomType.GBA);
			string[] argv = new string[] { EXECUTABLE, FULLSCREEN, (maxScale? DOUBLERES: SINGLERES), FSKIP, (frameskip.to_string()), ((null == fullrom)? romname: fullrom), null };

			return XMaeme.launch_any(argv);
		}// launch
	}// VBA
}// XMaeme
