using GLib;
using Gtk;
using Glade;
using Hildon;

namespace XMaeme {
	public static Hildon.Window hildonwindow;
	public static Hildon.Program hildonprogram;

	public static void initialize_specific() {
		weak XML xml = XMaeme.GladeXml;
		hildonwindow = new Hildon.Window();
		hildonprogram = Hildon.Program.get_instance();
		weak Notebook nb = (Notebook)xml.get_widget("notebook1");
		string[] spins = new string[] { "nes_frameskip", "gba_frameskip" };
		weak HBox hb = null;
		weak SpinButton sb = null;
		NumberEditor ned;

		hildonwindow.set_title("XMaeme");
		nb.reparent(hildonwindow);

		Signal.connect(hildonwindow, "key_press_event", key_press_cb, hildonwindow);

		hildonprogram.add_window(hildonwindow);
		hildonwindow.show_all();

		foreach(string spin in spins) {
			// stdout.printf("Getting %s\n", spin);
			sb = (SpinButton)xml.get_widget(spin);
			hb = (HBox)sb.get_parent();
			// stdout.printf("Got hbox %s: %s\n", hb.get_name(), hb.get_type().name());
			int	min = 0,
				max = 0;
			sb.get_range(ref min, ref max);
			ned = new NumberEditor(min, max);
			ned.set_name("HildonNumberEditor");	//HATE
			ned.set_value(sb.get_value_as_int());
			ned.show_all();
			hb.pack_start_defaults(ned);
			sb.hide_all();
		}
	}// initialize_specific

	public static void show_information(string info) {
		Banner.show_information(hildonwindow, null, info);
	}// show_information

	public static NumberEditor get_ned(string spin_name) {
		weak XML xml = XMaeme.GladeXml;
		weak Widget spin = xml.get_widget(spin_name);
		// weak GLib.List<Widget> children = spin.get_ancestor(GLib.Type.from_name("Gtk.HBox"));
		weak GLib.List<Widget> children = ((Container)spin.get_parent()).get_children();
		// string ned_name = spin_name + "_hildon";
		string ned_name = "HildonNumberEditor";

		foreach(Widget w in children) {
			// stdout.printf("Checking %s against %s\n", w.get_name(), ned_name);
			if(w.get_name() == ned_name) {
				return (NumberEditor)w;
			}
		}

		return null;
	}// get_ned

	public static int get_spin_value(string spin_name) {
		return get_ned(spin_name).get_value();
	}// get_spin_value

	public static void set_spin_value(string spin_name, int newval) {
		get_ned(spin_name).set_value(newval);
	}// set_spin_value

	public static void launch_file_browser(weak ComboBox romlist, string default_path) {
		Hildon.FileChooserDialog fd = new Hildon.FileChooserDialog((Gtk.Window)hildonwindow, FileChooserAction.OPEN);

		if(null != default_path){ fd.set_current_folder(default_path); }
		
		if(ResponseType.OK == fd.run()) {
			romlist.prepend_text(fd.get_filename());
			romlist.set_active(0);
		}

		fd.destroy();
	}// launch_file_browser
}// XMaeme
