using GLib;

namespace XMaeme {
	public class Handy: GLib.Object {
		public const string	EXECUTABLE = "handy_sdl";
		public const string	SOUND = "-sound";
		public const string	NOSOUND = "-nosound";
		public const string	FULLSCREEN = "-fullscreen";
		public const string	AUTOSKIP = "-autoskip";

		public static int launch(string romname, bool useSound) {
			string fullrom = XMaeme.getRomFullPath(romname, RomType.LYNX);
			string[] argv = new string[] { EXECUTABLE, FULLSCREEN, AUTOSKIP, (useSound? SOUND: NOSOUND), ((null == fullrom)? romname: fullrom), null };

			return XMaeme.launch_any(argv);
		}// launch
	}// Gnuboy
}// XMaeme
