using GLib;

namespace XMaeme {
	public class Gngeo {
		public const string EXECUTABLE = "gngeo";
		public const string FULLSCREEN = "--fullscreen";
		public const string SOUND = "--sound";
		public const string NOSOUND = "--nosound";
		public const string SAMPLERATE = "--samplerate=11025";
		public const string BIOSPATH = "--biospath";
		public const string SCALE = "--scale=2";

		public static int launch(string romname, string biospath, bool useSound) {
			string fullrom = XMaeme.getRomFullPath(romname, RomType.NEOGEO);
			string[] argv = new string[] { EXECUTABLE, (useSound? SOUND: NOSOUND), SAMPLERATE, FULLSCREEN, SCALE, (BIOSPATH + "=" + biospath), ((null == fullrom)? romname: fullrom), null };

			return XMaeme.launch_any(argv);
		}// launch
	}// Gngeo
}// XMaeme
