/*
 * This file is part of vncviewer
 *
 * Copyright (C) 2005-2007 Aaron Levinson, Detlef Schmicker.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef INTERFACE_H
#define INTERFACE_H

#include <glib.h>
#include <gtk/gtk.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#include <hildon-widgets/hildon-program.h>
#include "appdata.h"
#include "vnc-viewer.h"

#define _(String) gettext(String)

#define MAIN_VIEW_NAME "MainView"

#define MAEMO_VNCVIEWER_GCONF_PATH "/apps/maemo/vncviewer"

#define MAEMO_VNCVIEWER_GCONF_HOSTS MAEMO_VNCVIEWER_GCONF_PATH "/hosts"
#define MAEMO_VNCVIEWER_GCONF_SHARED MAEMO_VNCVIEWER_GCONF_PATH "/shared"
#define MAEMO_VNCVIEWER_GCONF_DEPTH MAEMO_VNCVIEWER_GCONF_PATH "/depth"
#define MAEMO_VNCVIEWER_GCONF_ROTATION MAEMO_VNCVIEWER_GCONF_PATH "/rotation"
#define MAEMO_VNCVIEWER_GCONF_NORMAL_TOOLBAR MAEMO_VNCVIEWER_GCONF_PATH "/normal_toolbar"
#define MAEMO_VNCVIEWER_GCONF_FULLSCREEN_TOOLBAR MAEMO_VNCVIEWER_GCONF_PATH "/full_screen_toolbar"
#define MAEMO_VNCVIEWER_GCONF_SHOW_SCROLLBARS MAEMO_VNCVIEWER_GCONF_PATH "/show_scrollbars"
#define MAEMO_VNCVIEWER_GCONF_FULLSCREEN MAEMO_VNCVIEWER_GCONF_PATH "/fullscreen"

typedef struct options_settings
{
  gboolean m_bShared;
  VncViewerDepthType m_nDepth;
  VncViewerRotationType m_nRotationType;
} options_settings;

// Struct to include view's information
typedef struct _MainView MainView;
struct _MainView
{
  // Handle to app's data
  AppData *data;

  // Fullscreen mode is on (TRUE) or off (FALSE)
  gboolean fullscreen;
  
  gboolean bShowNormalToolbar;
  gboolean bShowFullscreenToolbar;
  gboolean bShowScrollbars;

  guint directionKeyPress;
  gboolean bMultiplePresses;

  // Items for menu
  GtkWidget *file_item, *view_item, *help_item;
  GtkWidget *disconnect_item, *quit_item;
  GtkWidget *fullscreen_item;
  
  // Toolbar
  GtkWidget *toolbar;
  GtkToolItem *connect_tb;
  GtkToolItem *disconnect_tb;
  GtkToolItem *fullscreen_tb;
  GtkToolItem *im_tb;
  GtkToolItem *keys_tb;

  GtkMenuShell *keys_menu;
  GtkCheckMenuItem *ctrl_item;
  GtkCheckMenuItem *alt_item;
  GtkCheckMenuItem *shift_item;

  gboolean m_bCtrlOn;
  gboolean m_bAltOn;
  gboolean m_bShiftOn;

  options_settings default_opts;

  GSList *m_hostList;

  GtkWidget *scrolledwin;
  VncViewer *vnc;

  GConfClient *gc_client;

  gboolean m_bHaveHomeKeyLock;
  guint m_nKeySnooperId;
};

// Publics:
MainView * interface_main_view_new(AppData *data);
void interface_main_view_destroy(MainView *main);
char * interface_vnc_chooser(MainView *main);
void interface_vnc_passwd(MainView *main, gboolean bUserDisabled,
			  const gchar *secType, gchar **user,
			  gchar **passwd);

#endif
