/*
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_PREFERENCES_PAGE_H
#define _ST_PREFERENCES_PAGE_H

#include <gtk/gtk.h>

#define ST_TYPE_PREFERENCES_PAGE		(st_preferences_page_get_type())
#define ST_PREFERENCES_PAGE(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), ST_TYPE_PREFERENCES_PAGE, STPreferencesPage))
#define ST_PREFERENCES_PAGE_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), ST_TYPE_PREFERENCES_PAGE, STPreferencesPageClass))
#define ST_IS_PREFERENCES_PAGE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), ST_TYPE_PREFERENCES_PAGE))
#define ST_IS_PREFERENCES_PAGE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), ST_TYPE_PREFERENCES_PAGE))
#define ST_PREFERENCES_PAGE_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), ST_TYPE_PREFERENCES_PAGE, STPreferencesPageClass))

typedef struct _STPreferencesPagePrivate STPreferencesPagePrivate;

typedef struct
{
  GtkVBox			vbox;

  STPreferencesPagePrivate	*priv;
} STPreferencesPage;

typedef struct
{
  GtkVBoxClass			parent_class;
} STPreferencesPageClass;

GType st_preferences_page_get_type (void);
STPreferencesPage *st_preferences_page_new (void);

void st_preferences_page_set_name (STPreferencesPage *page, const char *name);
const char *st_preferences_page_get_name (STPreferencesPage *page);

void st_preferences_page_set_icon (STPreferencesPage *page, GdkPixbuf *icon);
GdkPixbuf *st_preferences_page_get_icon (STPreferencesPage *page);

void st_preferences_page_set_stock_id (STPreferencesPage *page,
				       const char *stock_id);
const char *st_preferences_page_get_stock_id (STPreferencesPage *page);

void st_preferences_page_set_label (STPreferencesPage *page,
				    const char *label);
const char *st_preferences_page_get_label (STPreferencesPage *page);

void st_preferences_page_set_help_link_id (STPreferencesPage *page,
					   const char *help_link_id);
const char *st_preferences_page_get_help_link_id (STPreferencesPage *page);

#endif /* _ST_PREFERENCES_PAGE_H */
