/*
 * Copyright (c) 2002, 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _SG_PARSER_H
#define _SG_PARSER_H

#include <glib-object.h>
#include <stdarg.h>

#define SG_PARSER_SCOPE(parser)		((parser)->scanner->scope_id)

#define SG_PARSER_STATEMENT_IS_END(statement) \
	((statement)->terminator == '}')

typedef struct _SGParser		SGParser;
typedef struct _SGParserDefinition	SGParserDefinition;
typedef struct _SGParserStatement	SGParserStatement;

struct _SGParser
{
  char				*filename;
  GIOChannel			*io_channel;
  
  GScanner			*scanner;
  GSList			*scope_stack;
};

struct _SGParserDefinition
{
  int		parent;		/* parent scope ID */
  
  int		id;		/* statement ID, must be != 0 */
  const char	*name;
  
  gboolean	scope;		/* is a scope? */
  GType		value_type;	/*
				 * G_TYPE_NONE,
				 * G_TYPE_BOOLEAN,
				 * G_TYPE_INT,
				 * G_TYPE_UINT,
				 * G_TYPE_DOUBLE
				 * or G_TYPE_STRING
				 */
};

struct _SGParserStatement
{
  SGParser		*parser;

  SGParserDefinition	*definition;
  GValue		value;
  char			terminator;
};

SGParser	*sg_parser_new		(const char		*filename,
					 GError			**err);
void		sg_parser_free		(SGParser		*parser);

void		sg_parser_define	(SGParser		*parser,
					 SGParserDefinition	*definition);
void		sg_parser_definev	(SGParser		*parser,
					 SGParserDefinition	*definitionv);

SGParserStatement *sg_parser_get_statement	(SGParser	*parser);

void		sg_parser_statement_evaluate	(SGParserStatement *statement);
void		sg_parser_statement_free	(SGParserStatement *statement);

#endif /* _SG_PARSER_H */
