# Copyright (c) 2003-2004 Hyriand. All rights reserved.
#
import gtk

from transferlist import TransferList
from utils import PopupMenu

class Uploads(TransferList):
	def __init__(self, frame):
		TransferList.__init__(self, frame, frame.UploadList)

		self.popup_menu = popup = PopupMenu(frame)
		popup.setup(
			("Copy URL", self.OnCopyURL),
			("Copy folder URL", self.OnCopyDirURL),
			("", None),
			("Send message", popup.OnSendMessage),
			("Show IP address", popup.OnShowIPaddress),
			("Get user info", popup.OnGetUserInfo),
			("Browse files", popup.OnBrowseUser),
			("Give privileges", popup.OnGivePrivileges),
			("$" + "Add user to list", popup.OnAddToList),
			("$" + "Ban this user", popup.OnBanUser),
			("$" + "Ignore this user", popup.OnIgnoreUser),
			("", None),
			("Abort", self.OnAbortTransfer),
			("Clear", self.OnClearTransfer),
			("", None),
			("Clear finished/aborted", self.OnClearFinishedAborted),
			("Clear finished", self.OnClearFinished),
			("Clear aborted", self.OnClearAborted),
			("Clear queued", self.OnClearQueued),
		)
		frame.UploadList.connect("button_press_event", self.UpListPop)

	def UpListPop(self, widget, event):
		if event.button == 1 and event.type == gtk.gdk._2BUTTON_PRESS:
			return self.OnPopupMenu(widget, event)
	
	def OnPopupMenu(self, widget, event):
		if event.button == 3:
			return False
		
		self.selected_transfers = []
		self.selected_users = []
		self.widget.get_selection().selected_foreach(self.SelectedTransfersCallback)

		items = self.popup_menu.get_children()

		act = False
		if len(self.selected_transfers) == 1:
			act = True
		items[0].set_sensitive(act)
		items[1].set_sensitive(act)

		act = False
		if len(self.selected_users) == 1:
			user = self.selected_users[0]
			self.popup_menu.set_user(user)
			act = True
			items[8].set_active(user in [i[0] for i in self.frame.np.config.sections["server"]["userlist"]])
			items[9].set_active(user in self.frame.np.config.sections["server"]["banlist"])
			items[10].set_active(user in self.frame.np.config.sections["server"]["ignorelist"])

		for i in range(3, 10):
			items[i].set_sensitive(act)
		
		act = len(self.selected_transfers) and True or False
		for i in range(11, 13):
			items[i].set_sensitive(act)
		
		self.popup_menu.popup(None, None, None, event.button, event.time)
		
		widget.emit_stop_by_name("button_press_event")
		return True
		
	def ClearByUser(self, user):
		for i in self.list[:]:
			if i.user == user:
				if i.transfertimer is not None:
					i.transfertimer.cancel()
				self.list.remove(i)
		self.frame.np.transfers.calcUploadQueueSizes()
		self.frame.np.transfers.checkUploadQueue()
		self.update()

	def OnAbortTransfer(self, widget, remove = False, clear = False):
		TransferList.OnAbortTransfer(self, widget, remove, clear)
		self.frame.np.transfers.calcUploadQueueSizes()
		self.frame.np.transfers.checkUploadQueue()

	def OnClearQueued(self, widget):
		TransferList.OnClearQueued(self, widget)
		self.frame.np.transfers.calcUploadQueueSizes()
