/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=4 sts=2 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "common.h"
#include <gwebtransferitem.h>
#include "gmozillatransferitemlist.h"

/* GMozillaTransferItemList */

static void
g_mozilla_transfer_item_list_destroy (GMozillaTransferItemList *self)
{
    TRACE_LOG();
    return;
}

static GObject**
g_mozilla_transfer_item_list_get_items (GMozillaTransferItemList *self)
{
    TRACE_LOG();
    return G_MOZILLA_TRANSFER_ITEM_LIST(self)->items;
}

static gint
g_mozilla_transfer_item_list_get_items_count (GMozillaTransferItemList *self)
{
    TRACE_LOG();
    return G_MOZILLA_TRANSFER_ITEM_LIST(self)->num_items;
}

static void
g_mozilla_transfer_item_list_interface_init (GWebTransferItemListIface *iface)
{
    TRACE_LOG();
    iface->destroy         = (void (*) (GWebTransferItemList*))
                             g_mozilla_transfer_item_list_destroy;
    iface->get_items       = (GObject** (*) (GWebTransferItemList*))
                             g_mozilla_transfer_item_list_get_items;
    iface->get_items_count = (gint (*) (GWebTransferItemList*))
                             g_mozilla_transfer_item_list_get_items_count;
}

static void
g_mozilla_transfer_item_list_instance_init (GTypeInstance *instance, gpointer  g_class)
{
    TRACE_LOG();
    G_MOZILLA_TRANSFER_ITEM_LIST(instance)->items     = NULL;
    G_MOZILLA_TRANSFER_ITEM_LIST(instance)->num_items = 0;
}

GType
g_mozilla_transfer_item_list_get_type (void)
{
    static GType type = 0;
    if (type == 0)
    {
        static const GTypeInfo info =
            {
                sizeof (GMozillaTransferItemListClass),
                NULL,   /* base_init */
                NULL,   /* base_finalize */
                NULL,   /* class_init */
                NULL,   /* class_finalize */
                NULL,   /* class_data */
                sizeof (GMozillaTransferItemList),
                0,      /* n_preallocs */
                g_mozilla_transfer_item_list_instance_init    /* instance_init */
            };
        static const GInterfaceInfo iface_info =
            {
                (GInterfaceInitFunc) g_mozilla_transfer_item_list_interface_init,
                NULL,   /* interface_finalize */
                NULL    /* interface_data */
            };
        type = g_type_register_static (G_TYPE_OBJECT,
                                       "GMozillaTransferItemList",
                                       &info, (GTypeFlags) 0);
        g_type_add_interface_static (type,
                                     G_TYPE_WEB_TRANSFER_ITEM_LIST,
                                     &iface_info);
    }
    return type;
}

#define GET_NEW (g_object_new(g_mozilla_transfer_item_list_get_type(), NULL))

GObject*
g_mozilla_transfer_item_list_new (void)
{
    TRACE_LOG();
    return G_OBJECT(GET_NEW);
}
