/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef COMMON_H
#define COMMON_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdlib.h>
#include <libintl.h>
#include <locale.h>
#include <gdk/gdkkeysyms.h>
#include <mozilla-config.h>

//#define MOZEAL_LOGGING 1

#ifdef TABLET_ENV
#include <osso-log.h>
#ifdef MOZEAL_LOGGING
#define TRACE_LOG(FMT, ARG...) printf(\
     "MOZEAL_TRACE:%s:%s:%d: " FMT "\n", __FILE__, __FUNCTION__, __LINE__, ## ARG)
#endif
#else
#ifdef MOZEAL_LOGGING
#define ULOG_DEBUG_F(FMT, ARG...) printf(\
     "MOZMOZEAL:%s:%d: " FMT "\n", __FUNCTION__, __LINE__, ## ARG)
#define ULOG_CRIT_F(FMT, ARG...) printf(\
     "MOZMOZEAL:%s:%d: " FMT "\n", __FUNCTION__, __LINE__, ## ARG)
#define ULOG_INFO_F(FMT, ARG...) printf(\
     "MOZMOZEAL:%s:%d: " FMT "\n", __FUNCTION__, __LINE__, ## ARG)
#define ULOG_WARN_F(FMT, ARG...) printf(\
     "MOZMOZEAL:%s:%d: " FMT "\n", __FUNCTION__, __LINE__, ## ARG)
#define ULOG_ERR_F(FMT, ARG...) printf(\
     "MOZMOZEAL:%s:%d: " FMT "\n", __FUNCTION__, __LINE__, ## ARG)
#define TRACE_LOG(FMT, ARG...) pr_mozeal_trace(\
     "MOZEAL_TRACE:%s:%s:%d: " FMT "\n", __FILE__, __FUNCTION__, __LINE__, ## ARG)
#else
#       define ULOG_DEBUG_F(...) do {} while (0)
#       define ULOG_CRIT_F(...) do {} while (0)
#       define ULOG_INFO_F(...) do {} while (0)
#       define ULOG_WARN_F(...) do {} while (0)
#       define ULOG_ERR_F(...) do {} while (0)
#       define TRACE_LOG(...) do {} while (0)
#endif
#endif

#define MOZILLA_DEFAULT_VENDOR_NAME  "Firefox/3.0a1"

#define G_MOZILLA_PREF_UI_STRING                        "general.useragent.extra.simple"
#define G_MOZILLA_PREF_EAL_NAME                         "general.useragent.vendor"
#define G_MOZILLA_PREF_EAL_VER                          "general.useragent.vendorSub"
#define G_MOZILLA_PREF_EAL_MILESTONE                    "general.useragent.vendorComment"
#define G_MOZILLA_PREF_PLUGINS_DIR                      "MOZ_PLUGIN_PATH"
#define G_MOZILLA_PREF_MEMORY_CACHE_SIZE                "browser.cache.memory.capacity"
#define G_MOZILLA_PREF_DISPLAY_FRAME_BORDER             "browser.display.frame_border"
#define G_MOZILLA_PREF_WEB_ADDRESS_SUFFIXES             "browser.fixup.alternate.suffix"
#define G_MOZILLA_PREF_HOME_PAGE_LOCATION               "browser.startup.homepage"
#define G_MOZILLA_PREF_USE_DEFAULT_HOME_PAGE            "browser.startup.use_default_homepage"
#define G_MOZILLA_PREF_ENABLE_SSL2                      "security.enable_ssl2"
#define G_MOZILLA_PREF_ENABLE_PLUGINS                   "plugin.default_plugin_disable"
#define G_MOZILLA_PREF_ENABLE_JAVA_SCRIPT               "javascript.enabled"
#define G_MOZILLA_PREF_ENABLE_JAVA                      "security.enable_java"
#define G_MOZILLA_PREF_SECURE_ENTER                     "security.warn_entering_secure"
#define G_MOZILLA_PREF_SECURE_LEAVE                     "security.warn_leaving_secure"
#define G_MOZILLA_PREF_SECURE_SUBMIT                    "security.warn_submit_insecure"
#define G_MOZILLA_PREF_ENABLE_POPUP_WINDOWS             "privacy.popups.policy"
#define G_MOZILLA_PREF_OPEN_POPUP_DURING_LOAD           "dom.disable_open_during_load"
#define G_MOZILLA_PREF_ACCEPT_COOKIES                   "network.cookie.alwaysAcceptSessionCookies"
#define G_MOZILLA_PREF_COOKIE_LIFETIMEPOLICY            "network.cookie.lifetimePolicy"
#define G_MOZILLA_PREF_COOKIE_BEHAVIOUR                 "network.cookie.cookieBehavior"
#define G_MOZILLA_PREF_SHOW_IMAGES                      "permissions.default.image"
#define G_MOZILLA_PREF_OFFLINE_BROWSER                  "network.online"
#define G_MOZILLA_PREF_LANGUAGE                         "intl.accept_languages"
#define G_MOZILLA_PREF_PROXY_TYPE                       "network.proxy.type"
#define G_MOZILLA_PREF_HTTP_PROXY                       "network.proxy.http"
#define G_MOZILLA_PREF_HTTP_PROXY_PORT                  "network.proxy.http_port"
#define G_MOZILLA_PREF_HTTPS_PROXY                      "network.proxy.ssl"
#define G_MOZILLA_PREF_HTTPS_PROXY_PORT                 "network.proxy.ssl_port"
#define G_MOZILLA_PREF_FTP_PROXY                        "network.proxy.ftp"
#define G_MOZILLA_PREF_FTP_PROXY_PORT                   "network.proxy.ftp_port"
#define G_MOZILLA_PREF_AUTOCONFIG_URL_PROXY             "network.proxy.autoconfig_url"
#define G_MOZILLA_PREF_OMITTED_HOSTS_PROXY              "network.proxy.no_proxies_on"
#define G_MOZILLA_PREF_REDIRECTION_DEFAULT_LIMIT        20
#define G_MOZILLA_PREF_REDIRECTION_LIMIT                "network.http.redirection-limit"
#define G_MOZILLA_PREF_SPATIAL_NAVIGATION               "snav.keyCode.modifier"
#define G_MOZILLA_PREF_USE_FOCUS_COLOR                  "browser.display.use_focus_colors"
#define G_MOZILLA_PREF_FOCUS_TEXT_COLOR                 "browser.display.focus_text_color"
#define G_MOZILLA_PREF_FOCUS_BACKGROUND_COLOR           "browser.display.focus_background_color"
#define G_MOZILLA_PREF_FOCUS_RING_WIDTH                 "browser.display.focus_ring_width"
#define G_MOZILLA_PREF_JSFOCUS_FOR_VISIBLE_AREA         "browser.display.jsfocus_for_visible_area"
#define G_MOZILLA_PREF_AUTOMATIC_FORM_FILL              "browser.formfill.enable"
#define G_MOZILLA_PREF_FORCE_AUTOCOMPLETION             "signon.forceAutocompletion"
#define G_MOZILLA_PREF_REMEMBER_PASSWORDS               "signon.rememberPasswords"
#define G_MOZILLA_PREF_REMEMBER_SIGNONS                 "signon.rememberSignons"
#define G_MOZILLA_PREF_PASSWORDS_SAVING                 "signon.PasswordsSaving"
#define G_MOZILLA_PREF_SIGNON_FILE                      "signon.SignonFileName"
#define G_MOZILLA_PREF_BROWSER_HISTORY_EXPIRE_DAYS      "browser.history_expire_days"
#define G_MOZILLA_PREF_SSR_ENABLED                      "ftv.enabled"
#define G_MOZILLA_PREF_MERGE_FRAMES                     "merge.frames.enabled"
#define G_MOZILLA_PREF_IMAGE_ZOOM_ENABLED               "imagezoom.enabled"
#define G_MOZILLA_PREF_IDENTIFY_AS	                    "to do"
#define G_MOZILLA_PREF_USER_UA_ADD                      "general.useragent.user.add"
#define G_MOZILLA_PREF_XUL_ERROR_PAGE                   "browser.xul.error_pages.enabled"
#define G_MOZILLA_PREF_GNOMEVFS_SUPPORT                 "network.gnomevfs.supported-protocols"
#define G_MOZILLA_PREF_DISABLE_ZOOM_NAV_CHANGE          "browser.sessionhistory.disablezoomchange"
#define G_MOZILLA_PREF_PANNING_SENS                     "gtkmozembed.mscroll.step"

#define G_MOZILLA_TRANSLATE_CONNECTIVITY_ERROR          "Network Connection Error"

/* Helper Macros */

#define EAL_BEGIN_MACRO do {
#define EAL_END_MACRO   } while (0)


#define EAL_GFREE_FUNC(_ptr, _func)    \
  EAL_BEGIN_MACRO                      \
      _func(_ptr);                     \
      (_ptr) = NULL;                   \
  EAL_END_MACRO

#define EAL_IF_GFREE_FUNC(_ptr, _func) \
  EAL_BEGIN_MACRO                      \
    if (_ptr) {                        \
      _func(_ptr);                     \
      (_ptr) = NULL;                   \
    }                                  \
  EAL_END_MACRO

#define EAL_GFREE(_ptr) EAL_GFREE_FUNC(_ptr, g_free)
#define EAL_IF_GFREE(_ptr) EAL_IF_GFREE_FUNC(_ptr, g_free)

#endif
