/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#include <gwebpassman.h>

#ifndef __GMOZILLAPASSMAN_H__
#define __GMOZILLAPASSMAN_H__

G_BEGIN_DECLS

/* GMozillaPasswordManager */
#define G_TYPE_MOZILLA_PASSWORD_MANAGER        (g_mozilla_password_manager_get_type ())
#define G_MOZILLA_PASSWORD_MANAGER(obj)         (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_MOZILLA_PASSWORD_MANAGER, GMozillaPasswordManager))
#define G_MOZILLA_PASSWORD_MANAGER_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), G_TYPE_MOZILLA_PASSWORD_MANAGER, GMozillaPasswordManagerClass))
#define G_IS_MOZILLA_PASSWORD_MANAGER(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_MOZILLA_PASSWORD_MANAGER))
#define G_IS_MOZILLA_PASSWORD_MANAGER_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), G_TYPE_MOZILLA_PASSWORD_MANAGER))
#define G_MOZILLA_PASSWORD_MANAGER_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_INTERFACE ((inst), G_TYPE_MOZILLA_PASSWORD_MANAGER, GMozillaPasswordManagerClass))

typedef struct _GMozillaPasswordManager GMozillaPasswordManager;
typedef struct _GMozillaPasswordManagerClass GMozillaPasswordManagerClass;

/** Creates a new history list
  * @return A history list.
  */
struct _GMozillaPasswordManager
{
    GObject parent;         /** < Object parent */
    GObject *login;         /** < User's login */
    gint index;
};

struct _GMozillaPasswordManagerClass
{
    GObjectClass parent;
};
GType g_mozilla_password_manager_get_type (void);

/** Creates a new password manager's instance
  * @param server The server's name
  * @param index 
  * @return A login instance
  */
GObject* g_mozilla_password_manager_login_new  (const gchar* server, gint index, GList* logins_list);

G_END_DECLS

#endif /* __GMOZILLAPASSMAN_H__ */
