/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=4 sts=2 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "common.h"
#include "gtkmozembed_common.h"
#include "gmozillaengine.h"
#include "gmozillaweb.h"
#include "gmozillapluginlist.h"
#include "gmozillahistorylist.h"
#include "gtkmozembed.h"
#include "gmozillamarshal.h"
#include "gmozillatransferitem.h"
#include "gmozillatransferitemlist.h"
#include "gmozillapassman.h"
#include <glib/gstdio.h>
//#include "gmozillaconnectivity.c"

#ifdef USE_OPENSSL
#include <openssl/x509.h>
#endif

#ifdef USE_CST
#include <cst.h>
#endif

#include <unistd.h>
#include <string.h>

enum
{
    ASK_COOKIE,                   /** < When an ask cookie dialog is required */
    CERTIFICATE_DIALOG,           /** < When a certificate dialog is required */
    CERTIFICATE_PASSWORD_DIALOG,  /** < When a certificate dialog requires a password */
    CERTIFICATE_DETAILS,          /** < When a certificate details dialog is required */
    HISTORY_ADDED,                /** < When a url is added into history */
    SELECT_MATCH_SIGNAL,
    ON_SUBMIT_SIGNAL,
    ICON_SIGNAL,
    MODAL_DIALOG,
    CONNECTIVITY_STATUS,
    LAST_SIGNAL                   /** < Last signal used */
};

guint g_mozilla_web_signals[LAST_SIGNAL] = { 0 };

#ifdef MOZEAL_LOGGING
static gboolean bmozeal_trace = FALSE;
void
pr_mozeal_trace (const char *fmt, ...)
{
    if (bmozeal_trace)
    {
        va_list vargs;
        va_start (vargs, fmt);
        vprintf (fmt, vargs);
        va_end (vargs);
    }
}
#endif

// class stuff
static void g_mozilla_web_class_init (GMozillaWebClass *);
static void g_mozilla_web_set_default_config (GMozillaWeb *self);
static gboolean g_mozilla_create_extensions_folder(void);
void g_mozilla_connectivity_set_global (GMozillaWeb *self);
void g_mozilla_connectivity_handle(GMozillaEngine *self, gint event);
void g_mozilla_connectivity_set_proxy ();

#ifdef UNUSED
static void
g_mozilla_web_show_error (const char *message)
{
    TRACE_LOG();
    /* MTBD | Not used, but may be it is usefull stuff */
    return;
}
#endif /*UNUSED*/

static void
g_mozilla_web_destroy (GMozillaWeb *self)
{
    TRACE_LOG();
    if (GTK_MOZ_EMBED_COMMON(self->global))
    {
        gtk_widget_destroy(GTK_WIDGET(self->global));
        self->global = NULL;
    }
    EAL_IF_GFREE(self->anime_cursor);
    /* TBD | May be something else should be destroyed... */
    if(self->disabled_pllist)
        g_mozilla_plugin_enable_plugins (&self->disabled_pllist);

    g_mozilla_connectivity_unset_global(self);
    gtk_moz_embed_pop_startup();
    return;
}

static void
connectivity_status_cb(GMozillaWeb *global, gint code, GMozillaEngine *self)
{
    if (self)
        g_mozilla_connectivity_handle(self, code);
}

static GWebEngine*
g_mozilla_web_new_web_engine_window_with_context (GMozillaWeb *self, gpointer context, gboolean leave_tracks, gboolean without_history)
{
    TRACE_LOG();
    GMozillaEngine * engine = G_MOZILLA_ENGINE(g_mozilla_engine_new_with_context_and_tracks(context, leave_tracks, without_history));
    engine->global = G_OBJECT(self);

    g_signal_connect(G_OBJECT(self), "connectivity-status", G_CALLBACK(connectivity_status_cb), engine);
    if (!self->is_configured) {
        g_mozilla_web_set_default_config (self);
        g_mozilla_connectivity_set_proxy();
    }
    GTK_MOZ_EMBED(engine->engine)->common = (GtkObject*)self->global;
    return G_WEB_ENGINE(engine);
}

static GWebEngine*
g_mozilla_web_new_web_engine_window (GMozillaWeb *self)
{
    TRACE_LOG();
    return g_mozilla_web_new_web_engine_window_with_context (self, NULL, FALSE, FALSE);
}

static GWebTransferItem*
g_mozilla_web_new_web_transfer_item (GMozillaWeb *self, const gchar* url, const gchar* filename)
{
    TRACE_LOG();
    ULOG_DEBUG_F("url:'%s', filename: '%s'", url, filename);
    GWebTransferItem *i = G_WEB_TRANSFER_ITEM(g_mozilla_transfer_item_new_with_url(url, filename));
    self->ongoing_download_list = g_list_append(self->ongoing_download_list, G_OBJECT (i));
    // setting web global obj
    g_mozilla_transfer_item_set_webglobal (G_OBJECT (self));
    return i;
}

static GWebTransferItem*
g_mozilla_web_initialize_web_transfer_item (GMozillaWeb *self, GObject *web_transfer_item)
{
    TRACE_LOG();
    GWebTransferItem *i = G_WEB_TRANSFER_ITEM(g_mozilla_transfer_item_new_with_item(web_transfer_item));
    self->ongoing_download_list = g_list_append(self->ongoing_download_list, G_OBJECT (i));
    // setting web global obj
    g_mozilla_transfer_item_set_webglobal (G_OBJECT (self));
    return i;
}

void
g_mozilla_web_pause_all_transfer_item (GMozillaWeb *self)
{
    TRACE_LOG();

    gint i, max = g_list_length (self->ongoing_download_list);
    for (i = 0; i < max; i++) {

        g_signal_emit_by_name(G_OBJECT (g_list_nth_data (self->ongoing_download_list, i)), "error");
    }

    return ;
}

static GWebTransferItemList*
g_mozilla_web_get_web_transfer_item_list (GMozillaWeb *self)
{
    TRACE_LOG();
    return G_WEB_TRANSFER_ITEM_LIST(g_mozilla_transfer_item_list_new());
}

GWebStatus
g_mozilla_web_set_home_page (GMozillaWeb *self, const gchar* home_page)
{
    TRACE_LOG();
    if (gtk_moz_embed_common_set_pref(G_TYPE_STRING, G_MOZILLA_PREF_HOME_PAGE_LOCATION, (gchar*)home_page)) {
        gtk_moz_embed_common_save_prefs();

        return G_WEB_STATUS_OK;   
    }
    return G_WEB_ERR;
}

static gchar*
g_mozilla_web_get_home_page (GMozillaWeb *self)
{
    TRACE_LOG();
    gchar *home_page = NULL;
    if (!gtk_moz_embed_common_get_pref(G_TYPE_STRING, G_MOZILLA_PREF_HOME_PAGE_LOCATION, &home_page))
        return NULL;
    return home_page;
}

static gchar*
g_mozilla_web_get_default_home_page (GMozillaWeb *self)
{
    TRACE_LOG();

    return g_strdup (BROWSER_DEFAULT_PAGE);
}

static gint
g_mozilla_web_get_maximum_cache_size (GMozillaWeb *self)
{
    TRACE_LOG();
    /* MTBD | Not Used */
    return -1;
}

static gboolean
g_mozilla_web_home_page_available (GMozillaWeb *self)
{
    TRACE_LOG();
    /* MTBD | Not Used */
    return TRUE;
}

static void
g_mozilla_web_set_frame_borders_enabled (GMozillaWeb *self, gboolean enabled)
{
    TRACE_LOG();
    /* TBD | Strange feature, useless also as Frame merging ;) */
    if (gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_DISPLAY_FRAME_BORDER, &enabled))
        gtk_moz_embed_common_save_prefs();
    return;
}

static gboolean
g_mozilla_web_get_frame_borders_enabled (GMozillaWeb *self)
{
    TRACE_LOG();
    /* TBD | Strange feature, useless also as Frame merging ;) */
    gboolean enabled = FALSE;
    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_DISPLAY_FRAME_BORDER, &enabled))
        return FALSE;
    return enabled;
}

static void
g_mozilla_web_set_location_completion_suffixes (GMozillaWeb *self, const gchar* suffixes)
{
    TRACE_LOG();
    if (gtk_moz_embed_common_set_pref(G_TYPE_STRING, G_MOZILLA_PREF_WEB_ADDRESS_SUFFIXES, (gchar*)suffixes))
        gtk_moz_embed_common_save_prefs();
    return;
}

static gchar*
g_mozilla_web_get_location_completion_suffixes (GMozillaWeb *self)
{
    TRACE_LOG();
    gchar *web_suffix = NULL;
    if (!gtk_moz_embed_common_get_pref(G_TYPE_STRING, G_MOZILLA_PREF_WEB_ADDRESS_SUFFIXES, &web_suffix))
        return NULL;
    return web_suffix;
}

static GWebStatus
g_mozilla_web_set_plugins_enabled (GMozillaWeb *self, gboolean enabled)
{
    TRACE_LOG();
    /*IMP | May be pref ?
      if (!gtk_moz_embed_common_set_plugins_enabled(GTK_MOZ_EMBED_COMMON(self->global), enabled))
      return G_WEB_ERR;
      */
    return G_WEB_STATUS_OK;
}

static gboolean
g_mozilla_web_get_plugins_enabled (GMozillaWeb *self)
{
    TRACE_LOG();
    /*IMP | May be pref ?
      return gtk_moz_embed_common_get_plugins_enabled(self->global);
      */
    return TRUE;
}

void
g_mozilla_web_set_ssl2_support (GMozillaWeb *self, gboolean enabled)
{
    TRACE_LOG();
    if (gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_ENABLE_SSL2, &enabled))
        gtk_moz_embed_common_save_prefs();
    return;
}

static gboolean
g_mozilla_web_get_ssl2_support (GMozillaWeb *self)
{
    TRACE_LOG();
    gboolean enabled = FALSE;
    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_ENABLE_SSL2, &enabled))
        return FALSE;
    return enabled;
}

void
g_mozilla_web_set_js_enabled (GMozillaWeb *self, gboolean enabled)
{
    TRACE_LOG();
    if (gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_ENABLE_JAVA_SCRIPT, &enabled))
        gtk_moz_embed_common_save_prefs();
    return;
}

static gboolean
g_mozilla_web_get_js_enabled (GMozillaWeb *self)
{
    TRACE_LOG();
    gboolean enabled = FALSE;
    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_ENABLE_JAVA_SCRIPT, &enabled))
        return FALSE;
    return enabled;
}

#ifdef UNUSED
static void
g_mozilla_web_show_memory_cache_error (const char *message)
{
    TRACE_LOG("%s", message);
    /* MTBD | What this stuff do here??? Delete? */
    return;
}
#endif /*UNUSED*/

static void
g_mozilla_web_set_memory_cache (GMozillaWeb *self, GMemoryCache acceptance)
{
    TRACE_LOG();
    gint size = -1;
    switch (acceptance)
    {
    case G_MEMORY_CACHE_AUTOMATIC:
        size = -1;
        break;
    case G_MEMORY_CACHE_OFF:
        size = 0;
        break;
    case G_MEMORY_CACHE_SMALL:
        size = 512;
        break;
    case G_MEMORY_CACHE_DEFAULT:
        size = 1024;
        break;
    case G_MEMORY_CACHE_MEDIUM:
        size = 2048;
        break;
    case G_MEMORY_CACHE_LARGE:
        size = 4096;
        break;
    default:
        size = -1;
        break;
    }
    if (gtk_moz_embed_common_set_pref (G_TYPE_INT, G_MOZILLA_PREF_MEMORY_CACHE_SIZE, &size)) {
        gtk_moz_embed_common_save_prefs();
    }
    return;
}

static GMemoryCache
g_mozilla_web_get_memory_cache (GMozillaWeb *self)
{
    TRACE_LOG();
    gint mem_cache = -1;
    if (!gtk_moz_embed_common_get_pref (G_TYPE_INT, G_MOZILLA_PREF_MEMORY_CACHE_SIZE, &mem_cache))
        return G_MEMORY_CACHE_AUTOMATIC;

    switch (mem_cache)
    {
    case 0:
        return G_MEMORY_CACHE_OFF;
    case 512:
        return G_MEMORY_CACHE_SMALL;
    case 1024:
        return G_MEMORY_CACHE_DEFAULT;
    case 2048:
        return G_MEMORY_CACHE_MEDIUM;
    case 4096:
        return G_MEMORY_CACHE_LARGE;
    default:
        return G_MEMORY_CACHE_AUTOMATIC;
    }
}

static void
g_mozilla_web_reset_cache_history_length (GMozillaWeb *self)
{
    TRACE_LOG();
    /* MTBD | Not Used */
    return;
}

static GWebStatus
g_mozilla_web_set_cache_size (GMozillaWeb *self, gint size)
{
    TRACE_LOG();
    /* MTBD | Not used */
    if (!gtk_moz_embed_common_set_pref (G_TYPE_INT, G_MOZILLA_PREF_MEMORY_CACHE_SIZE, &size))
        return G_WEB_ERR;
    gtk_moz_embed_common_save_prefs();
    return (GWebStatus)TRUE;
}

static gint
g_mozilla_web_get_cache_size (GMozillaWeb *self)
{
    TRACE_LOG();
    gint size = -1;
    /* MTBD | Not used */
    if (!gtk_moz_embed_common_get_pref (G_TYPE_INT, G_MOZILLA_PREF_MEMORY_CACHE_SIZE, &size))
        return -1;
    return size;
}

static GWebStatus
g_mozilla_web_set_browse_offline (GMozillaWeb *self, gboolean offline)
{
    TRACE_LOG();
    if (!gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_OFFLINE_BROWSER, &offline))
        return G_WEB_ERR;
    gtk_moz_embed_common_save_prefs();
    return G_WEB_STATUS_OK;
}

static gboolean
g_mozilla_web_get_browse_offline (GMozillaWeb *self)
{
    TRACE_LOG();
    gboolean offline = FALSE;
    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_OFFLINE_BROWSER, &offline))
        return FALSE;
    return offline;
}

static GWebStatus
g_mozilla_web_set_automatic_redirection_enabled (GMozillaWeb *self, gboolean enabled)
{
    TRACE_LOG();
    gint redirection_limit = enabled ? G_MOZILLA_PREF_REDIRECTION_DEFAULT_LIMIT : 0;
    if (!gtk_moz_embed_common_set_pref(G_TYPE_INT, G_MOZILLA_PREF_REDIRECTION_LIMIT, &redirection_limit))
        return G_WEB_ERR;
    gtk_moz_embed_common_save_prefs();
    return G_WEB_STATUS_OK;
}

static gboolean
g_mozilla_web_get_automatic_redirection_enabled (GMozillaWeb *self)
{
    TRACE_LOG();
    gint redirection_limit = 20;
    /* FIXME - there is no "browser.accept.redirects */
    if (!gtk_moz_embed_common_get_pref(G_TYPE_INT, G_MOZILLA_PREF_REDIRECTION_LIMIT, &redirection_limit))
        return TRUE;

    return redirection_limit != 0;
}

static void
g_mozilla_web_set_load_images (GMozillaWeb *self, GWebEngineImagePolicy level)
{
    TRACE_LOG();
    gint moz_pref = 1;
    switch (level)
    {
    case G_WEBENGINE_POLICY_ALL_IMAGES:
        moz_pref = 1;
        break;
    case G_WEBENGINE_POLICY_NO_IMAGES:
        moz_pref = 2;
        break;
    case G_WEBENGINE_POLICY_LOADED_IMAGES:
        moz_pref = 4;
        break;
    }
    gtk_moz_embed_common_set_image_policy(moz_pref);
}

static GWebEngineImagePolicy
g_mozilla_web_get_load_images (GMozillaWeb *self)
{
    TRACE_LOG();
    gint show_images = 1;
    if (!gtk_moz_embed_common_get_pref(G_TYPE_INT, G_MOZILLA_PREF_SHOW_IMAGES, &show_images))
        return G_WEBENGINE_POLICY_ALL_IMAGES;
    switch (show_images)
    {
    case 1:
        return G_WEBENGINE_POLICY_ALL_IMAGES;
    case 2:
        return G_WEBENGINE_POLICY_NO_IMAGES;
    case 4:
        return G_WEBENGINE_POLICY_LOADED_IMAGES;
    default:
        return G_WEBENGINE_POLICY_ALL_IMAGES;
    }
}

static void
g_mozilla_web_disconnect (GMozillaWeb *self)
{
    TRACE_LOG();
    /* TBD | Not Used */
    return ;
}

static GWebStatus
g_mozilla_web_clear_cache (GMozillaWeb *self)
{
    TRACE_LOG();
    //guint memoryCache = 1;
    /*IMP
      if (!gtk_moz_embed_common_clear_cache(GTK_MOZ_EMBED_COMMON(self->global), memoryCache))
      return G_WEB_ERR;
      */
    if (!gtk_moz_embed_common_clear_cache())
        return G_WEB_ERR;

    return G_WEB_STATUS_OK;
}

static GWebPluginList*
g_mozilla_web_get_plugins_list (GMozillaWeb *self)
{
    TRACE_LOG();
    GObject * pl_list = g_mozilla_plugin_list_new();
    if (pl_list)
      return G_WEB_PLUGIN_LIST(pl_list);
    return NULL;
}

static GWebHistoryList*
g_mozilla_web_get_history_list (GMozillaWeb *self)
{
    TRACE_LOG();
    return G_WEB_HISTORY_LIST(g_mozilla_history_list_new ());
}

static GWebStatus
g_mozilla_web_set_new_window_loads (GMozillaWeb *self, gboolean loads)
{
    TRACE_LOG();

    if (!gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_USE_DEFAULT_HOME_PAGE, &loads))
        return G_WEB_ERR;

    return G_WEB_STATUS_OK;
}

static gboolean
g_mozilla_web_get_new_window_loads (GMozillaWeb *self)
{
    TRACE_LOG();

    gboolean loads;

    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_USE_DEFAULT_HOME_PAGE, &loads))
        return TRUE;

    return loads;
}

static void
g_mozilla_web_set_cookie_acceptance (GMozillaWeb *self, GCookieAcceptance acceptance)
{
    TRACE_LOG();
    gint life_time_policy = 0;
    gint behaviour = 0;
    gboolean warning_before = FALSE;
    switch (acceptance)
    {
    case G_ACCEPT_COOKIE_ALWAYS:
        behaviour = 0;
        life_time_policy = 0;
        break;
    case G_ACCEPT_COOKIE_PROMPT:
        warning_before = TRUE;
        behaviour = 0;
        life_time_policy = 1;
        break;
    case G_ACCEPT_COOKIE_NEVER:
        behaviour = 2;
        life_time_policy = 0;
        break;
    default:
        g_print("You should not be here\n");
        break;
    }

    if (gtk_moz_embed_common_set_pref(G_TYPE_INT, G_MOZILLA_PREF_COOKIE_BEHAVIOUR, &behaviour) && 
        gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, "network.cookie.warnAboutCookies", &warning_before) && 
        gtk_moz_embed_common_set_pref(G_TYPE_INT, "network.cookie.lifetimePolicy", &life_time_policy)) {
        gtk_moz_embed_common_save_prefs(); 
    }
}

static GCookieAcceptance
g_mozilla_web_get_cookie_acceptance (GMozillaWeb *self)
{
    TRACE_LOG();
    gint cookie_behaviour = 0;
    gint cookie_lifetime = 0;
    gtk_moz_embed_common_get_pref(G_TYPE_INT, G_MOZILLA_PREF_COOKIE_BEHAVIOUR, &cookie_behaviour);
    gtk_moz_embed_common_get_pref(G_TYPE_INT, G_MOZILLA_PREF_COOKIE_LIFETIMEPOLICY, &cookie_lifetime);
    if (cookie_behaviour == 2)
    {
        return G_ACCEPT_COOKIE_NEVER;
    }
    else if (cookie_behaviour == 0)
    {
        if (cookie_lifetime == 0)
            return G_ACCEPT_COOKIE_ALWAYS;
        else if (cookie_lifetime == 1)
            return G_ACCEPT_COOKIE_PROMPT;
        else
            return G_ACCEPT_COOKIE_PROMPT;
    }
    else
    {
        return G_ACCEPT_COOKIE_PROMPT;
    }
}

#ifdef UNUSED
static GSList*
g_mozilla_web_get_cookies_list (GMozillaWeb *self)
{
    TRACE_LOG();
    GList * list = NULL;
    /* MTBD | Not used, can't find this function in interface */
    /*IMP
      list = gtk_moz_embed_common_get_cookie_list(self->global);
      */
    return (GSList*)list;
}
#endif /*UNUSED*/

static void
g_mozilla_web_set_popup_acceptance (GMozillaWeb *self, GPopupAcceptance acceptance)
{
    TRACE_LOG();
    gboolean blockDuringLoad = FALSE;
    gint popupPolicy = 0;

    switch (acceptance)
    {
    case G_ACCEPT_POPUP_ALWAYS:
        popupPolicy = 1;
        blockDuringLoad = FALSE;
        break;
    case G_ACCEPT_POPUP_PROMPT:
        popupPolicy = 1;
        blockDuringLoad = TRUE;
        break;
    case G_ACCEPT_POPUP_NEVER:
        popupPolicy = 2;
        blockDuringLoad = FALSE;
        break;
    }
    gtk_moz_embed_common_set_pref(G_TYPE_INT, G_MOZILLA_PREF_ENABLE_POPUP_WINDOWS, &popupPolicy);
    gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_OPEN_POPUP_DURING_LOAD, &blockDuringLoad);

    gtk_moz_embed_common_save_prefs();
}

static GPopupAcceptance
g_mozilla_web_get_popup_acceptance (GMozillaWeb *self)
{   /* MTBD | Not used, can't find this function in interface */
    TRACE_LOG();
    gboolean blockDuringLoad = FALSE;
    gint popupPolicy = 0;

    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_OPEN_POPUP_DURING_LOAD, &blockDuringLoad))
        return G_ACCEPT_POPUP_ALWAYS;

   if (!gtk_moz_embed_common_get_pref(G_TYPE_INT, G_MOZILLA_PREF_ENABLE_POPUP_WINDOWS, &popupPolicy))
       return G_ACCEPT_POPUP_ALWAYS;

   if (blockDuringLoad && popupPolicy == 1)
       return G_ACCEPT_POPUP_PROMPT;
   else if (!blockDuringLoad && popupPolicy == 2)
       return G_ACCEPT_POPUP_NEVER;
   else
       return G_ACCEPT_POPUP_ALWAYS;
}

static GWebStatus
g_mozilla_web_set_language (GMozillaWeb *self, const gchar* language)
{
    ULOG_DEBUG_F("language:%s\n", language);
    gchar *moz_lang_short = NULL;
    gchar *moz_lang_long = NULL;
    gchar *cur_lang = NULL;
    if (gtk_moz_embed_common_get_pref(G_TYPE_STRING, G_MOZILLA_PREF_LANGUAGE, &cur_lang) && language)
    {
        if (cur_lang[0]==language[0]
            && cur_lang[1]==language[1]) {
            EAL_GFREE(cur_lang);
            return G_WEB_STATUS_OK;
        }
    }
    if (language)
    {
        gint len = strlen(language);
        if (len >=2)
            moz_lang_short = g_strndup(language, 2);
        if (len >=5)
        {
            moz_lang_long = g_strndup(language, 5);
            if (moz_lang_long) moz_lang_long[2]='-';
        }
    }
    gchar *result_lang = moz_lang_short?moz_lang_short:"en";
    // g_strdup_printf("%s,%s,en-us,en", moz_lang_long?moz_lang_long:"", moz_lang_short?moz_lang_short:"");
    if (!gtk_moz_embed_common_set_pref(G_TYPE_STRING, G_MOZILLA_PREF_LANGUAGE, result_lang))
        return G_WEB_ERR;
    gtk_moz_embed_common_set_pref(G_TYPE_STRING, "general.useragent.locale", moz_lang_long?moz_lang_long:"US");
    gtk_moz_embed_common_save_prefs();
    EAL_GFREE(moz_lang_short);
    EAL_GFREE(moz_lang_long);
    EAL_IF_GFREE(cur_lang);

    return G_WEB_STATUS_OK;
}

static gchar*
g_mozilla_web_get_language (GMozillaWeb *self)
{
    TRACE_LOG();
    gchar *sval = NULL;
    if (!gtk_moz_embed_common_get_pref(G_TYPE_STRING, G_MOZILLA_PREF_LANGUAGE, &sval))
        sval = NULL;
    return sval;
}

static GWebStatus
g_mozilla_web_suspend (GMozillaWeb *self)
{
    TRACE_LOG();
    /* TBD */
    return G_WEB_STATUS_OK;
}

static gboolean
g_mozilla_web_suspended (GMozillaWeb *self)
{
    TRACE_LOG();
    /* TBD */
    return G_WEB_STATUS_OK;
}

static void
g_mozilla_web_resume (GMozillaWeb *self)
{
    TRACE_LOG();
    /* TBD */
    //gtk_mozilla_suspend(FALSE);
    return ;
}

static void
g_mozilla_web_set_ua_string (GMozillaWeb *self, gchar *ua_string)
{
    TRACE_LOG();
    g_return_if_fail(self && ua_string); 
    gchar * sval = NULL;
    gtk_moz_embed_common_get_pref(G_TYPE_STRING, G_MOZILLA_PREF_USER_UA_ADD, &sval);
    gchar *temp_str = g_strdup_printf ("%s%s", sval?sval:MOZILLA_DEFAULT_VENDOR_NAME, ua_string);
    gtk_moz_embed_common_set_pref(G_TYPE_STRING, G_MOZILLA_PREF_EAL_NAME, temp_str);
    gtk_moz_embed_common_save_prefs();
    g_free(temp_str);
    g_free(sval);
    sval = NULL;
}

static void
g_mozilla_web_enable_url_loading (GMozillaWeb *self, gboolean enable)
{
    TRACE_LOG();
    /* TBD */
}

static void
g_mozilla_web_free_memory (GMozillaWeb *self, gboolean progressive)
{
    TRACE_LOG();
    /* TBD */
}


static GWebStatus
g_mozilla_web_store_transfers (GMozillaWeb *self)
{
    TRACE_LOG();
    /* TBD */
    return G_WEB_STATUS_OK;
}

static GWebStatus
g_mozilla_web_restore_transfers (GMozillaWeb *self)
{
    TRACE_LOG();
    /* TBD */
    return G_WEB_STATUS_OK;
}

static GWebStatus
g_mozilla_web_delete_all_cookies (GMozillaWeb *self)
{
    TRACE_LOG();
    GSList *cookiesList = NULL;

    cookiesList = gtk_moz_embed_common_get_cookie_list();
    if (!gtk_moz_embed_common_delete_all_cookies(cookiesList))
        return G_WEB_ERR;

    return G_WEB_STATUS_OK;
}

static GWebStatus
g_mozilla_web_confirm_cookie (GMozillaWeb *self, gpointer context, gboolean accept, GWebCookieAction action)
{
    TRACE_LOG();

    if (action == G_WEB_COOKIE_REFUSE_ALL_FROM_SERVER || action == G_WEB_COOKIE_NO_ACTION) 
        ((GtkMozEmbedCookie*) context)->accept = FALSE;
    else
        ((GtkMozEmbedCookie*) context)->accept = TRUE;

    if (action == G_WEB_COOKIE_ACCEPT_ALL_FROM_SERVER || action == G_WEB_COOKIE_REFUSE_ALL_FROM_SERVER)
        ((GtkMozEmbedCookie*) context)->remember_decision = TRUE;

    return G_WEB_STATUS_OK;
}

static GObject*
g_mozilla_web_get_global (GMozillaWeb *self)
{
    TRACE_LOG();
    return G_OBJECT(self);
}

static GWebCertificateMessage
g_mozilla_web_get_certificate_enum_message (GMozillaWeb *self,
                                            GObject *context)
{
    TRACE_LOG();
    GWebCertificateMessage mess = 0;
    if (((GMozillaWebCertContext*)context)->error & GTK_MOZ_EMBED_CERT_NOT_VERIFIED_UNKNOWN)
    {
        mess |= G_WEB_CERT_MESS_WRONGNAME;
    }
    if (((GMozillaWebCertContext*)context)->error & GTK_MOZ_EMBED_CERT_REVOKED)
    {
        mess |= G_WEB_CERT_MESS_PREVALID;
    }
    if (((GMozillaWebCertContext*)context)->error & GTK_MOZ_EMBED_CERT_EXPIRED)
    {
        mess |= G_WEB_CERT_MESS_EXPIRED;
    }
    if (((GMozillaWebCertContext*)context)->error & GTK_MOZ_EMBED_CERT_UNTRUSTED)
    {
        mess |= G_WEB_CERT_MESS_UNTRUSTED;
    }
    if (((GMozillaWebCertContext*)context)->error & GTK_MOZ_EMBED_CERT_ISSUER_UNTRUSTED)
    {
        mess |= G_WEB_CERT_MESS_UNKNOWN;
    }
    if (((GMozillaWebCertContext*)context)->error & GTK_MOZ_EMBED_CERT_ISSUER_UNKNOWN)
    {
        mess |= G_WEB_CERT_MESS_UNKNOWN;
    }
    if (((GMozillaWebCertContext*)context)->error & GTK_MOZ_EMBED_CERT_INVALID_CA)
    {
        mess |= G_WEB_CERT_MESS_ALGORITHM;
    }
    self->mCertContexts = g_list_append(self->mCertContexts, context);
    return mess;
}

static GWebCertificateReaction
g_mozilla_web_perform_crtificate_context_action (GMozillaWeb *self,
                                                 GObject *context,
                                                 GWebCertificateAction action,
                                                 GObject *cert)
{
    TRACE_LOG();
    if (action == G_WEB_CERT_ACTION_ACCEPT) {
        GMozillaWebCertContext* ctx = (GMozillaWebCertContext*) context;
        if (ctx->cert != cert) {
            return G_WEB_CERT_REACTION_CLOSE;
        }
    } else if (action == G_WEB_CERT_ACTION_CANCEL) {
        return G_WEB_CERT_REACTION_CLOSE;
    }
    TRACE_LOG();
    return G_WEB_CERT_REACTION_NOTHING;
}

static GWebStatus
g_mozilla_web_get_certificate_context_iter (GMozillaWeb *self,
                                            GObject* context,
                                            GObject **iterator)
{
    TRACE_LOG();
    GList * iter = g_list_find(self->mCertContexts, context);
    if (iter) {
        *iterator = (GObject*)iter;
        return G_WEB_STATUS_OK;
    } else {
        *iterator = NULL;
        return G_WEB_ERR_NULL_POINTER;
    }
    return G_WEB_STATUS_OK;
}

static GObject*
g_mozilla_web_get_certificate_iter (GMozillaWeb *self, GObject** iterator)
{
    TRACE_LOG();
    GList * iter = (GList*)*iterator;
    if (iter->data) {
        GMozillaWebCertContext* context = (GMozillaWebCertContext*)iter->data;
        return (GObject*)context->cert;
    } else {
        return NULL;
    }
    return NULL;
}

static void
g_mozilla_web_certificate_free (GMozillaWeb *self, GObject* cert)
{
    TRACE_LOG();
    /* TBD */
    return;
}

static void
g_mozilla_web_certificate_iter_free (GMozillaWeb *self, GObject* iterator)
{
    TRACE_LOG();
    /* TBD */
    return;
}

static void
g_mozilla_web_notify_plugins (GMozillaWeb *self, gint event)
{
    TRACE_LOG();
   
    gboolean status = FALSE; 
    if((event == G_WEB_PLUGINS_LOW_MEMORY) && (!self->disabled_pllist)) 
    {
       status = g_mozilla_plugin_disable_plugins(&self->disabled_pllist);
    } else if((event == G_WEB_PLUGINS_NORMAL_MEMORY) && (self->disabled_pllist))  
    {
       status = g_mozilla_plugin_enable_plugins (&self->disabled_pllist);
    }
    if(status)
      gtk_moz_embed_common_reload_plugins ();
}

static GWebStatus
g_mozilla_web_set_user_agent_id (GMozillaWeb *self, gint ua_id)
{
    TRACE_LOG();
    if (!gtk_moz_embed_common_set_pref(G_TYPE_INT, G_MOZILLA_PREF_IDENTIFY_AS, &ua_id))
        return G_WEB_ERR;
    gtk_moz_embed_common_save_prefs();
    return G_WEB_STATUS_OK;
}

static gint
g_mozilla_web_get_user_agent_id (GMozillaWeb *self)
{
    TRACE_LOG();
    gint ua_id=0;
    if (!gtk_moz_embed_common_get_pref(G_TYPE_INT, G_MOZILLA_PREF_IDENTIFY_AS, &ua_id))
        return 0;
    return ua_id;
}

static GWebPasswordManager*
g_mozilla_web_get_password_manager (GMozillaWeb *self, const gchar* url, gint index)
{
    TRACE_LOG();
    ULOG_DEBUG_F("get_pwd_mgr: '%s', %i, list: %p", url, index, self->logins_list);
    if (self->logins_list && g_list_length(self->logins_list) >= index)
        return G_WEB_PASSWORD_MANAGER(g_mozilla_password_manager_login_new(url, index, self->logins_list));
    return NULL;
}

static gint
g_mozilla_web_username_matchinfo_get_matches(GMozillaWeb *self, GObject* info)
{
    TRACE_LOG();
    gint matches_count = 0;

    if (info) {

        // NOTE: we should be getting matches_count from glist, but due to UI flow, it is safer to get from engine.
        // matches_count = g_list_length((GList*)info);
        matches_count = gtk_moz_embed_common_get_logins (NULL, NULL);
    }
    ULOG_DEBUG_F("matches_count %d\n", matches_count);
    return matches_count;
}

static void
g_mozilla_web_username_matchinfo_delete (GMozillaWeb *self,  GObject* info, gint index)
{
    TRACE_LOG();
    if (!info)
        return;

    { // evil hacking to make it works with current UI's flow.
        gint num = g_list_length((GList*)info);

        if (!index && (num > 1)) { // 0

            *((GList*) info) = *(g_list_nth ((GList*)info, index+1));
            info = (GObject*)g_list_remove ((GList*) info, g_list_nth_data ((GList*) info, num));

        } else if (num == 1)

            ((GList *) info)->data = NULL;
        else
            info = (GObject*)g_list_remove ((GList*) info, g_list_nth_data ((GList*) info, index));
    }

    // engine part !!!
    gtk_moz_embed_common_remove_passwords (NULL, NULL, index);
}

static GWebStatus
g_mozilla_web_username_matchinfo_get_username (GMozillaWeb *self, GObject* info, gint index, gchar **username)
{
    TRACE_LOG();
    if (!info)
        return G_WEB_ERR;
        
    //FIXME XXX Here probably memory leak
    *username = g_strdup (g_list_nth_data ((GList*)info, index));

    return G_WEB_STATUS_OK;
}

static GWebStatus
g_mozilla_web_store_personal_data (GMozillaWeb *self, const gchar* server,
                                   const gchar* username, const gchar* password)
{
    TRACE_LOG();
    return G_WEB_STATUS_OK;
}

static GWebStatus
g_mozilla_web_delete_personal_data (GMozillaWeb *self, const gchar* server,
                                    const gchar* username)
{
    TRACE_LOG();
    return G_WEB_STATUS_OK;
}

static gboolean
g_mozilla_web_set_pref (GMozillaWeb *self, gpointer type, gchar* name, gpointer value) {

    gboolean result = gtk_moz_embed_common_set_pref((GtkType)type, name, (gchar *)value);
    gtk_moz_embed_common_save_prefs();
    //ULOG_DEBUG_F("EAL:name=%s value=%s result=%d\n", name, (gchar*)value, result);
    return result;
}

static gboolean
g_mozilla_web_get_pref (GMozillaWeb *self, gpointer type, gchar* name, gpointer value) {
    gboolean result = gtk_moz_embed_common_get_pref((GtkType)type, name, value);
    return result;
}

static GWebStatus
g_mozilla_web_clear_all_history (GMozillaWeb *self)
{
    TRACE_LOG();
    if (!g_mozilla_history_list_clear_all ())
        return G_WEB_ERR;
    return G_WEB_STATUS_OK;
}

static void
g_mozilla_web_clear_personal_data (GMozillaWeb *self)
{
    TRACE_LOG();
    /* TBD */
    return;
}

static GWebStatus
g_mozilla_web_clear_passwords (GMozillaWeb *self)
{
    TRACE_LOG();
    gtk_moz_embed_common_remove_passwords (NULL, NULL, -1);
    return G_WEB_STATUS_OK;
}

static GWebStatus
g_mozilla_web_set_remember_password (GMozillaWeb *self, gboolean loads)
{
    TRACE_LOG();
    if (!gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_REMEMBER_PASSWORDS, &loads))
        return G_WEB_ERR;
    gtk_moz_embed_common_save_prefs();
    return G_WEB_STATUS_OK;
}

static gboolean
g_mozilla_web_get_remember_password (GMozillaWeb *self)
{
    TRACE_LOG();
    gboolean remember_password = FALSE;
    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_REMEMBER_PASSWORDS, &remember_password))
        return FALSE;
    return remember_password;
}

static GWebStatus
g_mozilla_web_set_remember_password_for_forms (GMozillaWeb *self, gboolean loads)
{
    TRACE_LOG();
    /* TBD */
    if (!gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_PASSWORDS_SAVING, &loads))
        return G_WEB_ERR;
    gtk_moz_embed_common_save_prefs();
    return G_WEB_STATUS_OK;
}

static gboolean
g_mozilla_web_get_remember_password_for_forms (GMozillaWeb *self)
{
    TRACE_LOG();
    gboolean remember_password = FALSE;
    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_PASSWORDS_SAVING, &remember_password))
        return FALSE;
    return remember_password;
}

static gboolean
g_mozilla_web_get_plugin_enabled (GMozillaWeb *self, gchar *name)
{
    TRACE_LOG();
    gboolean enabled = TRUE;
    enabled = g_mozilla_plugin_get_item_status(name);
    return enabled;
}

static GWebStatus
g_mozilla_web_set_plugin_enabled (GMozillaWeb *self, gchar *name, gboolean enabled)
{
    TRACE_LOG();
    if (g_mozilla_plugin_set_item_status(name, enabled)) {
        gtk_moz_embed_common_reload_plugins ();
        return G_WEB_STATUS_OK;
    }
    return G_WEB_ERR;
}

static GWebStatus
g_mozilla_web_set_oom_cb(GMozillaWeb *self, GFunc callback)
{
    TRACE_LOG();
    /* MTBD | Not used*/
    return G_WEB_STATUS_OK;
}


static GWebStatus
g_mozilla_web_set_plugin_ignore_filepath (GMozillaWeb *self)
{
    TRACE_LOG();
    GWebStatus status = (GWebStatus) 0;
    /* TBD */
    /*IMP
      Needs to implements of reading ignored plugins before Browser starting
      */
    return status;
}

static void
g_mozilla_web_interface_init (GWebIface *iface)
{
    TRACE_LOG();
    iface->destroy                            = (void (*) (GWeb*))
        g_mozilla_web_destroy;
    iface->new_web_engine_window              = (GWebEngine* (*) (GWeb*))
        g_mozilla_web_new_web_engine_window;
    iface->new_web_engine_window_with_context = (GWebEngine* (*) (GWeb*, gpointer, gboolean, gboolean))
        g_mozilla_web_new_web_engine_window_with_context;
//ANTON

    iface->web_set_pref = (gboolean (*) (GWeb*, gpointer, const gchar*, gpointer))
        g_mozilla_web_set_pref;
    iface->web_get_pref = (gboolean (*) (GWeb*, gpointer, const gchar*, gpointer))
        g_mozilla_web_get_pref;

    iface->new_web_transfer_item              = (GWebTransferItem* (*) (GWeb*, const gchar*, const gchar*))
        g_mozilla_web_new_web_transfer_item;
    iface->initialize_web_transfer_item       = (GWebTransferItem* (*) (GWeb*, GObject*))
        g_mozilla_web_initialize_web_transfer_item;
    iface->get_web_transfer_item_list         = (GWebTransferItemList* (*) (GWeb*))
        g_mozilla_web_get_web_transfer_item_list;
    iface->set_home_page                      = (GWebStatus (*) (GWeb*, const gchar*))
        g_mozilla_web_set_home_page;
    iface->get_home_page                      = (gchar* (*) (GWeb*))
        g_mozilla_web_get_home_page;
    iface->set_language                       = (GWebStatus (*) (GWeb*, const gchar*))
        g_mozilla_web_set_language;
    iface->get_language                       = (gchar* (*) (GWeb*))
        g_mozilla_web_get_language;
    iface->reset_cache_history_length         = (void (*) (GWeb*))
        g_mozilla_web_reset_cache_history_length;
    iface->get_maximum_cache_size             = (gint (*) (GWeb*))
        g_mozilla_web_get_maximum_cache_size;
    iface->get_default_home_page              = (gchar* (*) (GWeb*))
        g_mozilla_web_get_default_home_page;
    iface->home_page_set                      = (gboolean (*) (GWeb*))
        g_mozilla_web_home_page_available;
    iface->set_frame_borders_enabled          = (void (*) (GWeb*, gboolean))
        g_mozilla_web_set_frame_borders_enabled;
    iface->get_frame_borders_enabled          = (gboolean (*) (GWeb*))
        g_mozilla_web_get_frame_borders_enabled;
    iface->set_location_completion_suffixes   = (GWebStatus (*) (GWeb*, const gchar*))
        g_mozilla_web_set_location_completion_suffixes;
    iface->get_location_completion_suffixes   = (gchar* (*) (GWeb*))
        g_mozilla_web_get_location_completion_suffixes;
    iface->set_plugins_enabled                = (GWebStatus (*) (GWeb*, gboolean))
        g_mozilla_web_set_plugins_enabled;
    iface->set_ssl2_support                   = (GWebStatus (*) (GWeb*, gboolean))
        g_mozilla_web_set_ssl2_support;
    iface->get_ssl2_support                   = (gboolean (*) (GWeb*))
        g_mozilla_web_get_ssl2_support;
    iface->get_plugins_enabled                = (gboolean (*) (GWeb*))
        g_mozilla_web_get_plugins_enabled;
    iface->set_js_enabled                     = (GWebStatus (*) (GWeb*, gboolean))
        g_mozilla_web_set_js_enabled;
    iface->get_js_enabled                     = (gboolean (*) (GWeb*))
        g_mozilla_web_get_js_enabled;
    iface->set_memory_cache                   = (void (*) (GWeb*, GMemoryCache))
        g_mozilla_web_set_memory_cache;
    iface->get_memory_cache                   = (GMemoryCache (*) (GWeb*))
        g_mozilla_web_get_memory_cache;
    iface->set_cache_size                     = (GWebStatus (*) (GWeb*, gint))
        g_mozilla_web_set_cache_size;
    iface->get_cache_size                     = (gint (*) (GWeb*))
        g_mozilla_web_get_cache_size;
    iface->set_browse_offline                 = (GWebStatus (*) (GWeb*, gboolean))
        g_mozilla_web_set_browse_offline;
    iface->get_browse_offline                 = (gboolean (*) (GWeb*))
        g_mozilla_web_get_browse_offline;
    iface->set_automatic_redirection_enabled  = (GWebStatus (*) (GWeb*, gboolean))
        g_mozilla_web_set_automatic_redirection_enabled;
    iface->get_automatic_redirection_enabled  = (gboolean (*) (GWeb*))
        g_mozilla_web_get_automatic_redirection_enabled;
    iface->set_load_images                    = (GWebStatus (*) (GWeb*, GWebEngineImagePolicy))
        g_mozilla_web_set_load_images;
    iface->get_load_images                    = (GWebEngineImagePolicy (*) (GWeb*))
        g_mozilla_web_get_load_images;
    iface->disconnect                         = (void (*) (GWeb*))
        g_mozilla_web_disconnect;
    iface->clear_cache                        = (GWebStatus (*) (GWeb*))
        g_mozilla_web_clear_cache;
    iface->get_plugins_list                   = (GWebPluginList* (*) (GWeb*))
        g_mozilla_web_get_plugins_list;
    iface->get_history_list                   = (GWebHistoryList* (*) (GWeb*))
        g_mozilla_web_get_history_list;
    iface->set_new_window_loads               = (GWebStatus (*) (GWeb*, gboolean))
        g_mozilla_web_set_new_window_loads;
    iface->get_new_window_loads               = (gboolean (*) (GWeb*))
        g_mozilla_web_get_new_window_loads;
    iface->set_cookie_acceptance              = (void (*) (GWeb*, GCookieAcceptance))
        g_mozilla_web_set_cookie_acceptance;
    iface->get_cookie_acceptance              = (GCookieAcceptance (*) (GWeb*))
        g_mozilla_web_get_cookie_acceptance;
    iface->set_popup_acceptance               = (void (*) (GWeb*, GPopupAcceptance))
        g_mozilla_web_set_popup_acceptance;
    iface->get_popup_acceptance               = (GPopupAcceptance (*) (GWeb*))
        g_mozilla_web_get_popup_acceptance;
    iface->suspend                            = (GWebStatus (*) (GWeb*))
        g_mozilla_web_suspend;
    iface->suspended                          = (gboolean (*) (GWeb*))
        g_mozilla_web_suspended;
    iface->resume                             = (void (*) (GWeb*))
        g_mozilla_web_resume;
    iface->set_ua_string                      = (void (*) (GWeb*, gchar*))
        g_mozilla_web_set_ua_string;
    iface->enable_url_loading                 = (void (*) (GWeb*, gboolean))
        g_mozilla_web_enable_url_loading;
    iface->free_memory               	      = (void (*) (GWeb*, gboolean))
        g_mozilla_web_free_memory;
    iface->store_transfers                    = (GWebStatus (*) (GWeb*))
        g_mozilla_web_store_transfers;
    iface->restore_transfers                  = (GWebStatus (*) (GWeb*))
        g_mozilla_web_restore_transfers;
    iface->delete_all_cookies                 = (GWebStatus (*) (GWeb*))
        g_mozilla_web_delete_all_cookies;
    iface->confirm_cookie                     = (GWebStatus (*) (GWeb*, gpointer, gboolean, GWebCookieAction))
        g_mozilla_web_confirm_cookie;
    iface->get_global                         = (GObject* (*) (GWeb*))
        g_mozilla_web_get_global;
    iface->get_certificate_enum_message       = (GWebCertificateMessage (*) (GWeb*, GObject*))
        g_mozilla_web_get_certificate_enum_message;
    iface->perform_crtificate_context_action  = (GWebCertificateReaction (*) (GWeb*,
                                                                              GObject*,
                                                                              GWebCertificateAction,
                                                                              GObject*))
        g_mozilla_web_perform_crtificate_context_action;
    iface->get_certificate_context_iter       = (GWebStatus (*) (GWeb*, GObject*, GObject**))
        g_mozilla_web_get_certificate_context_iter;
    iface->get_certificate_iter               = (GObject* (*) (GWeb*, GObject**))
        g_mozilla_web_get_certificate_iter;
    iface->certificate_free                   = (void (*) (GWeb*, GObject*))
        g_mozilla_web_certificate_free;
    iface->certificate_iter_free              = (void (*) (GWeb*, GObject*))
        g_mozilla_web_certificate_iter_free;
    iface->notify_plugins                     = (void (*) (GWeb*, gint))
        g_mozilla_web_notify_plugins;
    iface->username_matchinfo_get_matches     = (gint (*) (GWeb*, GObject*))
        g_mozilla_web_username_matchinfo_get_matches;
    iface->username_matchinfo_get_username    = (GWebStatus (*) (GWeb*, GObject*, gint, gchar**))
        g_mozilla_web_username_matchinfo_get_username;
    iface->username_matchinfo_delete          = (void (*) (GWeb*, GObject*, gint))
        g_mozilla_web_username_matchinfo_delete;
    iface->store_personal_data 		      = (GWebStatus (*) (GWeb*, const gchar*, const gchar*, const gchar*))
        g_mozilla_web_store_personal_data;
    iface->delete_personal_data 	      = (GWebStatus (*) (GWeb*, const gchar*, const gchar*))
        g_mozilla_web_delete_personal_data;
    iface->get_password_manager 	      =	(GWebPasswordManager* (*) (GWeb*, const gchar*, gint))
        g_mozilla_web_get_password_manager;
    iface->clear_passwords                    = (GWebStatus (*) (GWeb*))
        g_mozilla_web_clear_passwords;
    iface->clear_all_history                  = (GWebStatus (*) (GWeb*))
        g_mozilla_web_clear_all_history;
    iface->clear_personal_data                = (void (*) (GWeb*))
        g_mozilla_web_clear_personal_data;
    iface->set_remember_password              = (GWebStatus (*) (GWeb*, gboolean))
        g_mozilla_web_set_remember_password;
    iface->get_remember_password	      = (gboolean (*) (GWeb*))
        g_mozilla_web_get_remember_password;
    iface->set_remember_password_for_forms    = (GWebStatus (*) (GWeb*, gboolean))
        g_mozilla_web_set_remember_password_for_forms;
    iface->get_remember_password_for_forms    = (gboolean (*) (GWeb*))
        g_mozilla_web_get_remember_password_for_forms;
    iface->get_plugin_enabled                = (gboolean (*) (GWeb*, gchar*))
        g_mozilla_web_get_plugin_enabled;
    iface->set_plugin_enabled                = (GWebStatus (*) (GWeb*, gchar*, gboolean))
        g_mozilla_web_set_plugin_enabled;
    iface->set_oom_cb                        = (GWebStatus (*) (GWeb*, GFunc))
        g_mozilla_web_set_oom_cb;
    iface->set_plugin_ignore_filepath        = (GWebStatus (*) (GWeb*))
        g_mozilla_web_set_plugin_ignore_filepath;
    iface->set_user_agent_id                  = (GWebStatus (*) (GWeb*, gint))
        g_mozilla_web_set_user_agent_id;
    iface->get_user_agent_id                  = (gint (*) (GWeb*))
        g_mozilla_web_get_user_agent_id;
}


static void
g_mozilla_web_instance_init (GTypeInstance *instance, gpointer  g_class)
{
    TRACE_LOG();
    G_MOZILLA_WEB(instance)->global = NULL;
    G_MOZILLA_WEB(instance)->disabled_pllist = NULL;
    G_MOZILLA_WEB(instance)->mCertContexts = NULL;
    G_MOZILLA_WEB(instance)->anime_cursor = g_new0(AnimeCursor, 1);
#ifdef MOZEAL_LOGGING
    if (g_strrstr(g_getenv("MOZEAL_LOG"), "trace") || g_str_has_prefix(g_getenv("MOZEAL_LOG"), "all")) {
        bmozeal_trace = TRUE;
    }
#endif		
}

GType
g_mozilla_web_get_type (void)
{
    static GType type = 0;
    if (type == 0)
    {
        static const GTypeInfo info =
        {
            sizeof (GMozillaWebClass),
            NULL,   /* base_init */
            NULL,   /* base_finalize */
            (GClassInitFunc) g_mozilla_web_class_init, /* class_init */
            NULL,   /* class_finalize */
            NULL,   /* class_data */
            sizeof (GMozillaWeb),
            0,      /* n_preallocs */
            g_mozilla_web_instance_init    /* instance_init */
        };
        static const GInterfaceInfo iface_info =
        {
            (GInterfaceInitFunc) g_mozilla_web_interface_init,
            NULL,   /* interface_finalize */
            NULL    /* interface_data */
        };
        type = g_type_register_static (G_TYPE_OBJECT,
                                       "GMozillaWeb",
                                       &info, (GTypeFlags) 0);
        g_type_add_interface_static (type,
                                     G_TYPE_WEB,
                                     &iface_info);
    }
    return type;
}

static void
g_mozilla_web_class_init (GMozillaWebClass * klass)
{
    TRACE_LOG ();
    GObjectClass *gobject_class;
    GtkObjectClass *object_class;
    GtkWidgetClass *widget_class;
    //GtkMozEmbedClass *moz_embed_class;

    gobject_class = (GObjectClass *) klass;
    object_class = (GtkObjectClass *) klass;
    widget_class = (GtkWidgetClass *) klass;

    g_mozilla_web_signals[ASK_COOKIE] =
        g_signal_new("ask-cookie",
                     G_OBJECT_CLASS_TYPE (gobject_class),
                     G_SIGNAL_RUN_LAST,
                     G_STRUCT_OFFSET(GMozillaWebClass, ask_cookie),
                     NULL, NULL,
                     g_mozeal_marshal_VOID__POINTER_INT_STRING_STRING_STRING_STRING_STRING_BOOLEAN_INT,
                     G_TYPE_NONE, 9,
                     G_TYPE_POINTER,
                     G_TYPE_INT,
                     G_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE,
                     G_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE,
                     G_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE,
                     G_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE,
                     G_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE,
                     G_TYPE_BOOLEAN,
                     G_TYPE_INT);

    g_mozilla_web_signals[CERTIFICATE_DIALOG] =
        g_signal_new("certificate-dialog",
                     G_OBJECT_CLASS_TYPE (gobject_class),
                     G_SIGNAL_RUN_LAST,
                     G_STRUCT_OFFSET(GMozillaWebClass, certificate_dialog),
                     NULL, NULL,
                     g_mozeal_marshal_BOOL__POINTER,
                     G_TYPE_BOOLEAN, 1, G_TYPE_POINTER);

    g_mozilla_web_signals[CERTIFICATE_PASSWORD_DIALOG] =
        g_signal_new("certificate-password-dialog",
                     G_OBJECT_CLASS_TYPE (gobject_class),
                     G_SIGNAL_RUN_LAST,
                     G_STRUCT_OFFSET(GMozillaWebClass, certificate_password_dialog),
                     NULL, NULL,
                     g_mozeal_marshal_VOID__STRING_STRING_POINTER,
                     G_TYPE_NONE, 3,
                     G_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE,
                     G_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE,
                     G_TYPE_POINTER);

    g_mozilla_web_signals[CERTIFICATE_DETAILS] =
        g_signal_new("certificate-details",
                     G_OBJECT_CLASS_TYPE (gobject_class),
                     G_SIGNAL_RUN_LAST,
                     G_STRUCT_OFFSET(GMozillaWebClass, certificate_details),
                     NULL, NULL,
                     g_cclosure_marshal_VOID__POINTER,
                     G_TYPE_NONE, 1, G_TYPE_POINTER);

    g_mozilla_web_signals[HISTORY_ADDED] =
        g_signal_new("global-history-item-added",
                     G_OBJECT_CLASS_TYPE (gobject_class),
                     G_SIGNAL_RUN_LAST,
                     G_STRUCT_OFFSET(GMozillaWebClass, history_added),
                     NULL, NULL,
                     gtk_marshal_VOID__STRING,
                     G_TYPE_NONE, 1,
                     G_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE);

    g_mozilla_web_signals[ON_SUBMIT_SIGNAL] =
        g_signal_new("on-submit",
                     G_OBJECT_CLASS_TYPE (gobject_class),
                     G_SIGNAL_RUN_LAST,
                     G_STRUCT_OFFSET(GMozillaWebClass, on_submit),
                     NULL, NULL,
                     g_mozeal_marshal_INT__VOID,
                     G_TYPE_INT, 0);
    g_mozilla_web_signals[SELECT_MATCH_SIGNAL] =
        g_signal_new("select-match",
                     G_OBJECT_CLASS_TYPE (gobject_class),
                     G_SIGNAL_RUN_LAST,
                     G_STRUCT_OFFSET(GMozillaWebClass, select_match),
                     NULL, NULL,
                     g_mozeal_marshal_INT__POINTER,
                     G_TYPE_INT, 1, G_TYPE_POINTER);

    g_mozilla_web_signals[MODAL_DIALOG] =
        g_signal_new(G_WEBWIDGET_SIGNAL_MODAL_DIALOG,
                     G_OBJECT_CLASS_TYPE (gobject_class),
                     G_SIGNAL_RUN_LAST,
                     G_STRUCT_OFFSET(GMozillaWebClass, modal_dialog),
                     NULL, NULL,
                     g_mozeal_marshal_INT__STRING_STRING_INT_INT_INT_INT,
                     G_TYPE_INT,
                     6, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT,
                     G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);

    g_mozilla_web_signals[CONNECTIVITY_STATUS] =
        g_signal_new("connectivity-status",
                     G_OBJECT_CLASS_TYPE (gobject_class),
                     G_SIGNAL_RUN_LAST,
                     G_STRUCT_OFFSET(GMozillaWebClass, connectivity_status),
                     NULL, NULL,
                     g_cclosure_marshal_VOID__INT,
                     G_TYPE_NONE, 1, G_TYPE_INT);

}

static gboolean
gtk_moz_common_certificate_error_cb(GtkMozEmbedCommon *common, GObject * aCert, guint aError, GMozillaWeb *self)
{
    TRACE_LOG();

    gboolean ret_val = FALSE;

    gint len = 0;
    unsigned char *p = gtk_moz_embed_common_nsx509_to_raw((gpointer)aCert, &len);

    gpointer certPtr = NULL;

#ifndef NEW_OPENSSL
    certPtr = d2i_X509 (NULL, (unsigned char **)&p, len);
#else
    certPtr = d2i_X509 (NULL, (unsigned char **) &p, len);
#endif

    g_signal_emit(G_OBJECT(self), g_mozilla_web_signals[CERTIFICATE_DETAILS], 0, certPtr);
    GMozillaWebCertContext *context = g_new0(GMozillaWebCertContext, 1);
    context->cert = certPtr;
    context->error = aError;
    self->mCertContexts = g_list_append(self->mCertContexts, context);

#ifdef USE_CST
    // validating CERTIFICATE with maemo CertMan DB first.
    CST* storage;
    cst_t_seqnum id;
    storage = CST_open_file("/usr/share/certs/certman.cst", FALSE, NULL);

    // Get stack representing the certificate chain
    GSList* certificates = CST_get_chain(storage, certPtr);
    if (certificates) 
        return ret_val;

    id = CST_search_by_X509(storage, certPtr);
    // Check if certificate exists and if it is meant for browser or wlam connections.
    if (!id ||
        (!(CST_is_purpose(storage, id, CST_PURPOSE_SSL_SERVER) || CST_is_purpose (storage, id, CST_PURPOSE_SSL_CLIENT)) &&
        (!(CST_is_purpose(storage, id, CST_PURPOSE_SSL_WLAN)))))
#endif
         g_signal_emit(G_OBJECT(self), g_mozilla_web_signals[CERTIFICATE_DIALOG], 0, context, &ret_val);

    return ret_val;
};

static gint gtk_moz_common_username_select_login_cb(GtkMozEmbedCommon *common, GList * logins, GMozillaWeb *self)
{
    TRACE_LOG();
    gint ret_val = -1;
    g_signal_emit(G_OBJECT(self), g_mozilla_web_signals[SELECT_MATCH_SIGNAL], 0, (const gpointer)logins, &ret_val);
    return ret_val;
};

static gint gtk_moz_common_remember_login_cb (GtkMozEmbedCommon *common, GMozillaWeb *self)
{
    TRACE_LOG();
    gint ret_val = -1;
    g_signal_emit (G_OBJECT(self), g_mozilla_web_signals[ON_SUBMIT_SIGNAL], 0, &ret_val);

    return ret_val;
};

static void gtk_moz_common_ask_cookie_cb (GtkMozEmbedCommon *common, gpointer context, 
                                     gint actions, const gchar * url,
                                     const gchar * name, const gchar * value,
                                     const gchar * domain, const gchar * path,
                                     gboolean illegal_path, gint expire, 
                                     GMozillaWeb *self) {

    TRACE_LOG();
    g_signal_emit_by_name(GTK_OBJECT(self), "ask-cookie", context, actions, url, name, value, domain, path, illegal_path, expire);

    return ;
}

/*
   static void gtk_moz_common_modal_dialog_cb()
   {
   TRACE_LOG();
   };
   */
/*
   static void gtk_moz_common_certificate_password_dialog_cb() 
   {
   TRACE_LOG();
   };
   */
/*
   static void gtk_moz_common_certificate_details_cb(GtkMozEmbedCommon *common, GObject * details, GMozillaWeb *self)
   {
   TRACE_LOG();
   g_signal_emit(G_OBJECT(self), g_mozilla_web_signals[CERTIFICATE_DETAILS], 0, details);
   };


   static void gtk_moz_common_history_added_cb() 
   {
   TRACE_LOG();
   };
   */

static void
g_mozilla_web_global_coonect(GMozillaWeb *self)
{
    TRACE_LOG();
    g_signal_connect (G_OBJECT (self->global), "certificate-error",
                      G_CALLBACK (gtk_moz_common_certificate_error_cb), self);
    g_signal_connect (G_OBJECT (self->global), "select-login",
                      G_CALLBACK (gtk_moz_common_username_select_login_cb), self);
    g_signal_connect (G_OBJECT (self->global), "remember-login",
                      G_CALLBACK (gtk_moz_common_remember_login_cb), self);
    g_signal_connect (G_OBJECT (self->global), "ask-cookie",
                      G_CALLBACK (gtk_moz_common_ask_cookie_cb), self);

    //    g_signal_connect (G_OBJECT (self->global), "modal-dialog",
    //                      G_CALLBACK (gtk_moz_common_modal_dialog_cb), self);
    /*    g_signal_connect (G_OBJECT (self->global), "certificate-password-dialog",
          G_CALLBACK (gtk_moz_common_certificate_password_dialog_cb), self);
          g_signal_connect (G_OBJECT (self->global), "certificate-details",
          G_CALLBACK (gtk_moz_common_certificate_details_cb), self);
          g_signal_connect (G_OBJECT (self->global), "global-history-item-added",
          G_CALLBACK (gtk_moz_common_history_added_cb), self);
          */

    g_mozilla_connectivity_set_global(self);
}


static void
g_mozilla_web_set_default_config (GMozillaWeb *self)
{
    TRACE_LOG();
    gchar *sval;
    gint gval = 0;
    gboolean bval = TRUE;
    gboolean btval = TRUE;
    gboolean bfval = FALSE;

    // for flash, need a better name :)
    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, "plugins.flashhack", &bfval))
        gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, "plugins.flashhack", &bfval); // This change has been requested by Leonid.

    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, "plugins.enableSuspending", &bval))
        gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, "plugins.enableSuspending", &bval);
    
    // enabling xul error pages
    gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_XUL_ERROR_PAGE, &btval);

    // no proxy for tbox - this is only for test purposes, and has to be removed when not needed anymore.
	if (!gtk_moz_embed_common_get_pref(G_TYPE_STRING, G_MOZILLA_PREF_OMITTED_HOSTS_PROXY, &sval))
        gtk_moz_embed_common_set_pref(G_TYPE_STRING, G_MOZILLA_PREF_OMITTED_HOSTS_PROXY, "127.0.0.1");
    else
        g_free(sval);
    sval = NULL;

    // activating snav
    gtk_moz_embed_common_set_pref(G_TYPE_INT, G_MOZILLA_PREF_SPATIAL_NAVIGATION, &gval);
    gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, "snav.enabled", &btval);
    gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, "snav.ignoreTextFields", &bfval);
    gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, "snav.disableJS", &btval);

    // focus border styling
/*    gval = 3;
    if (!gtk_moz_embed_common_get_pref(G_TYPE_INT, G_MOZILLA_PREF_FOCUS_RING_WIDTH, &gval))
        gtk_moz_embed_common_set_pref(G_TYPE_INT, G_MOZILLA_PREF_FOCUS_RING_WIDTH, &gval);
    
    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, "browser.display.focus_ring_on_anything", &bval))
        gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, "browser.display.focus_ring_on_anything", &btval);
*/
    // gtk_moz_embed_common_set_pref(G_TYPE_STRING, G_MOZILLA_PREF_FOCUS_TEXT_COLOR, "#9d0202");
    // gtk_moz_embed_common_set_pref(G_TYPE_STRING, G_MOZILLA_PREF_FOCUS_BACKGROUND_COLOR, "#f6ff08");

/*    if (gtk_moz_embed_common_get_pref(G_TYPE_STRING, G_MOZILLA_PREF_USER_UA_ADD, &sval))
    {
        gchar *temp_str = g_strdup_printf ("%s", sval);
        gtk_moz_embed_common_set_pref(G_TYPE_STRING, G_MOZILLA_PREF_EAL_NAME, temp_str);
        g_free(temp_str);
        g_free(sval);
        sval = NULL;
    }
    else {
        gtk_moz_embed_common_set_pref(G_TYPE_STRING, G_MOZILLA_PREF_EAL_NAME, MOZILLA_DEFAULT_VENDOR_NAME);
    }

    gtk_moz_embed_common_set_pref(G_TYPE_STRING, G_MOZILLA_PREF_EAL_VER, VERSION);
    gtk_moz_embed_common_set_pref(G_TYPE_STRING, G_MOZILLA_PREF_EAL_MILESTONE, EAL_MILESTONE);*/


    //    if (config)
    //        gtk_moz_embed_common_set_pref(G_TYPE_STRING, G_MOZILLA_PREF_UI_STRING, config->ua_string);

    if (!gtk_moz_embed_common_get_pref(G_TYPE_STRING, G_MOZILLA_PREF_HOME_PAGE_LOCATION, &sval))
        gtk_moz_embed_common_set_pref(G_TYPE_STRING, G_MOZILLA_PREF_HOME_PAGE_LOCATION, BROWSER_DEFAULT_PAGE);
    else
        g_free(sval);
    sval = NULL;

    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_USE_DEFAULT_HOME_PAGE, &bval))
        gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_USE_DEFAULT_HOME_PAGE, &btval);

    if (!gtk_moz_embed_common_get_pref(G_TYPE_STRING, G_MOZILLA_PREF_WEB_ADDRESS_SUFFIXES, &sval))
        gtk_moz_embed_common_set_pref(G_TYPE_STRING, G_MOZILLA_PREF_WEB_ADDRESS_SUFFIXES, ".com .org");
    else
        g_free(sval);
    sval = NULL;

    if (!gtk_moz_embed_common_get_pref(G_TYPE_STRING, G_MOZILLA_PREF_GNOMEVFS_SUPPORT, &sval))
        gtk_moz_embed_common_set_pref(G_TYPE_STRING, G_MOZILLA_PREF_GNOMEVFS_SUPPORT, "smb:,obex:,upnpav:");
    else
        g_free(sval);
    sval = NULL;

    gval = 1024;
    if (!gtk_moz_embed_common_get_pref(G_TYPE_INT, G_MOZILLA_PREF_MEMORY_CACHE_SIZE, &gval))
        gtk_moz_embed_common_set_pref(G_TYPE_INT, G_MOZILLA_PREF_MEMORY_CACHE_SIZE, &gval);

    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_ENABLE_JAVA_SCRIPT, &bval))
        gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_ENABLE_JAVA_SCRIPT, &btval);

    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, "layout.full.zoom.mode.fast", &bval))
        gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, "layout.full.zoom.mode.fast", &bfval);

//    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, "layout.full.true.zoom.mode", &bval))
        gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, "layout.full.true.zoom.mode", &btval);

    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, "gtkmozembed.nasty_progress", &bval))
        gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, "gtkmozembed.nasty_progress", &btval);

    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_ENABLE_JAVA, &bval))
        gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_ENABLE_JAVA, &btval);

    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_ENABLE_SSL2, &bval))
        gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_ENABLE_SSL2, &btval);

    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_ENABLE_PLUGINS, &bval))
        gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_ENABLE_PLUGINS, &bfval);

    gval = G_MOZILLA_PREF_REDIRECTION_DEFAULT_LIMIT;
    if (!gtk_moz_embed_common_get_pref(G_TYPE_INT, G_MOZILLA_PREF_REDIRECTION_LIMIT, &gval))
        gtk_moz_embed_common_set_pref(G_TYPE_INT, G_MOZILLA_PREF_REDIRECTION_LIMIT, &gval);

    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_ACCEPT_COOKIES, &bval))
        gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_ACCEPT_COOKIES, &btval);

    gval = 1;
    if (!gtk_moz_embed_common_get_pref(G_TYPE_INT, G_MOZILLA_PREF_ENABLE_POPUP_WINDOWS, &gval))
        gtk_moz_embed_common_set_pref(G_TYPE_INT, G_MOZILLA_PREF_ENABLE_POPUP_WINDOWS, &gval);

    bval = FALSE;
    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_OPEN_POPUP_DURING_LOAD, &bval))
        gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_OPEN_POPUP_DURING_LOAD, &bval);

    //    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_SECURE_ENTER, &bval))
    gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_SECURE_ENTER, &bfval);

    //    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_SECURE_LEAVE, &bval))
    gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_SECURE_LEAVE, &bfval);

    //    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_SECURE_SUBMIT, &bval))
    gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_SECURE_SUBMIT, &bfval);

    gval = 1;
    if (!gtk_moz_embed_common_get_pref(G_TYPE_INT, G_MOZILLA_PREF_SHOW_IMAGES, &gval))
        gtk_moz_embed_common_set_pref(G_TYPE_INT, G_MOZILLA_PREF_SHOW_IMAGES, &gval);

    gval = 5;
    if (!gtk_moz_embed_common_get_pref(G_TYPE_INT, G_MOZILLA_PREF_PANNING_SENS, &gval))
        gtk_moz_embed_common_set_pref(G_TYPE_INT, G_MOZILLA_PREF_PANNING_SENS, &gval);

    gchar *lang = getenv("LANG");
    g_mozilla_web_set_language (self, lang ? lang : getenv("LC_MESSAGES"));

    //if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_FORCE_AUTOCOMPLETION, &bval))
    gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_FORCE_AUTOCOMPLETION, &btval);

    if (!gtk_moz_embed_common_get_pref(G_TYPE_STRING, G_MOZILLA_PREF_SIGNON_FILE, &sval))
        gtk_moz_embed_common_set_pref(G_TYPE_STRING, G_MOZILLA_PREF_SIGNON_FILE, "passwords.s");
    else
        g_free(sval);
    sval = NULL;    

    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_REMEMBER_PASSWORDS, &bval))
        gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_REMEMBER_PASSWORDS, &btval);

    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_REMEMBER_SIGNONS, &bval))
        gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_REMEMBER_SIGNONS, &btval);

    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_PASSWORDS_SAVING, &bval))
        gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_PASSWORDS_SAVING, &btval);

    gval = 30;
    if (!gtk_moz_embed_common_get_pref(G_TYPE_INT, G_MOZILLA_PREF_BROWSER_HISTORY_EXPIRE_DAYS, &gval))
        gtk_moz_embed_common_set_pref(G_TYPE_INT, G_MOZILLA_PREF_BROWSER_HISTORY_EXPIRE_DAYS, &gval);

    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_DISABLE_ZOOM_NAV_CHANGE, &bval))
        gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_DISABLE_ZOOM_NAV_CHANGE, &btval);

    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_JSFOCUS_FOR_VISIBLE_AREA, &bval))
        gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, G_MOZILLA_PREF_JSFOCUS_FOR_VISIBLE_AREA, &btval);

#ifdef USE_HILDON2007                                                                                                                                    
    if (!gtk_moz_embed_common_get_pref(G_TYPE_BOOLEAN, "mozilla.widget.allow_native_theme", &bval))                                                      
            gtk_moz_embed_common_set_pref(G_TYPE_BOOLEAN, "mozilla.widget.allow_native_theme", &btval);                                                      
#endif          

    gtk_moz_embed_common_save_prefs();

    self->is_configured = TRUE;

}

GObject*
g_web_new (void)
{
    TRACE_LOG();
    GObject* instance = G_OBJECT(g_object_new(g_mozilla_web_get_type(), NULL));
    G_MOZILLA_WEB(instance)->global = G_OBJECT(gtk_moz_embed_common_new());
    G_MOZILLA_WEB(instance)->is_configured = FALSE;
    g_mozilla_web_global_coonect(G_MOZILLA_WEB(instance));
    return instance;
}

gboolean
g_mozilla_create_extensions_folder(void)
{
    const gchar *name = NULL;
    // the extensions path
    gchar *dirExtensionsPath = getenv ("MOZILLA_INTERNAL_EXTENSIONS_DIR");
    
    GDir *pluginDir;
    g_unlink(dirExtensionsPath);

    if (-1 == g_access(dirExtensionsPath, R_OK))
    {
        g_mkdir_with_parents(dirExtensionsPath, 0755);
    }

    pluginDir = g_dir_open (EXTENSIONS_DIR, 0, NULL);
    if (!pluginDir)
        return FALSE;
    while ((name = g_dir_read_name (pluginDir)))
    {
        gchar *destinyPath = g_strdup_printf("%s/%s", dirExtensionsPath, name);

        if (-1 == g_access(destinyPath, R_OK))
        {
            gchar *path = g_strdup_printf("%s/%s", EXTENSIONS_DIR, name);
            symlink(path, destinyPath);
            g_free(path);
        }
        g_free(destinyPath);
    }
    g_dir_close (pluginDir);
    return TRUE;
}

void
g_web_set_env (void)
{
    TRACE_LOG();
    gtk_moz_embed_set_path(PREFIX"/lib/microb-engine");
    char *home_path;
    char *full_path;

    home_path = (char*)getenv("HOME");
    if (!home_path)
    {
        fprintf(stderr, "Failed to get HOME\n");
        exit(1);
    }
    gchar *plugins_path = g_strdup_printf("%s/%s/%s", getenv ("HOME"), ".mozilla", "plugins");
    setenv("MOZILLA_INTERNAL_PLUGINS_DIR", plugins_path, 0);
    gchar *extensions_path = g_strdup_printf("%s/%s/%s", getenv ("HOME"), ".mozilla/microb", "extensions");
    setenv("MOZILLA_INTERNAL_EXTENSIONS_DIR", extensions_path, 0);
    setenv("MOZ_PLUGIN_PATH", plugins_path, 0);
    setenv("MOZ_DISABLE_SIG_HANDLER", "1", 0);
    full_path = g_strdup_printf("%s/%s", home_path, ".mozilla");
    gtk_moz_embed_set_profile_path(full_path, "microb");
    gtk_moz_embed_set_comp_path(full_path);
    symlink(OSSO_PLUGINS, plugins_path);
    g_mozilla_create_extensions_folder();
#ifdef USE_HILDON
    /* Hack workaround (Hildon Gtk Theme s...) for setup proper bg[selected] style */
    gtk_rc_parse_string("style \"MicrobBG\" = \"osso-logical-colors\"\n"
                        "{\n" "bg[SELECTED] = \"SelectionColor\"\n" "}"
                        "widget_class \"GtkInvisible\" style \"MicrobBG\"");
#endif
    g_free(plugins_path);
    g_free(extensions_path);
    g_free(full_path);
	gtk_moz_embed_push_startup();

    return;
}

