"""
Module for launching child processes.
"""

from utils import maemo

import dbus, dbus.glib, dbus.service
import subprocess


_IFACE = "de.pycage.mediabox"

_magic = 0

stdin = None
stdout = None

        
def set_magic(magic):

    global _magic

    if (not _magic):
        _magic = magic    
            
            
class Launcher(dbus.service.Object):

    def __init__(self, object_path = "/de/pycage/mediabox"):
    
        bus = maemo.get_session_bus()
        name = dbus.service.BusName(_IFACE, bus = bus)
        dbus.service.Object.__init__(self, name, object_path)
        
        
    @dbus.service.method(dbus_interface = _IFACE, in_signature = "us", out_signature = "uu")
    def launch(self, magic, command):
        global stdin, stdout
        
        # simple security measure
        if (magic != _magic): return (0, 0)
        
        p = subprocess.Popen([command], shell=True,
                             stdin=subprocess.PIPE, stdout=subprocess.PIPE,
                             close_fds=True)
        stdin = p.stdin
        stdout = p.stdout
        #print stdout.read()
        return (p.stdin.fileno(), p.stdout.fileno())

