from utils.Observable import Observable
from utils import maemo

import dbus
import gobject


_HAL_SERVICE = "org.freedesktop.Hal"
_HEADSET_PATH = "/org/freedesktop/Hal/devices/platform_retu_headset_logicaldev_input"
_HAL_DEVICE_IFACE = "org.freedesktop.Hal.Device"

_HEADPHONE_SYS = "/sys/devices/platform/gpio-switch/headphone/state"


class _Headset(Observable):

    OBS_CONNECTED = 0
    OBS_DISCONNECTED = 1
    OBS_BUTTON_PRESSED = 2
    

    def __init__(self):
    
        self.__is_connected = True
        
    
        # monitor headset button
        try:
            bus = maemo.get_system_bus()
            obj = bus.get_object(_HAL_SERVICE, _HEADSET_PATH)
            device = dbus.Interface(obj, _HAL_DEVICE_IFACE)
            device.connect_to_signal("Condition", self.__on_hal_condition)
        except dbus.DBusException:
            print "Unable to monitor headset button"

        # monitor headset status
        try:
            fd = open(_HEADPHONE_SYS, "r")
            self.__on_connect(None, None)            
            self.__watcher = gobject.io_add_watch(fd, gobject.IO_PRI,
                                                  self.__on_connect)
        except:
            print "Unable to monitor headset connection"


        # set up speaker control
        try:
            bus = maemo.get_session_bus()
            obj = bus.get_object("com.nokia.osso_hp_ls_controller",
                                 "/com/nokia/osso_hp_ls_controller")
            self.__speaker = dbus.Interface(obj,
                                  "com.nokia.osso_hp_ls_controller.loudspeaker")
        except dbus.DBusException:
            print "Cannot force loudspeaker"
            self.__speaker = None



    def __on_hal_condition(self, arg1, arg2):

        if ((arg1, arg2) == ("ButtonPressed", "phone")):
            print "headset button pressed"
            self.update_observer(self.OBS_BUTTON_PRESSED)



    def __on_connect(self, src, cond):
        
        if (src): src.read()

        state = open(_HEADPHONE_SYS, "r").read().strip()
        if (state == "disconnected"):
            self.__is_connected = False
            print "headphones disconnected"
            self.update_observer(self.OBS_DISCONNECTED)
        elif (state == "connected"):
            self.__is_connected = True
            print "headphones connected"            
            self.update_observer(self.OBS_CONNECTED)

        return True


    def is_connected(self):
    
        return self.__is_connected


    def set_force_speaker(self, value):
        
        if (not self.__speaker): return

        # TODO: can this state be monitored?        
        if (value):
            self.__speaker.force_loudspeaker_on()
        else:
            self.__speaker.force_loudspeaker_off()

        
_singleton = _Headset()
def Headset(): return _singleton

