from fcntl import ioctl
import os


# kernel definitions for ioctl commands
_IOC_NRBITS   = 8
_IOC_TYPEBITS = 8
_IOC_SIZEBITS = 14
_IOC_DIRBITS  = 2

_IOC_NRSHIFT   = 0
_IOC_TYPESHIFT = _IOC_NRSHIFT + _IOC_NRBITS
_IOC_SIZESHIFT = _IOC_TYPESHIFT + _IOC_TYPEBITS
_IOC_DIRSHIFT  = _IOC_SIZESHIFT + _IOC_SIZEBITS

_IOC_NONE = 0
_IOC_WRITE = 1
_IOC_READ  = 2


_IOC  = lambda d,t,nr,size: (d << _IOC_DIRSHIFT) | (ord(t) << _IOC_TYPESHIFT) | \
                            (nr << _IOC_NRSHIFT) | (size << _IOC_SIZESHIFT)
_IO   = lambda t,nr:      _IOC(_IOC_NONE, t, nr, 0)
_IOW  = lambda t,nr,size: _IOC(_IOC_WRITE, t, nr, size)
_IOR  = lambda t,nr,size: _IOC(_IOC_READ, t, nr, size)
_IOWR = lambda t,nr,size: _IOC(_IOC_READ | _IOC_WRITE, t, nr, size)

_OMAP_IOW  = lambda num,d: _IOW ('O', num, d)
_OMAP_IOR  = lambda num,d: _IOR ('O', num, d)
_OMAP_IOWR = lambda num,d: _IOWR('O', num, d)
_OMAP_IO   = lambda num:   _IO  ('O', num)

_OMAPFB_SYNC_GFX = _OMAP_IO(37)
_OMAPFB_VSYNC    = _OMAP_IO(38)

_OMAPFB_DEV = "/dev/fb0"


def sync_gfx():

    try:
        fd = os.open(_OMAPFB_DEV, os.O_RDONLY)
        ioctl(fd, _OMAPFB_SYNC_GFX)
        os.close(fd)
    except:
        pass
    
    
if (__name__ == "__main__"):
    sync_gfx()

