#!/usr/bin/env python2.5

import dbus
import dbus.service
import dbus.glib

class MaemoPlazerService(dbus.service.Object):
    def __init__(self, maemoplazer, session_bus, object_path):
        self.maemoplazer = maemoplazer
        dbus.service.Object.__init__(self, session_bus, object_path)

    @dbus.service.method("org.foinse_project.geoclue.position", in_signature='', out_signature='dd')
    def current_position(self):
        # FIXME: We have to somehow get dbus-python to return multiple values here
        return (self.maemoplazer.lat, self.maemoplazer.lon)

    @dbus.service.signal("org.foinse_project.geoclue.position")
    def current_position_changed(self, lat, lon):
        pass
        
    @dbus.service.method("org.foinse_project.geoclue.position")
    def current_altitude(self):
        return 0

    @dbus.service.method("org.foinse_project.geoclue.position")
    def service_provider(self):
        return "Plazes"
