/* This file is part of the KMPlayer project
 *
 * Copyright (C) 2005 Koos Vriezen <koos.vriezen@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * until boost gets common, a more or less compatable one ..
 */

#ifndef _KMPLAYER_CONTROL_H_
#define _KMPLAYER_CONTROL_H_

#include "kmplayerplaylist.h"

namespace KMPlayer {

struct PlayListData {
    PlayListData (short id, PlayListData * n = 0L);
    NodePtr document;
    NodePtrW current;
    GdkPixbuf * icon;
    short id;
    bool show_all;
    bool edit_mode;
    PlayListData * next;
};

} // namespace

#endif // _KMPLAYER_CONTROL_H_
