/* This file is part of the KMPlayer project
 *
 * Copyright (C) 2004 Koos Vriezen <koos.vriezen@xs4all.nl>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _KMPLAYER_H_
#define _KMPLAYER_H_

#include <libosso.h>
#include "kmplayertypes.h"
#include "kmplayerplaylist.h"

#define GCONF_KEY_PREFIX "/apps/maemo/kmplayer"
#define GCONF_KEY_RECENT_FILE GCONF_KEY_PREFIX"/recent_file"
#define GCONF_KEY_PLAYLIST_FILE GCONF_KEY_PREFIX"/playlist_file"
#define GCONF_KEY_LOCATION_URL GCONF_KEY_PREFIX"/location"
#define GCONF_KEY_PLAYER GCONF_KEY_PREFIX"/player"

#define HSPLIT 320
#define VSPLIT 260

typedef struct _HildonProgram HildonProgram;
typedef struct _HildonWindow HildonWindow;
typedef struct _GConfClient GConfClient;
namespace KMPlayer {
    struct PlayListData;
    class Control;
    class ViewArea;
    class Node;
    class Process;
}

class WaitNotify {
    GtkWindow * window;
public:
    WaitNotify (GtkWindow * w, const KMPlayer::String & txt);
    ~WaitNotify ();
};

/* Application UI data struct */
class Application {
    KMPlayer::Config * m_config;
public:
    Application ();
    ~Application ();
    void initControl ();
    void jump (KMPlayer::Node * n);
    void fullScreen ();
    void normalScreen ();
    void setPlaying (bool play);
    void setInfoContent (const char * utf8, bool plaintext);
    KMPlayer::Config *config();
    HildonProgram *program;
    HildonWindow *window;
    HildonWindow *window_fullscreen;
    osso_context_t *osso_context;
    GtkWidget * main_toolbar;
    GtkToolItem * tb_play;
    GtkToolItem * tb_pause;
    GtkToolItem * tb_location;
    GtkToolItem * tb_progress;
    GtkWidget * playlist_view;
    GtkWidget * infopanel_view;
    GtkWidget * info_viewport;
    GtkWidget * html_infopanel_view;
    GtkWidget * html_viewport;
    GtkWidget * view_area;
    GtkWidget * view_area_fullscreen;
    GtkWidget * menu_item_playlist_copy;
    GtkWidget * menu_item_playlist_paste;
    GtkWidget * menu_item_playlist_paste_in_group;
    GtkWidget * menu_item_playlist_cut;
    GtkWidget * menu_item_playlist_showall;
    GtkWidget * menu_item_playlist_edit;
    GtkWidget * menu_item_media_server;
    GtkWidget * menu_item_mplayer;
    GtkWidget * tb_item_playlist_commit;
    GtkWidget * location_bar;
    GtkWidget * progress_bar;
    GtkPaned * hsplit_view;
    GtkPaned * vsplit_view;
    GtkWidget * isplit_view;
    //GtkComboBoxEntry * location_bar;
    GtkCellRenderer * playlist_cell_renderer;
    KMPlayer::PlayListData * playlist_data;
    KMPlayer::Control * control;
    KMPlayer::ViewArea * viewarea;
    KMPlayer::NodePtr playlists;
    KMPlayer::NodePtr recents;
    KMPlayer::String url;
    KMPlayer::String copyPasteUrl;
    KMPlayer::NodePtr copyPasteNode;
    KMPlayer::Process * media_server;
    KMPlayer::Process * mplayer;
    short playlists_tree_id;
    short recents_tree_id;
    bool in_tree_update; // no events when updating
    bool fullscreen;
    bool playing;
};


#ifdef __cplusplus
extern "C" {
#endif

GtkWidget * createTreeView (Application * app);
short addTree (Application * a, KMPlayer::NodePtr doc, GdkPixbuf * ico);
void togglePlaylistShow (GtkCheckMenuItem *checkmenuitem, Application * app);
void togglePlaylistShowAll (GtkCheckMenuItem *checkmenuitem, Application * app);
void togglePlaylistEdit (GtkCheckMenuItem *checkmenuitem, Application * app);
void toggleMediaServer (GtkCheckMenuItem *radio, Application * app);
void mainMenuShow (GtkWidget *, Application * app);
void mainMenuHide (GtkWidget *, Application * app);
void programTopMost (GObject * self, GParamSpec * param, Application * app);
void cb_mainview_deleted (GtkObject * w, Application * app);
gboolean cb_keyPressed (GtkWidget *, GdkEventKey * e, Application *app);
void cb_row_activated (GtkTreeView *treeview, GtkTreePath *path, GtkTreeViewColumn *arg2, Application * app);
void cb_playlist_edit_commit (GtkButton * button, Application * app);
void cb_openUrls (void *app, int argc, gchar **argv);
void cb_view_area_realized (GtkWidget *widget, Application * app);
void cb_view_area_expose (GtkWidget *widget, GdkEventExpose *event, Application * app);
void cb_view_area_configure (GtkWidget *widget, GdkEventConfigure *event, Application * app);
void cb_view_area_button_press (GtkWidget *widget, GdkEventButton *event, Application * app);
void cb_playlistMenuActivate (GtkButton * button, Application * app);
void cb_playlistCopy (GtkButton * button, Application * app);
void cb_playlistPaste (GtkButton * button, Application * app);
void cb_playlistPasteInNewGroup (GtkButton * button, Application * app);
void cb_playlistCut (GtkButton * button, Application * app);
void cb_playlist_prev (GtkButton * button, Application * app);
void cb_playlist_play (GtkButton * button, Application * app);
void cb_playlist_next (GtkButton * button, Application * app);
void cb_playlist_stop (GtkButton * button, Application * app);
void progressValueChanged(GtkWidget *w, Application * app);
gboolean cb_scheduledPaint (void * p);
gboolean cbViewAreaFullscreenMapped (GtkWidget *w, GdkEvent *, Application *a);
void cbViewAreaFullscreenUnmapped (GtkWidget *w, Application *a);
#ifdef __cplusplus
}
#endif

void updateTree (Application * app, short id);
void rowSelected (Application * app);
void openFile (Application * app, const gchar * path);
void insertLocation (Application * app, const KMPlayer::String & loc);
void openLocation (const char * filename, Application * app);
void setTitle (const char *, Application * app);
void openDocument(Application *app,KMPlayer::NodePtr doc,KMPlayer::NodePtr cur);
bool saveFile (Application * app, const gchar * path);
void newFile (Application * app);

#endif //_KMPLAYER_H_
