/* gcc -o appviewmenu appviewmenu.c `pkg-config hildon-lgpl --cflags`  `pkg-config hildon-libs --libs` `pkg-config hildon-fm --cflags --libs` `pkg-config dbus-1 --cflags --libs`
*/

#include <config.h>
#include <locale.h>
#include <errno.h>
#include <libintl.h>
#include <string.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <pango/pango-font.h>
#include <libgnomevfs/gnome-vfs-init.h>
extern "C" {
#include <gtkhtml/gtkhtml.h>
}
#define DBUS_API_SUBJECT_TO_CHANGE
#include <dbus/dbus.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#include <hildon-widgets/hildon-program.h>
#include <hildon-widgets/gtk-infoprint.h>
#include <hildon-widgets/hildon-window.h>
#include <hildon-widgets/hildon-seekbar.h>
#include <hildon-widgets/hildon-file-chooser-dialog.h>

#include "kmplayertypes.h"
#include "kmplayer_lists.h"
#include "kmplayer.h"
#define noname www_xpm
//#include "www.xpm"
#undef noname
#define MAEMO_NO_EXPORT __attribute__ ((visibility("hidden")))

extern "C" {
gint dbus_req_handler (const gchar *interface, const gchar *method,
        GArray *arguments, gpointer data, osso_rpc_t *retval);
void exit_event_handler (gboolean die_now, gpointer data);
}

KMPLAYER_NO_CDTOR_EXPORT
WaitNotify::WaitNotify(GtkWindow *w, const KMPlayer::String & txt) : window(w) {
    gtk_banner_show_animation (window, (const char *) txt);
}

KMPLAYER_NO_CDTOR_EXPORT WaitNotify::~WaitNotify () {
    gtk_banner_close (window);
}

MAEMO_NO_EXPORT
gchar *interface_file_chooser(Application * app, GtkFileChooserAction action) {
    GtkWidget *dialog;
    gchar *filename = NULL;
    dialog = hildon_file_chooser_dialog_new (GTK_WINDOW (app->window), action);
    gtk_widget_show_all (GTK_WIDGET (dialog));
    if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK) {
        filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
    }
    gtk_widget_destroy (dialog);
    return filename;
}

void setTitle (const char * title, Application * app) {
    gtk_window_set_title (GTK_WINDOW (app->window), title);
}

void insertLocation (Application * app, const KMPlayer::String & loc) {
    GtkTreeIter it, it2;
    GtkTreeModel * model = GTK_TREE_MODEL (gtk_combo_box_get_model (
                GTK_COMBO_BOX (app->location_bar)));
    if (gtk_tree_model_get_iter_first (model, &it2))
        gtk_list_store_insert_before (GTK_LIST_STORE (model), &it, &it2);
    else
        gtk_list_store_append (GTK_LIST_STORE (model), &it);
    gtk_list_store_set (GTK_LIST_STORE (model), &it, 0, (const char *) loc, -1);
    int count = 1;
    for (bool b = gtk_tree_model_iter_next (model, &it); b; ) {
        GValue value = { 0 , };
        gtk_tree_model_get_value (model, &it, 0, &value);
        KMPlayer::String val (g_value_get_string (&value));
        g_value_unset (&value);
        if (val.isEmpty ()) {
            b = gtk_list_store_remove (GTK_LIST_STORE (model), &it);
        } else {
            KMPlayer::debugLog() << "insert " << val << " " << (val == loc) << " " << count << KMPlayer::endl;
            if (val == loc || count > 6) {
                b = gtk_list_store_remove (GTK_LIST_STORE (model), &it);
            } else {
                b = gtk_tree_model_iter_next (model, &it);
                count++;
            }
        }
    }
    if (gtk_tree_model_get_iter_first (model, &it))
        gtk_combo_box_set_active_iter (GTK_COMBO_BOX (app->location_bar), &it);
    gtk_widget_grab_focus (app->playlist_view);
}

void openLocation (const char * filename, Application * app) {
    gtk_window_set_title (GTK_WINDOW (app->window), filename);
    openFile (app, filename);
    insertLocation (app, filename);
}

static void callback_file_open (GtkButton * button, Application * app) {
    gchar *filename = NULL;
    filename = interface_file_chooser(app, GTK_FILE_CHOOSER_ACTION_OPEN);
    if (filename)
        openLocation (filename, app);
}

static void callback_file_go (GtkButton * button, Application * app) {
    KMPlayer::String val (gtk_combo_box_get_active_text (
                GTK_COMBO_BOX (app->location_bar)));
    if (!val.isEmpty ()) {
        gtk_window_set_title (GTK_WINDOW (app->window), val);
        openFile (app, val);
        insertLocation (app, val);
    }
}

static void callback_file_save_as (GtkButton * button, Application * app) {
    gchar *filename = NULL;
    filename = interface_file_chooser(app, GTK_FILE_CHOOSER_ACTION_SAVE);
    if (filename) {
        gchar * info;
        if (saveFile (app, filename)) {
            info = g_strdup_printf ("Saved as %s", filename);
            gtk_window_set_title (GTK_WINDOW (app->window), filename);
            insertLocation (app, filename);
        } else
            info = g_strdup_printf ("Saving as %s failed (%s)", filename, strerror (errno));
        gtk_infoprint (GTK_WINDOW (app->window), info);
        g_free (info);
    }
}

static void callback_file_save (GtkButton * button, Application * app) {
    const char * fn = (const char *) app->url;
    if (fn && fn [0]) {
        gchar * info;
        if (saveFile (app, fn))
            info = g_strdup_printf ("Saved as %s", (const char *) app->url);
        else
            info = g_strdup_printf ("Saving as %s failed (%s)", (const char *) app->url, strerror (errno));
        gtk_infoprint (GTK_WINDOW (app->window), info);
        g_free (info);
    } else
        callback_file_save_as (0L, app);
}

static void callback_file_new (GtkButton * button, Application * app) {
    newFile (app);
    gtk_window_set_title (GTK_WINDOW (app->window), "");
//    gtk_combo_box_set_active (GTK_COMBO_BOX (app->location_bar), 0);
}

static bool locationbar_initialized;

static gboolean
locationbarGainFocus (GtkWidget *, GdkEventFocus *, Application * app) {
    int n = gtk_toolbar_get_n_items (GTK_TOOLBAR (app->main_toolbar));
    for (int i = 5; i < n; i++)
        gtk_widget_hide (GTK_WIDGET (gtk_toolbar_get_nth_item (GTK_TOOLBAR (app->main_toolbar), i)));
    app->setPlaying (app->playing);
    if (!locationbar_initialized) {
        KMPlayer::debugLog() << "locationbar_initializing" << KMPlayer::endl;
        const char * defs[6] = {
            "http://www.cwi.nl/SMIL/EUROshow/EUROshowB.smi",
            "http://homepages.cwi.nl/~media/SMIL/fiets/fiets.smil",
            "http://www.theworld.org/rss/tech.xml",
            "http://www.etherbeat.com/shoutcast/64.pls",
            "http://www.swissgroove.ch/listen.m3u",
            "file:///home/user/MyDocs/.videos/Discovery.avi"
        };
        int defpos = 0;
        locationbar_initialized = true;
        KMPlayer::Config * config = app->config();
        KMPlayer::String cfg_prefix (GCONF_KEY_LOCATION_URL);
        GtkTreeIter iterator;
        GtkListStore * model = GTK_LIST_STORE (gtk_combo_box_get_model (
                    GTK_COMBO_BOX (app->location_bar)));
        for (int i = 1; i < 7; i++) {
            gtk_list_store_append (model, &iterator);
            KMPlayer::String cfg = config->readEntry (cfg_prefix +
                    KMPlayer::String::number(i), "");
            if (cfg.isEmpty ())
                cfg = defs[defpos++];
            gtk_list_store_set (model, &iterator,
                0, (const char *) cfg, -1);
        }
    }
    gtk_editable_select_region (GTK_EDITABLE (GTK_BIN (app->location_bar)->child), 0, -1);
    //g_print ("callback_locationbar_gain_focus %d\n", n);
    return false;
}

static void save_locationbar (Application * app) {
    if (!locationbar_initialized)
        return;
    KMPlayer::Config * config = app->config();
    int idx = 1;
    KMPlayer::String cfg_pfx (GCONF_KEY_LOCATION_URL);
    GtkTreeIter iterator;
    GtkTreeModel * model = GTK_TREE_MODEL (gtk_combo_box_get_model (
                GTK_COMBO_BOX (app->location_bar)));
    for (bool b = gtk_tree_model_get_iter_first (model, &iterator);
            b;
            b = gtk_tree_model_iter_next (model, &iterator)) {
        GValue value = { 0 , };
        gtk_tree_model_get_value (model, &iterator, 0, &value);
        KMPlayer::String val (g_value_get_string (&value));
        g_value_unset (&value);
        KMPlayer::debugLog() << val << " " << idx << KMPlayer::endl;
        if (!val.isEmpty ())
            config->writeEntry (cfg_pfx + KMPlayer::String::number(idx++), val);
    }
}

static gboolean
locationbarLostFocus (GtkWidget *, GdkEventFocus *, Application * app) {
    int n = gtk_toolbar_get_n_items (GTK_TOOLBAR (app->main_toolbar));
    for (int i = 5; i < n; i++)
        gtk_widget_show (GTK_WIDGET (gtk_toolbar_get_nth_item (GTK_TOOLBAR (app->main_toolbar), i)));
    app->setPlaying (app->playing);
    gtk_editable_select_region (GTK_EDITABLE (GTK_BIN (app->location_bar)->child), 0, 0);
}

static bool first_time_exposed;

bool cb_window_expose (GtkWidget *widget, GdkEventExpose *event, Application * app) {
    if (!first_time_exposed) {
        first_time_exposed = true;
        gtk_paned_set_position (app->hsplit_view, HSPLIT);
        gtk_paned_set_position (app->vsplit_view, 200);
        gtk_widget_hide (GTK_WIDGET (app->tb_progress));
        gtk_widget_hide (GTK_WIDGET (app->tb_item_playlist_commit));
        //KMPlayer::debugLog() << "view_area "  << (int)GDK_DRAWABLE_XID (GDK_DRAWABLE (app->view_area->parent->window)) << " " << KMPlayer::endl;
    }
    return false;
}

void Application::setPlaying (bool p) {
    playing = p;
    if (playing) {
        gtk_widget_hide (GTK_WIDGET (tb_play));
        gtk_widget_show (GTK_WIDGET (tb_pause));
    } else {
        gtk_widget_hide (GTK_WIDGET (tb_pause));
        gtk_widget_show (GTK_WIDGET (tb_play));
    }
}

/* Create the menu items needed for the main view */
static void create_toolbar (Application * app) {
    /* Create needed variables */
    GtkToolItem *tb_open;
    GtkToolItem *tb_prev;
    GtkToolItem *tb_next;
    GtkToolItem *tb_stop;
    GtkToolItem *tb_close;
    GtkToolItem *tb_go;
    GtkToolItem *tb_separator;

    /* Create toolbar */
    app->main_toolbar = gtk_toolbar_new();

    /* Create toolbar button items */
    tb_open = gtk_tool_button_new_from_stock (GTK_STOCK_OPEN);
    tb_prev = gtk_tool_button_new_from_stock (GTK_STOCK_MEDIA_PREVIOUS);
    app->tb_play = gtk_tool_button_new_from_stock (GTK_STOCK_MEDIA_PLAY);
    app->tb_pause = gtk_tool_button_new_from_stock (GTK_STOCK_MEDIA_PAUSE);
    tb_next = gtk_tool_button_new_from_stock (GTK_STOCK_MEDIA_NEXT);
    tb_stop = gtk_tool_button_new_from_stock (GTK_STOCK_MEDIA_STOP);
    //tb_close = gtk_tool_button_new_from_stock (GTK_STOCK_CLOSE);
    tb_go = gtk_tool_button_new_from_stock (GTK_STOCK_APPLY);
    app->tb_item_playlist_commit = GTK_WIDGET (gtk_tool_button_new_from_stock (GTK_STOCK_CONVERT /*GTK_STOCK_REVERT_TO_SAVED*/));
//qgn_list_backup.png
    /* Create toolbar combobox item */
    app->tb_location = gtk_tool_item_new();
    app->tb_progress = gtk_tool_item_new();
    GtkListStore * model = gtk_list_store_new (1, G_TYPE_STRING);
    GtkTreeIter iterator;
    gtk_list_store_append (model, &iterator);
    gtk_list_store_set (model, &iterator, 0, "", -1);
    app->location_bar = gtk_combo_box_entry_new_with_model (
            GTK_TREE_MODEL (model), 0);
    app->progress_bar = hildon_seekbar_new ();
    //gtk_combo_box_set_focus_on_click (GTK_COMBO_BOX (app->location_bar), false);
    //G_OBJECT (gtk_bin_get_child (GTK_BIN (app->location_bar))), "focus-in-event", GTK_SIGNAL_FUNC (callback_locationbar_gain_focus), app);
    /* Make combobox to use all available toolbar space */
    gtk_tool_item_set_expand (app->tb_location, TRUE);
    gtk_tool_item_set_expand (app->tb_progress, TRUE);
    /* Add combobox inside toolitem */
    gtk_container_add (GTK_CONTAINER (app->tb_location), app->location_bar);
    gtk_container_add (GTK_CONTAINER (app->tb_progress), app->progress_bar);

    /* Create separator */
    tb_separator = gtk_separator_tool_item_new();

    /* Add all items to toolbar */
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), app->tb_location, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), app->tb_progress, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), tb_go, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), tb_open, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), GTK_TOOL_ITEM (app->tb_item_playlist_commit), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), tb_separator, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), tb_prev, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), app->tb_play, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), app->tb_pause, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), tb_next, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), tb_stop, -1);
    //gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), tb_close, -1);

    /* Add signal lister to "Close" button */
    //g_signal_connect(G_OBJECT(tb_close), "clicked",
    //    G_CALLBACK(callback_close), app);
    g_signal_connect (G_OBJECT (tb_go), "clicked",
        G_CALLBACK (callback_file_go), app);
    g_signal_connect (G_OBJECT (tb_open), "clicked",
        G_CALLBACK(callback_file_open), app);
    g_signal_connect (G_OBJECT (tb_prev), "clicked",
        G_CALLBACK (cb_playlist_prev), app);
    g_signal_connect (G_OBJECT (app->tb_play), "clicked",
        G_CALLBACK (cb_playlist_play), app);
    g_signal_connect (G_OBJECT (app->tb_pause), "clicked",
        G_CALLBACK (cb_playlist_play), app);
    g_signal_connect (G_OBJECT (tb_next), "clicked",
        G_CALLBACK (cb_playlist_next), app);
    g_signal_connect (G_OBJECT (tb_stop), "clicked",
        G_CALLBACK (cb_playlist_stop), app);
    g_signal_connect (G_OBJECT (app->tb_item_playlist_commit), "clicked",
        G_CALLBACK (cb_playlist_edit_commit), app);
    g_signal_connect (G_OBJECT (app->progress_bar), "value-changed",
        G_CALLBACK (progressValueChanged), app);

    /* Add toolbar to 'vbox' of HildonAppView */
    gtk_widget_show_all (GTK_WIDGET (app->main_toolbar));
    gtk_widget_hide (GTK_WIDGET (app->tb_progress));
    gtk_widget_hide (GTK_WIDGET (app->tb_pause));
    hildon_window_add_toolbar (app->window, GTK_TOOLBAR(app->main_toolbar));
    //hildon_program_set_common_toolbar (app->program, GTK_TOOLBAR(app->main_toolbar));
}

/* Create the menu items needed for the main view */
static void create_menu (Application * app) {
    /* Create needed variables */
    GtkMenu *main_menu;
    GtkWidget *item_new;
    GtkWidget *item_open;
    GtkWidget *item_save;
    GtkWidget *item_save_as;
    //GtkWidget *menu_others;
    GtkWidget *menu_playlist;
    GtkWidget *menu_players;
    //GtkWidget *item_check;
    GtkWidget *item_close;
    GtkWidget *item_separator;
    GtkWidget *item_playlist;
    GtkWidget *item_playlist_show;
    GtkWidget *item_players;

    /* Get the menu from view */
    main_menu = GTK_MENU (gtk_menu_new ());

    /* Create new submenu for "Others" */
    //menu_others = gtk_menu_new ();
    menu_playlist = gtk_menu_new ();
    menu_players = gtk_menu_new ();

    /* Create menu items */
    item_new = gtk_menu_item_new_with_label ("New");
    item_open = gtk_menu_item_new_with_label ("Open");
    item_save = gtk_menu_item_new_with_label ("Save");
    item_save_as = gtk_menu_item_new_with_label ("Save As");
    /* item_check = gtk_check_menu_item_new_with_label ("Check");*/
    item_playlist = gtk_menu_item_new_with_label ("Playlist");
    item_playlist_show = gtk_check_menu_item_new_with_label ("Show");
    app->menu_item_playlist_copy = gtk_menu_item_new_with_label("Copy");
    app->menu_item_playlist_paste = gtk_menu_item_new_with_label("Paste");
    app->menu_item_playlist_paste_in_group = gtk_menu_item_new_with_label ("Paste in new Group");
    app->menu_item_playlist_cut = gtk_menu_item_new_with_label("Cut");
    app->menu_item_playlist_showall = gtk_check_menu_item_new_with_label ("Show All");
    //gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (app->menu_item_playlist_showall), 1);
    app->menu_item_playlist_edit = gtk_check_menu_item_new_with_label ("Edit");
    //gtk_widget_set_sensitive (app->menu_item_playlist_edit, FALSE);
    item_close = gtk_menu_item_new_with_label ("Close");
    item_separator = gtk_separator_menu_item_new ();
    item_players = gtk_menu_item_new_with_label ("Player");
    app->menu_item_media_server = gtk_radio_menu_item_new_with_label (NULL, "Osso Media Server");
    app->menu_item_mplayer = gtk_radio_menu_item_new_with_label_from_widget(
            GTK_RADIO_MENU_ITEM (app->menu_item_media_server), "MPlayer");
    
    /* Add menu items to right menus */
    gtk_menu_append (main_menu, item_new);
    gtk_menu_append (main_menu, item_open);
    gtk_menu_append (main_menu, item_save);
    gtk_menu_append (main_menu, item_save_as);
    gtk_menu_append (main_menu, item_playlist);
    gtk_menu_append (main_menu, item_players);
    gtk_menu_append (menu_playlist, app->menu_item_playlist_copy);
    gtk_menu_append (menu_playlist, app->menu_item_playlist_paste);
    gtk_menu_append (menu_playlist, app->menu_item_playlist_paste_in_group);
    gtk_menu_append (menu_playlist, app->menu_item_playlist_cut);
    gtk_menu_append (menu_playlist, item_separator);
    //gtk_menu_append (menu_playlist, item_playlist_show);
    gtk_menu_append (menu_playlist, app->menu_item_playlist_showall);
    gtk_menu_append (menu_playlist, app->menu_item_playlist_edit);
    gtk_menu_append (menu_players, app->menu_item_media_server);
    gtk_menu_append (menu_players, app->menu_item_mplayer);
    gtk_menu_append( main_menu, item_close );

    /* Add others submenu to the "Others" item */
    //gtk_menu_item_set_submenu(
    //    GTK_MENU_ITEM(item_others), menu_others );
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (item_playlist), menu_playlist);
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (item_players), menu_players);

    /* Attach the callback functions to the activate signal */
    g_signal_connect (G_OBJECT (item_new), "activate",
        G_CALLBACK (callback_file_new), app);
    g_signal_connect( G_OBJECT( item_close ), "activate",
        GTK_SIGNAL_FUNC (cb_mainview_deleted), app);
    g_signal_connect (G_OBJECT (item_open), "activate",
        GTK_SIGNAL_FUNC (callback_file_open), app);
    g_signal_connect (G_OBJECT (item_save), "activate",
        GTK_SIGNAL_FUNC (callback_file_save), app);
    g_signal_connect (G_OBJECT (item_save_as), "activate",
        GTK_SIGNAL_FUNC (callback_file_save_as), app);
    g_signal_connect (G_OBJECT (item_playlist), "activate",
        GTK_SIGNAL_FUNC (cb_playlistMenuActivate), app);
    g_signal_connect (G_OBJECT (app->menu_item_playlist_copy), "activate",
        GTK_SIGNAL_FUNC (cb_playlistCopy), app);
    g_signal_connect (G_OBJECT (app->menu_item_playlist_paste), "activate",
        GTK_SIGNAL_FUNC (cb_playlistPaste), app);
    g_signal_connect (G_OBJECT (app->menu_item_playlist_paste_in_group), "activate",
        GTK_SIGNAL_FUNC (cb_playlistPasteInNewGroup), app);
    g_signal_connect (G_OBJECT (app->menu_item_playlist_cut), "activate",
        GTK_SIGNAL_FUNC (cb_playlistCut), app);
    g_signal_connect (G_OBJECT (item_playlist_show), "toggled",
        GTK_SIGNAL_FUNC (togglePlaylistShow), app);
    g_signal_connect (G_OBJECT (app->menu_item_playlist_showall), "toggled",
        GTK_SIGNAL_FUNC (togglePlaylistShowAll), app);
    g_signal_connect (G_OBJECT (app->menu_item_playlist_edit), "toggled",
        GTK_SIGNAL_FUNC (togglePlaylistEdit), app);
    g_signal_connect (G_OBJECT (app->menu_item_media_server), "toggled",
        GTK_SIGNAL_FUNC (toggleMediaServer), app);

    g_signal_connect (G_OBJECT (main_menu), "show",
        GTK_SIGNAL_FUNC (mainMenuShow), app);
    g_signal_connect (G_OBJECT (main_menu), "hide",
        GTK_SIGNAL_FUNC (mainMenuHide), app);
    //gtk_check_menu_item_set_active  (GtkCheckMenuItem *check_menu_item,
    //                                                   gboolean is_active);
    /* Make all menu widgets visible */
    gtk_widget_show_all (GTK_WIDGET (main_menu));
    hildon_program_set_common_menu (app->program, main_menu);
}

/* Callback for normal D-BUS messages */
gint dbus_req_handler( const gchar *interface, const gchar *method,
        GArray *arguments, gpointer data, osso_rpc_t *retval ) {
    Application *appdata = (Application *) data;
    KMPlayer::debugLog () << "dbus_req_handler " << interface << "." << method << KMPlayer::endl;
    if (!strcmp (method, "top_application"))
        gtk_window_present (GTK_WINDOW (appdata->window));
    else
        g_print("Unknown DBUS method: %s\n", method);
    retval->type = DBUS_TYPE_INVALID;
    return OSSO_OK;
}

static void setupViewWidget (GtkWidget * w, Application *app) {
    gtk_widget_add_events (w,
            GDK_EXPOSURE_MASK | GDK_VISIBILITY_NOTIFY_MASK |
            GDK_BUTTON_PRESS_MASK | GDK_KEY_PRESS_MASK |
            GDK_STRUCTURE_MASK);
    g_signal_connect (G_OBJECT (w), "realize",
        GTK_SIGNAL_FUNC (cb_view_area_realized), app);
    g_signal_connect (G_OBJECT (w), "expose-event",
        GTK_SIGNAL_FUNC (cb_view_area_expose), app);
    g_signal_connect (G_OBJECT (w), "button-press-event",
        GTK_SIGNAL_FUNC (cb_view_area_button_press), app);
    g_signal_connect (G_OBJECT (w), "configure-event",
            GTK_SIGNAL_FUNC (cb_view_area_configure), app);
}

#include <execinfo.h>
#include <signal.h>
#include <unistd.h>
void sig_abort(int) {
    void* trace[256];
    int n = backtrace(trace, 256);
    if (!n)
        return;
    backtrace_symbols_fd (trace, n, 2);
    exit(0);
}

/* Callback for exit D-BUS event */
//void exit_event_handler (gboolean die_now, gpointer data) {
//    Application * app = (Application *) data;
//    /* Do whatever application needs to do before exiting */
//    /*application_exit (data);*/
//    g_print("exit_event_handler\n");
//    g_main_loop_quit (NULL);
//}
//
//void osso_application_top_cb (const gchar *arguments, void * app) {
//    gtk_infoprint (GTK_WINDOW (((Application *) app)->app), "KMPlayer");
//}

/* Main application */    
int main (int argc, char* argv[]) {
    GError *error = 0L;
    GtkScrolledWindow * scroll_window;
    gnome_vfs_init ();  // calls g_thread_init(NULL);
    /* Create needed variables */
    signal(SIGABRT, sig_abort);
    signal(SIGINT, sig_abort);
    signal(SIGSEGV, sig_abort);
    KMPlayer::debugLog() << "new Application" << KMPlayer::endl;
    KMPlayer::StringPool::init();
    Application * app = new Application;

       /* Initialise the locale stuff */
    setlocale(LC_ALL, "");
    bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);

    /* Initialize the GTK. */
    //app->osso_context = osso_application_initialize ("com.nokia.kmplayer", "0.1", osso_application_top_cb, (gpointer) app);
    KMPlayer::debugLog() << "osso_initialize" << KMPlayer::endl;
    app->osso_context = osso_initialize ("kmplayer", "0.1", FALSE, NULL);
    if (!app->osso_context) {
        gtk_infoprint (GTK_WINDOW (app->window), "Failed to initialize");
        return 1;
    }
    //(DBusConnection *)osso_get_dbus_connection (app->osso_context);
    gtk_init (&argc, &argv);

    /* Create the hildon application and setup the title */
    app->program = HILDON_PROGRAM (hildon_program_new());

    /*app->osso_context = osso_initialize ("kmplayer", "0.1", FALSE, NULL);
    if (!app->osso_context) {
        gtk_infoprint (GTK_WINDOW (app->app), "Failed to initialize");
        return 1;
    }*/
    /* Create HildonAppView and set it to HildonApp */
    app->window = HILDON_WINDOW (hildon_window_new ());
    app->window_fullscreen = HILDON_WINDOW (hildon_window_new ());

    /* Add example label to appview */
    app->hsplit_view = GTK_PANED (gtk_hpaned_new ());
    scroll_window = GTK_SCROLLED_WINDOW (gtk_scrolled_window_new (0L, 0l));
    gtk_scrolled_window_set_policy (scroll_window,
            GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    app->playlist_view = createTreeView (app);
    GtkIconTheme *icon_theme = gtk_icon_theme_get_default();
    addTree (app, 0L, //gdk_pixbuf_new_from_xpm_data((const char**)www_xpm));
             gdk_pixbuf_scale_simple (
                     gtk_icon_theme_load_icon (icon_theme,
                         "qgn_grid_tasknavigator_web", 26,
                         (GtkIconLookupFlags)0, 0L),
             26, 26, GDK_INTERP_BILINEAR));
                //"qgn_toolb_browser_web", 26, (GtkIconLookupFlags)0, 0L));
    app->playlists = new KMPlayer::Playlist (app, 0L);
    app->playlists_tree_id = addTree (app, app->playlists,
            gtk_icon_theme_load_icon(icon_theme,
                "qgn_list_gene_playlist", 26, (GtkIconLookupFlags)0, 0L));
    app->recents = new KMPlayer::Recents (app);
    app->recents_tree_id = addTree (app, app->recents,
            gtk_icon_theme_load_icon(icon_theme,
                "qgn_list_gene_url_history", 26, (GtkIconLookupFlags)0, 0L));
    //GtkRcStyle * style = gtk_widget_get_modifier_style (app->playlist_view);
    //gtk_widget_modify_style (app->playlist_view, style);
    gtk_scrolled_window_add_with_viewport (scroll_window, app->playlist_view);
    app->vsplit_view = GTK_PANED (gtk_vpaned_new ());
    app->isplit_view = gtk_vbox_new (false, 0);
    gtk_paned_add1 (app->hsplit_view, GTK_WIDGET (scroll_window));
    gtk_paned_add2 (app->hsplit_view, GTK_WIDGET (app->vsplit_view));
    app->view_area = gtk_drawing_area_new ();
    app->view_area_fullscreen = gtk_drawing_area_new ();
    setupViewWidget (app->view_area, app);
    setupViewWidget (app->view_area_fullscreen, app);
    g_signal_connect (G_OBJECT (app->program), "notify::is-topmost",
        GTK_SIGNAL_FUNC (programTopMost), app);
    g_signal_connect (G_OBJECT (app->window), "destroy",
        GTK_SIGNAL_FUNC (cb_mainview_deleted), app);
    g_signal_connect (G_OBJECT (app->window_fullscreen), "map-event",
        GTK_SIGNAL_FUNC (cbViewAreaFullscreenMapped), app);
    g_signal_connect (G_OBJECT (app->window_fullscreen), "unmap",
        GTK_SIGNAL_FUNC (cbViewAreaFullscreenUnmapped), app);
    g_signal_connect (G_OBJECT (app->window), "expose-event",
        GTK_SIGNAL_FUNC (cb_window_expose), app);
    gtk_paned_add1 (app->vsplit_view, app->view_area);
    app->infopanel_view = gtk_text_view_new ();
    app->info_viewport = gtk_scrolled_window_new (0L, 0l);
    app->html_viewport = gtk_scrolled_window_new (0L, 0l);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (app->info_viewport),
            GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (app->html_viewport),
            GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_scrolled_window_add_with_viewport
        (GTK_SCROLLED_WINDOW (app->info_viewport), app->infopanel_view);
    //gtk_text_view_set_editable (GTK_TEXT_VIEW (app->infopanel_view), FALSE);
    g_object_set (G_OBJECT (app->infopanel_view),
            "cursor-visible", FALSE, "editable", FALSE,
            "autocap", FALSE, "wrap-mode", GTK_WRAP_WORD, 0L);
    PangoContext * pango_cxt = gtk_widget_get_pango_context (app->infopanel_view);
    PangoFontDescription * pfd = pango_font_description_from_string ("Sans 12");
    //g_print ("font %d\n", pango_font_description_get_size (pfd));
    //pango_font_description_set_size (pfd, 12);
    gtk_widget_modify_font (app->infopanel_view, pfd);
    app->html_infopanel_view = gtk_html_new ();
    gtk_container_add (GTK_CONTAINER (app->html_viewport),
            app->html_infopanel_view);
    gtk_container_add (GTK_CONTAINER (app->isplit_view), app->info_viewport);
    gtk_container_add (GTK_CONTAINER (app->isplit_view), app->html_viewport);
    g_object_ref (app->info_viewport);
    g_object_ref (app->html_viewport);
    gtk_paned_add2 (app->vsplit_view, GTK_WIDGET (app->isplit_view));
    /*g_object_set (G_OBJECT (split_view->child1),
            "resize", TRUE, "shrink", TRUE, 0L);
    g_object_set (G_OBJECT (split_view->child2),
            "resize", TRUE, "shrink", TRUE, 0L);*/
    gtk_container_add (GTK_CONTAINER (app->window), GTK_WIDGET (app->hsplit_view));
    gtk_container_add (GTK_CONTAINER (app->window_fullscreen), app->view_area_fullscreen);
    /* Create menu for view */
    create_menu (app);
    create_toolbar (app);
    hildon_program_add_window (app->program, app->window);
    hildon_program_add_window (app->program, app->window_fullscreen);

    g_signal_connect (G_OBJECT (gtk_bin_get_child (GTK_BIN(app->location_bar))),
            "focus-in-event", GTK_SIGNAL_FUNC (locationbarGainFocus), app);
    //g_signal_connect (G_OBJECT (app->location_bar), "focus-in-event", GTK_SIGNAL_FUNC (callback_locationbar_gain_focus), app);
    //g_signal_connect (G_OBJECT (GTK_BIN (app->location_bar)), "popup",
    //        GTK_SIGNAL_FUNC (callback_locationbar_popup), app);
    g_signal_connect (G_OBJECT (app->playlist_view), "focus-in-event",
            GTK_SIGNAL_FUNC (locationbarLostFocus), app);
    g_signal_connect (G_OBJECT (app->infopanel_view), "focus-in-event",
            GTK_SIGNAL_FUNC (locationbarLostFocus), app);
    g_signal_connect (G_OBJECT (app->html_infopanel_view), "focus-in-event",
            GTK_SIGNAL_FUNC (locationbarLostFocus), app);
    g_signal_connect (G_OBJECT (app->window), "key-press-event",
            GTK_SIGNAL_FUNC (cb_keyPressed), static_cast <void *> (app));
    g_signal_connect (G_OBJECT (app->window_fullscreen), "key-press-event",
            GTK_SIGNAL_FUNC (cb_keyPressed), static_cast <void *> (app));
    /* Begin the main application */
    gtk_paned_set_position (app->hsplit_view, HSPLIT);
    gtk_paned_set_position (app->vsplit_view, 200);
    gtk_widget_show_all (GTK_WIDGET (app->window));

    osso_mime_set_cb (app->osso_context, cb_openUrls, app);
    if (osso_rpc_set_default_cb_f (app->osso_context, dbus_req_handler, app) !=
            OSSO_OK) {
        gtk_infoprint (GTK_WINDOW (app->window), "Failed to set dbus_req_handler");
        //return 1;
    }
    KMPlayer::debugLog() << "app->initControl ()" << KMPlayer::endl;
    app->initControl ();
    g_object_ref (G_OBJECT (app->location_bar));

    if (argc > 1)
        openLocation (argv[1], app);
    KMPlayer::debugLog() << "gtk_main" << KMPlayer::endl;
    gtk_main ();
    save_locationbar (app);
    g_object_unref (G_OBJECT (app->location_bar));

    osso_mime_unset_cb (app->osso_context);
    osso_deinitialize (app->osso_context);
    delete app;
    gnome_vfs_shutdown ();
    KMPlayer::StringPool::reset();

    /* Exit */
    return 0;
}
