/*
 *
 * idea
 * home plugin
 *
 * @ver:	 1.0
 * @author:	 b0unc3
 * @license:	 GPL
 * 
 */

#include "libidea.h"
#include <glib/gprintf.h>
#include <glib.h>
#include <libosso.h>
#include <string.h>

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>

#include <libxml/xmlreader.h>


static gboolean effect(GtkWidget *widget, int n);
static gboolean normal(GtkWidget *widget, int n);
static gboolean theeventcatcher (GtkWidget *widget, GdkEventCrossing *event);

static GtkWidget *ibox[MAX_ICON];
static GtkWidget *button[MAX_ICON];
static GtkWidget *label[MAX_ICON];
static GtkWidget *main_box;
static GMainLoop *loop;
static GtkWidget *app_table[MAX_ICON];


static gboolean
openit(int value)
{
	osso_context_t *context;
	osso_return_t ret;
	gchar elem[4096];
	gchar default_dbus_dotpath[4096]; /* = "com.nokia.";*/
	gchar default_dbus_path[4096]; /* = "/com/nokia/";*/

	default_dbus_dotpath[0] = '\0';
	default_dbus_path[0] = '\0';

	gchar *file_name;
	FILE *file;
	char read_buffer[4096];

	file_name = g_new0(gchar, 4096);

	file_name = g_build_filename("/usr/share/applications/hildon",app[value],NULL);
	g_strlcat(file_name,".desktop",4096);
		file = fopen(file_name,"r");
		while (fgets(read_buffer,4096,file) != NULL ) {
			if ( strncmp(read_buffer,"X-Osso-Service", 14) == 0 ) {
				g_snprintf(elem,sizeof(elem),"%s",read_buffer + 15);
			}
		}
		fclose(file);
	char *c;
	c = strstr(elem,"\n");
	while(c!=NULL){
		c[0] = ' ';
		c = strstr(++c,"\n");
	}
	const gchar *ele;
	ele = g_strchomp(elem);
	if ( !found_it(".",ele) ) {
		/* default path => com.nokia.$elem */
		g_strlcat(default_dbus_path,"/com/nokia/\0",sizeof(default_dbus_path));
		g_strlcat(default_dbus_dotpath,"com.nokia.\0",sizeof(default_dbus_dotpath));
		g_strlcat(default_dbus_dotpath,ele,sizeof(default_dbus_dotpath));
		g_strlcat(default_dbus_path,ele,sizeof(default_dbus_path));
	} else {
		g_strlcat(default_dbus_dotpath,ele,sizeof(default_dbus_dotpath));
		char *b;
		b = strstr(ele,".");
		while (b!=NULL) {
			b[0] = '/';
			b = strstr(++b,".");
		}
		g_snprintf(default_dbus_path,sizeof(default_dbus_path),"/%s",ele);
	}

	FILE *f = fopen("/tmp/idealog","a+");
	fprintf(f,"openit at %d is %s and %s\n",value, default_dbus_path, default_dbus_dotpath);
	
	loop = g_main_loop_new(NULL,1);
	context = osso_initialize("start_prg","0.1",0,
				  g_main_loop_get_context(loop));

	if ( context == NULL ) {
		osso_deinitialize(context);
		fprintf(f,"context NULL|\n");
		fclose(f);
		return FALSE;
	}

	ret = osso_rpc_async_run(context,
				 default_dbus_dotpath, /*"com.nokia.xterm",*/
				 default_dbus_path, /*"/com/nokia/xterm",*/
				 default_dbus_dotpath, /*"com.nokia.xterm",*/
				 "start_app", NULL, NULL,
				 DBUS_TYPE_STRING,
				 "this is the start_app parameter",
				 DBUS_TYPE_INVALID);

	if ( ret != OSSO_OK ) {
		osso_deinitialize(context);
		fprintf(f,"not osso\n");
		fclose(f);
		return FALSE;
	}

	osso_deinitialize(context);
	fclose(f);
	
	return TRUE;
}

static gboolean 
normal(GtkWidget *widget, int n)
{
	GdkPixbuf *icon;
	GtkWidget *icon_image;
	GtkWidget *label;
	const gchar *path;

	int r = i_rows;
	int ntable = n / r;
	int pos;
	if ( n < r ) 
	{
		pos = n;
	} else {
		while ( n >= (r + i_rows) ) {
			r = r + i_rows;
		}
		pos = n - r;
	}
	
	gtk_widget_destroy(GTK_WIDGET(ibox[n]));
	gtk_widget_destroy(GTK_WIDGET(button[n]));
	button[n] = gtk_button_new();
	ibox[n] = gtk_vbox_new(TRUE,0);
	gtk_button_set_relief(GTK_BUTTON(button[n]),GTK_RELIEF_NONE);
	gtk_button_set_focus_on_click(GTK_BUTTON(button[n]),FALSE);
	
	if ( !found_it("/", nname[n]) ) {
		path = get_icon_path_from_name(nname[n],size);
		icon = gdk_pixbuf_new_from_file_at_size(path,size,size,NULL);
		icon_image = gtk_image_new_from_pixbuf(icon);
	} else {
		icon = gdk_pixbuf_new_from_file_at_size(nname[n],size,size,NULL);	
		icon_image = gtk_image_new_from_pixbuf(icon);
	}
	gtk_box_pack_start(GTK_BOX(ibox[n]), icon_image, FALSE, FALSE, 0);
	if ( visible == 1 ) {
		label = gtk_label_new(NULL);
		gchar tmp[4096];
		g_snprintf(tmp,4096,"<span weight=\"%s\" style=\"%s\" size=\"%s\" foreground='%s'>%s</span>",weight,style,fsize,color,iname[n]);
		gtk_label_set_markup(GTK_LABEL(label),tmp);
		gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_CENTER);
		gtk_box_pack_start(GTK_BOX(ibox[n]), label, FALSE, FALSE, 0);
	}
	gtk_container_add(GTK_CONTAINER(button[n]), ibox[n]);
	g_signal_connect(button[n],"pressed",G_CALLBACK(effect), (gpointer) n);
	g_signal_connect(button[n],"released",G_CALLBACK(normal), (gpointer) n);
	g_signal_connect(button[n], "enter", G_CALLBACK(theeventcatcher), NULL);
	
	gtk_table_attach_defaults(GTK_TABLE(app_table[ntable]), button[n], pos, pos + 1 ,0,1);
	gtk_table_attach_defaults(GTK_TABLE(main_box), app_table[ntable], 0,1, ntable,ntable + 1);
	
	gtk_widget_show_all(GTK_WIDGET(main_box));
		
	openit(n);
	
	return TRUE;
}
static gboolean
effect(GtkWidget *widget,int n)
{
	GdkPixbuf *icon;
	GtkWidget *icon_image;
	GtkWidget *label;
	const gchar *path;

	int r = i_rows;
	int ntable = n / r;
	int pos;
	if ( n < r ) 
	{
		pos = n;
	} else {
		while ( n >= (r + i_rows) ) {
			r = r + i_rows;
		}
		pos = n - r;
	}
	
	gtk_widget_destroy(GTK_WIDGET(ibox[n]));
	gtk_widget_destroy(GTK_WIDGET(button[n]));
	button[n] = gtk_button_new();
	ibox[n] = gtk_vbox_new(TRUE,0);
	gtk_button_set_relief(GTK_BUTTON(button[n]),GTK_RELIEF_NONE);
	gtk_button_set_focus_on_click(GTK_BUTTON(button[n]),FALSE);
	
	if ( !found_it("/",nname[n]) ) {
		path = get_icon_path_from_name(nname[n],size);
		icon = gdk_pixbuf_new_from_file_at_size(path,size/2,size/2,NULL);
		icon_image = gtk_image_new_from_pixbuf(icon);
	} else {
		icon = gdk_pixbuf_new_from_file_at_size(nname[n],size/2,size/2,NULL);	
		icon_image = gtk_image_new_from_pixbuf(icon);
	}
	gtk_box_pack_start(GTK_BOX(ibox[n]), icon_image, FALSE, FALSE, 0);
	if ( visible == 1 ) {
		label = gtk_label_new(NULL);
		gchar tmp[4096];
		g_snprintf(tmp,4096,"<span weight=\"%s\" style=\"%s\" size=\"%s\" foreground='%s'>%s</span>",weight,style,fsize,color,iname[n]);	
		gtk_label_set_markup(GTK_LABEL(label),tmp);
		gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_CENTER);
		gtk_box_pack_start(GTK_BOX(ibox[n]), label, FALSE, FALSE, 0);
	}
	gtk_container_add(GTK_CONTAINER(button[n]), ibox[n]);
	g_signal_connect(button[n],"pressed",G_CALLBACK(effect), (gpointer) n);
	g_signal_connect(button[n],"released",G_CALLBACK(normal), (gpointer) n);
	g_signal_connect(button[n], "enter", G_CALLBACK(theeventcatcher), NULL);
	
	gtk_table_attach_defaults(GTK_TABLE(app_table[ntable]), button[n], pos, pos + 1 ,0,1);
	gtk_table_attach_defaults(GTK_TABLE(main_box), app_table[ntable], 0,1, ntable,ntable + 1);

	gtk_widget_show_all(GTK_WIDGET(main_box));
	return TRUE;
}


static gboolean 
theeventcatcher (GtkWidget *widget, GdkEventCrossing *event)
{
	GtkButton *button;
	GtkWidget *event_widget;

	button = GTK_BUTTON (widget);
	event_widget = gtk_get_event_widget ((GdkEvent*) event);
	button->in_button = FALSE;
	gtk_button_leave (button);
	return FALSE;
}

GtkWidget *
idea_new ()
{
	GdkPixbuf *icon;
	GtkWidget *icon_image;
	const gchar *path;
	int i;

	parseDoc("/home/user/.idea/idea.xml");

	gint tot_rows = ticon / i_rows;
	if ( (ticon%i_rows) != 0 ) tot_rows++;	/*rows,columns*/
	main_box = gtk_table_new(tot_rows,1,TRUE); /* gtk_hbox_new(FALSE,5);*/
	/* how manu cols ?? */
	gint cnt;
	for ( cnt=0; cnt < tot_rows; cnt++ ) {
		app_table[cnt] = gtk_table_new(1,i_rows,FALSE);
		gtk_table_set_homogeneous(GTK_TABLE(app_table[cnt]), FALSE);
		gtk_table_set_col_spacings(GTK_TABLE(app_table[cnt]),cell_spacing);
		gtk_table_set_row_spacings(GTK_TABLE(app_table[cnt]),row_spacing);
	}
	gtk_table_set_homogeneous(GTK_TABLE(main_box),TRUE);
	gtk_table_set_row_spacings(GTK_TABLE(main_box),row_spacing);
	int y=0;
	int table_counter = 0;
	int checkpoint = i_rows;
	int stable_pos = 0;
	for(i=0; i < tot_rows ; i++) {
		for(;y<checkpoint;y++) {
			if ( nname[y] != NULL ) {
			button[y] = gtk_button_new();
			gtk_button_set_relief(GTK_BUTTON(button[y]),GTK_RELIEF_NONE);
			gtk_button_set_focus_on_click(GTK_BUTTON(button[y]),FALSE);
			ibox[y] = gtk_vbox_new(TRUE,2);
			if ( !found_it("/",nname[y]) ) {
				path = get_icon_path_from_name(nname[y],size);
				icon = gdk_pixbuf_new_from_file_at_size(path,size,size,NULL);
				icon_image = gtk_image_new_from_pixbuf(icon);
			} else {
				icon = gdk_pixbuf_new_from_file_at_size(nname[y],size,size,NULL);
				icon_image = gtk_image_new_from_pixbuf(icon);
			}
			gtk_box_pack_start(GTK_BOX(ibox[y]), icon_image, FALSE, FALSE, 0);
			if ( visible == 1 ) {
				label[y] = gtk_label_new(NULL);
				gchar tmp[4096];
				g_snprintf(tmp,4096,"<span weight=\"%s\" style=\"%s\" size=\"%s\" foreground='%s'>%s</span>",weight,style,fsize,color,iname[y]);
				gtk_label_set_markup(GTK_LABEL(label[y]),tmp); //m[i]);*/
				gtk_label_set_justify(GTK_LABEL(label[y]),GTK_JUSTIFY_CENTER);
				gtk_box_pack_start(GTK_BOX(ibox[y]), label[y], FALSE, FALSE, 0);
			}
			gtk_container_add(GTK_CONTAINER(button[y]), ibox[y]);
			g_signal_connect(button[y],"pressed",G_CALLBACK(effect), (gpointer) y);
			g_signal_connect(button[y], "enter", G_CALLBACK(theeventcatcher), NULL);
			gtk_button_enter(GTK_BUTTON(button[y]));
			
			gtk_table_attach_defaults(GTK_TABLE(app_table[table_counter]), button[y], stable_pos, stable_pos + 1, 0, 1 );
			stable_pos++;
			}
		}
		gtk_table_attach_defaults(GTK_TABLE(main_box), app_table[table_counter], 0,1,i,i+1);
		table_counter++;
		checkpoint=checkpoint + i_rows;
		stable_pos = 0;
	}
	gtk_widget_show_all (main_box);
      	
	return main_box;
}
