// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDON_LIBSMM_GRID_ITEM_H
#define _HILDON_LIBSMM_GRID_ITEM_H


#include <glibmm.h>

/* $Id: date-editor.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* grid-item.h
 *
 * Copyright 2005-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/container.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonGridItem HildonGridItem;
typedef struct _HildonGridItemClass HildonGridItemClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class GridItem_Class; } // namespace Hildon
namespace Hildon
{

/** Hildon::GridItem is used to create grid items used by Hildon::Grid.
 * The grid item consists of an icon and a label. Based on the displaying
 * mode employed by Hildon::Grid, the label is justified to the right or
 * the bottom.
 *
 * @ingroup HildonWidgets
 */

class GridItem : public Gtk::Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef GridItem CppObjectType;
  typedef GridItem_Class CppClassType;
  typedef HildonGridItem BaseObjectType;
  typedef HildonGridItemClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~GridItem();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class GridItem_Class;
  static CppClassType griditem_class_;

  // noncopyable
  GridItem(const GridItem&);
  GridItem& operator=(const GridItem&);

protected:
  explicit GridItem(const Glib::ConstructParams& construct_params);
  explicit GridItem(HildonGridItem* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonGridItem*       gobj()       { return reinterpret_cast<HildonGridItem*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonGridItem* gobj() const { return reinterpret_cast<HildonGridItem*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  explicit GridItem(const Glib::ustring& icon_basename); 
  explicit GridItem(const Glib::ustring& icon_basename, const Glib::ustring& label); 

  
  /** Sets item emblem type.
   * @param emblem_basename Emblem's basename.
   */
  void set_emblem_type(const Glib::ustring& emblem_basename);
  
  /** 
   * @return Emblem's basename.
   */
  Glib::ustring get_emblem_type() const;

  
  void set_label(const Glib::ustring& label);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The emblem's basename.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly<Glib::ustring> property_emblem_type() ;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The icon's basename.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly<Glib::ustring> property_icon_basename() ;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::GridItem
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::GridItem* wrap(HildonGridItem* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDON_LIBSMM_GRID_ITEM_H */

