// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDON_LIBSMM_COLOR_SELECTOR_H
#define _HILDON_LIBSMM_COLOR_SELECTOR_H


#include <glibmm.h>

/* $Id: add-home-dialog.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* add-home-dialog.h
 *
 * Copyright 2005-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/dialog.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonColorSelector HildonColorSelector;
typedef struct _HildonColorSelectorClass HildonColorSelectorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class ColorSelector_Class; } // namespace Hildon
namespace Hildon
{

/** The Hildon::ColorSelector is a dialog for selecting colors. 
 * It allows selection of a color from a standard 16-color palette or a palette of 8 user-customizable colors.
 * The user-customizable colors can be modified through Hildon::ColorPopup.
 *
 * It is very similar to the Gtk::ColorSelectionDialog, but more suitable for embedded devices.
 *
 * There are two different ways to use the Hildon::ColorSelector:
 * - By using the Hildon::ColorButton, which shows the selected color in the button area and launches the Hildon::ColorSelector dialog automatically when clicked.
 * - By creating the dialog manually
 *
 * @ingroup HildonDialogs
 */

class ColorSelector : public Gtk::Dialog
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ColorSelector CppObjectType;
  typedef ColorSelector_Class CppClassType;
  typedef HildonColorSelector BaseObjectType;
  typedef HildonColorSelectorClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~ColorSelector();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class ColorSelector_Class;
  static CppClassType colorselector_class_;

  // noncopyable
  ColorSelector(const ColorSelector&);
  ColorSelector& operator=(const ColorSelector&);

protected:
  explicit ColorSelector(const Glib::ConstructParams& construct_params);
  explicit ColorSelector(HildonColorSelector* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonColorSelector*       gobj()       { return reinterpret_cast<HildonColorSelector*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonColorSelector* gobj() const { return reinterpret_cast<HildonColorSelector*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

  
public:
  ColorSelector();
  ColorSelector(Gtk::Window& parent);
  

  /** 
   * @return The currently selected Gdk::Color.
   */
  Gdk::Color get_color() const;

  
  /** Selects the color specified. Does nothing if the color does not 
   * exist among the standard colors.
   * @param color Gdk::Color to set.
   */
  void set_color(const Gdk::Color& color);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The selected color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gdk::Color> property_color() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The selected color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gdk::Color> property_color() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::ColorSelector
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::ColorSelector* wrap(HildonColorSelector* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDON_LIBSMM_COLOR_SELECTOR_H */

