// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDON_LIBSMM_TIME_EDITOR_H
#define _HILDON_LIBSMM_TIME_EDITOR_H


#include <glibmm.h>

/* $Id: number-editor.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* number-editor.h
 *
 * Copyright 2005-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/container.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonTimeEditor HildonTimeEditor;
typedef struct _HildonTimeEditorClass HildonTimeEditorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class TimeEditor_Class; } // namespace Hildon
namespace Hildon
{

//TODO: The C enum values are likely to change. Check bug #https://maemo.org/bugzilla/show_bug.cgi?id=814
//and update the *enums.defs if necessary. murrayc
/** @addtogroup hildon_libsmmEnums Enums and Flags */

/**
 * @ingroup hildon_libsmmEnums
 */
enum TimeEditorErrorType
{
  TIME_NO_TIME_ERROR = -1,
  TIME_MAX_HOURS,
  TIME_MAX_MINS,
  TIME_MAX_SECS,
  TIME_MIN_HOURS,
  TIME_MIN_MINS,
  TIME_MIN_SECS,
  TIME_EMPTY_HOURS,
  TIME_EMPTY_MINS,
  TIME_EMPTY_SECS,
  TIME_MIN_DUR,
  TIME_MAX_DUR,
  TIME_INVALID_TIME,
  TIME_INVALID_CHAR
};


/** Hildon::TimeEditor is used to edit time or duration. Time mode is
 * restricted to the normal 24 hour cycle, but Duration mode can select any
 * amount of time up to 99 hours.  It consists of entries for hours,
 * minutes and seconds, and a pm/am indicator as well as a button which
 * pops up a Hildon::TimePicker dialog.
 *
 * @ingroup HildonWidgets
 */

class TimeEditor : public Gtk::Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TimeEditor CppObjectType;
  typedef TimeEditor_Class CppClassType;
  typedef HildonTimeEditor BaseObjectType;
  typedef HildonTimeEditorClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~TimeEditor();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class TimeEditor_Class;
  static CppClassType timeeditor_class_;

  // noncopyable
  TimeEditor(const TimeEditor&);
  TimeEditor& operator=(const TimeEditor&);

protected:
  explicit TimeEditor(const Glib::ConstructParams& construct_params);
  explicit TimeEditor(HildonTimeEditor* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonTimeEditor*       gobj()       { return reinterpret_cast<HildonTimeEditor*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonTimeEditor* gobj() const { return reinterpret_cast<HildonTimeEditor*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual bool on_time_error(TimeEditorErrorType type);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  TimeEditor();
  

  /** This function sets the time on an existing time editor. If the
   * time specified by the arguments is invalid, it's fixed.
   * The time is assumed to be in 24h format.
   * @param hours Hours.
   * @param minutes Minutes.
   * @param seconds Seconds.
   */
  void set_time(guint hours, guint minutes, guint seconds);
  
  /** Gets the time of the Hildon::TimeEditor widget. The time returned is
   * always in 24h format.
   * @param hours Hours.
   * @param minutes Minutes.
   * @param seconds Seconds.
   */
  void get_time(guint& hours, guint& minutes, guint& seconds) const;


  /** Sets the duration editor time range of the Hildon::TimeEditor widget.
   * @param min_seconds Minimum allowed time in seconds.
   * @param max_seconds Maximum allowed time in seconds.
   */
  void set_duration_range(guint min_seconds, guint max_seconds);
  
  /** Gets the duration editor time range of the Hildon::TimeEditor widget.
   * @param min_seconds Pointer to <tt>unsigned int</tt>.
   * @param max_seconds Pointer to <tt>unsigned int</tt>.
   */
  void get_duration_range(guint& min_seconds, guint& max_seconds) const;

  
  /** Sets the current duration in seconds. This means seconds from
   * midnight, if not in duration mode. In case of any errors, it tries
   * to fix it.
   * @param ticks The duration to set, in seconds.
   */
  void set_ticks(guint ticks);
  
  /** This function returns the current duration, in seconds.
   * This means seconds from midnight, if not in duration mode.
   * @return Current duration in seconds.
   */
  guint get_ticks() const;

  
  /** This function shows or hides the seconds field.
   * @param show_seconds Enable or disable showing of seconds.
   */
  void set_show_seconds(bool show_seconds = true);
  
  /** This function returns a boolean indicating the visibility of
   * seconds in the Hildon::TimeEditor
   * @return <tt>true</tt> if the seconds are visible.
   */
  bool get_show_seconds() const;

  
  /** This function sets the duration editor mode in which the maximum hours
   * is 99.
   * @param duration_mode Enable or disable duration editor mode.
   */
  void set_duration_mode(bool duration_mode = true);
  
  /** This function returns a boolean indicating whether the Hildon::TimeEditor
   * is in the duration mode.
   * @return <tt>true</tt> if the Hildon::TimeEditor is in duration mode.
   */
  bool get_duration_mode() const;

  
  /** Sets the minimum allowed duration for the duration mode.
   * @note Has no effect in time mode
   * @param duration_min Mimimum allowed duration.
   */
  void set_duration_min(guint duration_min);
  
  /** This function returns the smallest duration the Hildon::TimeEditor
   * allows in the duration mode.
   * @return Minimum allowed duration in seconds.
   */
  guint get_duration_min() const;

  
  /** Sets the maximum allowed duration in seconds for the duration mode.
   * @note Has no effect in time mode
   * @param duration_max Maximum allowed duration in seconds.
   */
  void set_duration_max(guint duration_max);
  
  /** This function returns the longest duration the Hildon::TimeEditor
   * allows in the duration mode.
   * @return Maximum allowed duration in seconds.
   */
  guint get_duration_max() const;

  
  /** This function shows or hides the hours field.
   * 
   * Since: 0.12.4
   * @param enable Enable or disable showing of hours.
   */
  void set_show_hours(bool enable = true);
  
  /** This function returns a boolean indicating the visibility of
   * hours in the @a HildonTimeEditor 
   * @return <tt>true</tt> if hours are visible. 
   * 
   * Since: 0.12.4-1.
   */
  bool get_show_hours() const;

  
/**
   * @par Prototype:
   * <tt>bool %time_error(TimeEditorErrorType type)</tt>
   */

  Glib::SignalProxy1< bool,TimeEditorErrorType > signal_time_error();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Current value of duration.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_ticks() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Current value of duration.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_ticks() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Controls whether the seconds are shown in the editor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_seconds() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Controls whether the seconds are shown in the editor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_seconds() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Controls whether the hours field is shown in the editor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_hours() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Controls whether the hours field is shown in the editor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_hours() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Controls whether the TimeEditor is in duration mode.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_duration_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Controls whether the TimeEditor is in duration mode.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_duration_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Smallest possible duration value.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_duration_min() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Smallest possible duration value.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_duration_min() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Largest possible duration value.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_duration_max() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Largest possible duration value.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_duration_max() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::TimeEditor
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::TimeEditor* wrap(HildonTimeEditor* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDON_LIBSMM_TIME_EDITOR_H */

