#ifndef _HILDON_LIBSMM_SCROLL_AREA_H
#define _HILDON_LIBSMM_SCROLL_AREA_H

/* scroll-area.h
 *
 * Copyright 2006 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/scrolledwindow.h>

namespace Hildon
{

/** @ingroup HildonHelpers
 */
namespace ScrollArea
{

/** This is a helper function to create hildon-specific scrolling methods.
 *
 * A common situation where the scroll area should be used
 * might be the following:  A view containing a Gtk::TreeView-based widget,
 * (or any similar widget which has built-in Gtk::ScrolledWindow support)
 * and e.g. two buttons.  Normally, a Gtk::ScrolledWindow can not handle
 * the situation so that the Gtk::TreeView built-in support
 * would work.  The scroll area is connecting this built-in system to
 * the scrolled window and also noticing the buttons. To use, one should
 * create a box into which the buttons and the scroll area should be packed.
 * The scroll area then contains the problematic widget, such as the Gtk::TreeView.
 * Then the box should be placed in the Gtk::ScrolledWindow.
 * The function currently assumes that the newly created scroll area
 * hierarchy is not modified in anyway.  If it is, it may lead to
 * unwanted problems.  It also assumes that the child widget will be packed
 * into to the scrolled window.
 *
 * @param sw A Gtk::ScrolledWindow
 * @param child A child widget to be placed inside the the scrolled window
 *
 * @result a Gtk::Fixed
 */
Gtk::Widget* create(Gtk::ScrolledWindow& sw, Gtk::Widget& child);

//This does actually return a Gtk::Fixed always, but let's not force people to include that header. murrayc.

} //namespace ScrollArea

} // namespace Hildon

#endif //_HILDON_LIBSMM_SCROLL_AREA_H


