/* scroll-area.cc
 *
 * Copyright 2006 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "scroll-area.h"
#include <hildon-widgets/hildon-scroll-area.h>

namespace Hildon
{

namespace ScrollArea
{

Gtk::Widget* create(Gtk::ScrolledWindow& sw, Gtk::Widget& child)
{
  return Glib::wrap( hildon_scroll_area_new(GTK_WIDGET(sw.gobj()), child.gobj()) );
}

} //namespace ScrollArea

} // namespace Hildon

