// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDON_LIBSMM_GRID_H
#define _HILDON_LIBSMM_GRID_H


#include <glibmm.h>

/* $Id: date-editor.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* grid.h
 *
 * Copyright 2005-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/container.h>
#include <hildon-libsmm/grid-item.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonGrid HildonGrid;
typedef struct _HildonGridClass HildonGridClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class Grid_Class; } // namespace Hildon
namespace Hildon
{

/** Hildon::Grid is used wherever a number of single tap activatable items need to be presented,
 * such as in the Control Panel.
 *
 * Hildon::Grid is a set of application-defineable items that are presented in a
 * table. There are two modes for the form of the table; large icon mode
 * and small icon mode.
 *
 * In large icon mode, the Grid View items are presented with large
 * icons and labels underneath. In small icon mode, the items are
 * presented with small icons and label on the right side of the
 * icons.
 *
 * The label has a solid background as wide as the maximum text width.
 * This allows the text to have focus as well as be legible when
 * displayed upon a black or dark background image. Long names are
 * truncated, with an ellipsis ("...") appended.
 *
 * @ingroup HildonWidgets
 */

class Grid : public Gtk::Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Grid CppObjectType;
  typedef Grid_Class CppClassType;
  typedef HildonGrid BaseObjectType;
  typedef HildonGridClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Grid();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Grid_Class;
  static CppClassType grid_class_;

  // noncopyable
  Grid(const Grid&);
  Grid& operator=(const Grid&);

protected:
  explicit Grid(const Glib::ConstructParams& construct_params);
  explicit Grid(HildonGrid* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonGrid*       gobj()       { return reinterpret_cast<HildonGrid*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonGrid* gobj() const { return reinterpret_cast<HildonGrid*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_popup_context_menu(GridItem* item);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  Grid();
  ;

  
  /** Sets style. Setting style sets widget size, spacing, label position,
   * number of columns, and icon size.
   * @param style_name Style name.
   */
  void set_style(const Glib::ustring& style_name);
  
  /** Returns the name of style currently used in HildonGrid.
   * @return Style name.
   */
  Glib::ustring get_style() const;

  
  /** Sets view (scrollbar) to specified position.
   * @param scrollbar_pos New position (in pixels).
   */
  void set_scrollbar_pos(int scrollbar_pos);
  
  /** 
   * @return Position of scrollbar (in pixels).
   */
  int get_scrollbar_pos() const;

  
  /** Sends a signal to indicate that this HildonGridItem is activated.
   * @param item Hildon::GridItem.
   */
  void activate_child(GridItem& item);

 
  /* Not wrapped, because it is a G_SIGNAL_ACTION signal: _WRAP_SIGNAL(void activate_child(GridItem* item), "activate_child") */
  
  
/**
   * @par Prototype:
   * <tt>void %popup_context_menu(GridItem* item)</tt>
   */

  Glib::SignalProxy1< void,GridItem* > signal_popup_context_menu();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Label to show when grid has no items.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_empty_label() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Label to show when grid has no items.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_empty_label() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** View (scrollbar) position.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_scrollbar_position() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** View (scrollbar) position.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_scrollbar_position() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::Grid
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::Grid* wrap(HildonGrid* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDON_LIBSMM_GRID_H */

