// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDON_LIBSMM_FIND_TOOLBAR_H
#define _HILDON_LIBSMM_FIND_TOOLBAR_H


#include <glibmm.h>

/* $Id: note.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* note.h
 *
 * Copyright 2005-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/toolbar.h>
#include <gtkmm/liststore.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonFindToolbar HildonFindToolbar;
typedef struct _HildonFindToolbarClass HildonFindToolbarClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class FindToolbar_Class; } // namespace Hildon
namespace Hildon
{

/** A Hildon::FindToolbar is a special toolbar for the Find feature. 
 * Maemo applications can have several toolbars, which are then attached on top of each other. 
 * The Find toolbar is generally placed on the top of the main toolbar, as in the example covered in this section.
 *
 * This is a predefined toolbar for text searching purposes. 
 * It contains a Gtk::ListStore which has the text items that the user has 
 * searched. The programmer may get the Gtk::ListStore via the "list" property, 
 * in order to use the information.
 *
 * Note that once the search button is pressed, the string in the ComboBoxEntry will 
 * be automatically added to the existing model, unless it is empty.
 *
 * The Find toolbar should be opened and hidden when appropriate.
 *
 * @ingroup HildonWidgets
 */

class FindToolbar : public Gtk::Toolbar
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef FindToolbar CppObjectType;
  typedef FindToolbar_Class CppClassType;
  typedef HildonFindToolbar BaseObjectType;
  typedef HildonFindToolbarClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~FindToolbar();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class FindToolbar_Class;
  static CppClassType findtoolbar_class_;

  // noncopyable
  FindToolbar(const FindToolbar&);
  FindToolbar& operator=(const FindToolbar&);

protected:
  explicit FindToolbar(const Glib::ConstructParams& construct_params);
  explicit FindToolbar(HildonFindToolbar* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonFindToolbar*       gobj()       { return reinterpret_cast<HildonFindToolbar*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonFindToolbar* gobj() const { return reinterpret_cast<HildonFindToolbar*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_search();
  virtual void on_close();
  virtual void on_invalid_input();
  virtual bool on_history_append();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  FindToolbar();
  explicit FindToolbar(const Glib::ustring& label);
  explicit FindToolbar(const Glib::ustring& label, const Glib::RefPtr<Gtk::ListStore>& list, int column);
 
  
  /** 
   * @param get_focus If user passes <tt>true</tt> to this value, then the text in
   * the entry will not only get highlighted, but also get focused.
   */
  void highlight_entry(bool get_focus = true);

  
/**
   * @par Prototype:
   * <tt>void %search()</tt>
   */

  Glib::SignalProxy0< void > signal_search();

  
/**
   * @par Prototype:
   * <tt>void %close()</tt>
   */

  Glib::SignalProxy0< void > signal_close();

  
/**
   * @par Prototype:
   * <tt>void %invalid_input()</tt>
   */

  Glib::SignalProxy0< void > signal_invalid_input();

  
/**
   * @par Prototype:
   * <tt>bool %history_append()</tt>
   */

  Glib::SignalProxy0< bool > signal_history_append();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Displayed name for find-toolbar.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_label() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Displayed name for find-toolbar.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_label() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Search string.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_prefix() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Search string.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_prefix() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** GtkListStore model where history list is kept.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gtk::ListStore> > property_list() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** GtkListStore model where history list is kept.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gtk::ListStore> > property_list() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Column number in GtkListStore where history list strings are kept.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_column() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Column number in GtkListStore where history list strings are kept.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_column() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum number of characters in search string.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_max_characters() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum number of characters in search string.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_max_characters() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum number of history items in search combobox.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_history_limit() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum number of history items in search combobox.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_history_limit() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::FindToolbar
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::FindToolbar* wrap(HildonFindToolbar* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDON_LIBSMM_FIND_TOOLBAR_H */

