// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDON_LIBSMM_CALENDAR_POPUP_H
#define _HILDON_LIBSMM_CALENDAR_POPUP_H


#include <glibmm.h>

/* $Id: calendar-popup.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* calendar-popup.h
 *
 * Copyright 2005-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/dialog.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonCalendarPopup HildonCalendarPopup;
typedef struct _HildonCalendarPopupClass HildonCalendarPopupClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class CalendarPopup_Class; } // namespace Hildon
namespace Hildon
{

/** CalendarPopup allows a date to be chosen from a popup calendar dialog, 
 * which contains a Gtk::Calendar widget and arrow buttons for changing the 
 * month and year. The pop-up is cancelled by pressing 
 * the ESC key. If an entered date is invalid, an information message will be shown.
 * 
 * See also Hildon::DateEditor and Hildon::TimeEditor. 
 *
 * @ingroup HildonDialogs
 */

class CalendarPopup : public Gtk::Dialog
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef CalendarPopup CppObjectType;
  typedef CalendarPopup_Class CppClassType;
  typedef HildonCalendarPopup BaseObjectType;
  typedef HildonCalendarPopupClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~CalendarPopup();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class CalendarPopup_Class;
  static CppClassType calendarpopup_class_;

  // noncopyable
  CalendarPopup(const CalendarPopup&);
  CalendarPopup& operator=(const CalendarPopup&);

protected:
  explicit CalendarPopup(const Glib::ConstructParams& construct_params);
  explicit CalendarPopup(HildonCalendarPopup* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonCalendarPopup*       gobj()       { return reinterpret_cast<HildonCalendarPopup*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonCalendarPopup* gobj() const { return reinterpret_cast<HildonCalendarPopup*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

  
public:
  CalendarPopup(guint year, guint month, guint day);
  CalendarPopup(Gtk::Window& parent, guint year, guint month, guint day);
  

  /** activates a new date on the calendar popup.
   * @param year Year.
   * @param month Month.
   * @param day Day.
   */
  void set_date(guint year, guint month, guint day);
  
  /** Gets the currently selected year, month, and day.
   * @param year Year.
   * @param month Month.
   * @param day Day.
   */
  void get_date(guint& year, guint& month, guint& day) const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Minimum valid year.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly<guint> property_min_year() ;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum valid year.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly<guint> property_max_year() ;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** currently selected day.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_day() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** currently selected day.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_day() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** currently selected month.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_month() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** currently selected month.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_month() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** the currently selected year.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_year() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** the currently selected year.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_year() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::CalendarPopup
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::CalendarPopup* wrap(HildonCalendarPopup* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDON_LIBSMM_CALENDAR_POPUP_H */

