// -*- c++ -*-
//------------------------------------------------------------------------------
//                              CardRef.h
//------------------------------------------------------------------------------
// $Id
//
// Date: Apr 24 2004
//------------------------------------------------------------------------------
#ifndef CARD_REF_H
#define CARD_REF_H

#include <assa/TimeVal.h>
using ASSA::TimeVal;

#include "Granule-main.h"
#include "Card.h"
#include "Deck.h"
#include "VCard.h"
#include "GrappConf.h"

class CardRef : public VCard 
{
public:
	CardRef (VCard& card_, Deck& deck_);

	virtual void set_question (const ustring& q_) { m_card.set_question (q_); }
	virtual void set_answer   (const ustring& a_) { m_card.set_answer   (a_); }
	virtual void set_example  (const ustring& e_) { m_card.set_example  (e_); }
	virtual void set_alt_spelling (SideSelection side_, const ustring& a_);

	virtual ustring get_question () const { return m_card.get_question (); }
	virtual ustring get_answer   () const { return m_card.get_answer   (); }
	virtual ustring get_example  () const { return m_card.get_example  (); }
	virtual ustring get_alt_spelling (SideSelection side_) const;

	virtual long get_id () const { return m_card.get_id (); }

	virtual void set_expiration (const ASSA::TimeVal& e_);
	virtual ASSA::TimeVal get_expiration () const { return m_exp_date; }

	bool is_expired ();
	string get_expiration_str ();

	Deck& get_deck () { return m_deck; }
	Card& get_card () const { return m_card; }
	virtual void dump () const;

protected:
	virtual bool less_then_expiration (const VCard& rhs_);
	virtual bool equal_expiration (const VCard& rhs_);

private:
	Card& m_card;
	Deck& m_deck;
	long  m_exp_date;		/**< Date this card is scheduled to be repeated */
};


inline void 
CardRef::set_alt_spelling (SideSelection side_, const ustring& a_) 
{ 
	m_card.set_alt_spelling  (side_, a_); 
}

inline ustring
CardRef::get_alt_spelling (SideSelection side_) const 
{ 
	return m_card.get_alt_spelling (side_); 
}

inline bool 
CardRef::less_then_expiration (const VCard& rhs_)
{
	return (get_expiration () < rhs_.get_expiration ());
}

inline bool 
CardRef::equal_expiration (const VCard& rhs_)
{
	return (get_expiration () == rhs_.get_expiration ());
}


#endif /* CARD_REF_H */
