// -*- c++ -*-
// generated by glade--
//------------------------------------------------------------------------------
// $Id: AppearancePrefs.cpp,v 1.7 2006/12/18 03:33:14 vlg Exp $
//------------------------------------------------------------------------------
//                            AppearancePrefs.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2006 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Sun Sep 3 2006
//
//------------------------------------------------------------------------------

#include <gtkmm/label.h>
#include <gtkmm/frame.h>
#include <gtkmm/box.h>
#include <gtkmm/scrolledwindow.h>

#include "Granule-main.h"
#include "GrappConf.h"
#include "PrefWindow.h"
#include "AppearancePrefs.h"
#include "TextAlignment.h"

#include "Intern.h"             // i18n macros

using sigc::mem_fun;
using sigc::bind;

//------------------------------------------------------------------------------
static const char* flabels[] = {
    _("Question font: "),
    _("Answer font: "),
    _("Example font: "),
	_("Input font: "),
	_("Application font: ")
};

enum { QFONT, AFONT, EFONT, IFONT, PFONT };

#define SET_FONTS_FRAME(f,l,w) \
	f->set_border_width (4); \
	f->set_shadow_type  (Gtk::SHADOW_ETCHED_IN); \
	f->set_label_align  (Gtk::ALIGN_TOP, Gtk::ALIGN_CENTER);	\
	f->set_label_widget (*l); \
	f->add              (*w);

#define SET_FONTS_LABEL(l) \
	l->set_padding    (0,0);   \
	l->set_line_wrap  (false); \
	l->set_use_markup (true);  \
	l->set_selectable (false);

/**-----------------------------------------------------------------------------
 *   Class AppearancePrefs methods
 **-----------------------------------------------------------------------------
 */
AppearancePrefs::
AppearancePrefs (PrefWindow& pwin_) 
	: 
	Gtk::VBox (false, 0),
	m_pref_window (pwin_)
{  
	trace_with_mask("AppearancePrefs::AppearancePrefs",GUITRACE);

	int i;

#if defined(IS_HILDON) || defined(IS_PDA)
	set_border_width(0);
#else
	set_border_width(14);
#endif

	m_font_table = Gtk::manage (new Gtk::Table (FONT_ENTRY_SZ, 3, false));

	for (i = 0; i < FONT_ENTRY_SZ; i++) {
	    m_fentry [i].m_label  = Gtk::manage(new Gtk::Label (flabels[i]));
	    m_fentry [i].m_entry  = Gtk::manage(new Gtk::Entry);
	    m_fentry [i].m_button = Gtk::manage(new Gtk::Button ("Select"));

	    m_fentry [i].m_label->set_alignment(Gtk::ALIGN_RIGHT,Gtk::ALIGN_CENTER);
	    m_fentry [i].m_label->set_padding(0,0);
	    m_fentry [i].m_label->set_justify(Gtk::JUSTIFY_LEFT);
	    m_fentry [i].m_label->set_line_wrap(false);
	    m_fentry [i].m_label->set_use_markup(false);
	    m_fentry [i].m_label->set_selectable(false);

	    m_fentry [i].m_entry->set_flags(Gtk::CAN_FOCUS);
	    m_fentry [i].m_entry->set_visibility(true);
	    m_fentry [i].m_entry->set_editable(true);
	    m_fentry [i].m_entry->set_max_length(0);
	    m_fentry [i].m_entry->set_text("");
	    m_fentry [i].m_entry->set_has_frame(true);
	    m_fentry [i].m_entry->set_activates_default(false);
#ifdef IS_HILDON
		m_fentry [i].m_entry->set_width_chars (26);
#endif

	    m_fentry [i].m_button->set_flags(Gtk::CAN_FOCUS);

		m_font_table->attach (*m_fentry [i].m_label, 
							  0, 1, i, i+1,
							  Gtk::FILL, 
							  Gtk::AttachOptions (), 2, 2);

		m_font_table->attach (*m_fentry [i].m_entry, 
							  1, 2, i, i+1,
#ifdef IS_HILDON
							  Gtk::FILL,
#else
							  Gtk::EXPAND|Gtk::FILL,
#endif
							  Gtk::AttachOptions(), 2, 2);

		m_font_table->attach (*m_fentry [i].m_button, 
							  2, 3, i, i+1,
							  Gtk::FILL, 
							  Gtk::AttachOptions (), 2, 2);
	}


	Gtk::ScrolledWindow* scrollw = Gtk::manage (new Gtk::ScrolledWindow);
	scrollw->set_flags (Gtk::CAN_FOCUS);
	scrollw->set_shadow_type (Gtk::SHADOW_NONE);
	scrollw->set_policy (Gtk::POLICY_AUTOMATIC , Gtk::POLICY_ALWAYS);

#ifdef GLIBMM_PROPERTIES_ENABLED
	scrollw->property_window_placement ().set_value (Gtk::CORNER_TOP_LEFT);
#else
	scrollw->set_property ("window_placement", Gtk::CORNER_TOP_LEFT);
#endif

	Gtk::VBox* scrollw_vbox = Gtk::manage (new Gtk::VBox (false, 0));

	Gtk::Label* fonts_label = Gtk::manage(new Gtk::Label("<b>Fonts</b>"));
	SET_FONTS_LABEL(fonts_label);

	Gtk::Frame* fonts_frame = Gtk::manage (new Gtk::Frame ());
	SET_FONTS_FRAME (fonts_frame, fonts_label, m_font_table);

	scrollw_vbox->pack_start (*fonts_frame, Gtk::PACK_SHRINK, 4);

	/** Text Alignment Widget
	 */
	m_text_alignment = Gtk::manage (new TextAlignment (pwin_));

	scrollw_vbox->pack_start (*m_text_alignment, Gtk::PACK_SHRINK, 4);

	/** Add ScrollWindow
	 */
	scrollw->add (*scrollw_vbox);
	pack_start (*scrollw);

	/** Set callbacks
	 */
	for (i = 0; i < FONT_ENTRY_SZ; i++) {
	    m_fentry [i].m_entry->signal_changed().connect (
			mem_fun (m_pref_window, &PrefWindow::changed_cb));

	    m_fentry [i].m_button->signal_clicked().connect (
			bind<int>(mem_fun (*this, &AppearancePrefs::on_select_clicked), i));
	}
	
	show_all ();
}

void
AppearancePrefs::
changed_cb ()
{ 
	m_pref_window.changed (); 
}

void
AppearancePrefs::
load_from_config ()
{
	trace_with_mask("AppearancePrefs::load_from_config",GUITRACE);

	m_fentry [QFONT].m_entry->set_text(CONFIG->get_question_font().to_string());
	m_fentry [AFONT].m_entry->set_text(CONFIG->get_answer_font  ().to_string());
	m_fentry [EFONT].m_entry->set_text(CONFIG->get_example_font ().to_string());
	m_fentry [IFONT].m_entry->set_text(CONFIG->get_input_font   ().to_string());
	m_fentry [PFONT].m_entry->set_text(CONFIG->get_app_font     ().to_string());

	m_text_alignment->set_x_alignment   (FRONT, CONFIG->x_alignment   (FRONT));
	m_text_alignment->set_y_alignment   (FRONT, CONFIG->y_alignment   (FRONT));
	m_text_alignment->set_x_padding     (FRONT, CONFIG->x_padding     (FRONT));
	m_text_alignment->set_y_padding     (FRONT, CONFIG->y_padding     (FRONT));
	m_text_alignment->set_justification (FRONT, CONFIG->justification (FRONT));

	m_text_alignment->set_x_alignment   (BACK,  CONFIG->x_alignment   (BACK));
	m_text_alignment->set_y_alignment   (BACK,  CONFIG->y_alignment   (BACK));
	m_text_alignment->set_x_padding     (BACK,  CONFIG->x_padding     (BACK));
	m_text_alignment->set_y_padding     (BACK,  CONFIG->y_padding     (BACK));
	m_text_alignment->set_justification (BACK,  CONFIG->justification (BACK));

	m_text_alignment->set_x_alignment (EXAMPLE, CONFIG->x_alignment (EXAMPLE));
	m_text_alignment->set_y_alignment (EXAMPLE, CONFIG->y_alignment (EXAMPLE));
	m_text_alignment->set_x_padding   (EXAMPLE, CONFIG->x_padding   (EXAMPLE));
	m_text_alignment->set_y_padding   (EXAMPLE, CONFIG->y_padding   (EXAMPLE));
	m_text_alignment->set_justification(EXAMPLE,CONFIG->justification(EXAMPLE));
}

void
AppearancePrefs::
save_to_config ()
{
	trace_with_mask("AppearancePrefs::save_to_config",GUITRACE);

	CONFIG->set_question_font (m_fentry [QFONT].m_entry->get_text ());
	CONFIG->set_answer_font   (m_fentry [AFONT].m_entry->get_text ());
	CONFIG->set_example_font  (m_fentry [EFONT].m_entry->get_text ());
	CONFIG->set_input_font    (m_fentry [IFONT].m_entry->get_text ());
	CONFIG->set_app_font      (m_fentry [PFONT].m_entry->get_text ());

	CONFIG->x_alignment   (FRONT, m_text_alignment->get_x_alignment   (FRONT));
	CONFIG->y_alignment   (FRONT, m_text_alignment->get_y_alignment   (FRONT));
	CONFIG->x_padding     (FRONT, m_text_alignment->get_x_padding     (FRONT));
	CONFIG->y_padding     (FRONT, m_text_alignment->get_y_padding     (FRONT));
	CONFIG->justification (FRONT, m_text_alignment->get_justification (FRONT));

	CONFIG->x_alignment   (BACK,  m_text_alignment->get_x_alignment   (BACK));
	CONFIG->y_alignment   (BACK,  m_text_alignment->get_y_alignment   (BACK));
	CONFIG->x_padding     (BACK,  m_text_alignment->get_x_padding     (BACK));
	CONFIG->y_padding     (BACK,  m_text_alignment->get_y_padding     (BACK));
	CONFIG->justification (BACK,  m_text_alignment->get_justification (BACK));

	CONFIG->x_alignment  (EXAMPLE, m_text_alignment->get_x_alignment (EXAMPLE));
	CONFIG->y_alignment  (EXAMPLE, m_text_alignment->get_y_alignment (EXAMPLE));
	CONFIG->x_padding    (EXAMPLE, m_text_alignment->get_x_padding   (EXAMPLE));
	CONFIG->y_padding    (EXAMPLE, m_text_alignment->get_y_padding   (EXAMPLE));
	CONFIG->justification(EXAMPLE,m_text_alignment->get_justification(EXAMPLE));
}

void
AppearancePrefs::
on_select_clicked (int idx_)
{
	trace_with_mask("AppearancePrefs::on_select_clicked",GUITRACE);

	Gtk::FontSelectionDialog sfd ("Select Text Font");
	sfd.set_font_name (m_fentry [idx_].m_entry->get_text ());

	if (sfd.run () != Gtk::RESPONSE_OK) {
		return;
	}
	m_fentry [idx_].m_entry->set_text (sfd.get_font_name ());
	DL((GRAPP,"Text font changed : \"%s\"\n", 
		m_fentry [idx_].m_entry->get_text ().c_str ()));
}
