// Author: Zelea
// Date: 14 April 2007
// License: http://www.gnu.org/licenses/gpl.txt

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <jpeglib.h>
#include <setjmp.h>

struct jpeg_err_st
{
  struct jpeg_error_mgr pub;	// "public" fields
  jmp_buf       setjmp_buffer;	// for return to caller
};

typedef struct jpeg_err_st *error_ptr;

METHODDEF( void )
jpeg_error( j_common_ptr cinfo )
{
  // cinfo->err really points to a my_error_mgr struct, so coerce pointer 
  error_ptr     myerr = ( error_ptr ) cinfo->err;

  // Always display the message. 
  ( *cinfo->err->output_message ) ( cinfo );
  // Return control to the setjmp point 
  longjmp( myerr->setjmp_buffer, 1 );
}

int
read_JPEG( unsigned char **raster, char *fname )
{
  struct jpeg_decompress_struct cinfo;
  struct jpeg_err_st jerr;
  FILE         *infile;
  JSAMPROW      row[1];		// output row buffer
  int           row_stride;

  if ( ( infile = fopen( fname, "rb" ) ) == NULL )
  {
    fprintf( stderr, "can't open %s\n", fname );
    return 0;
  }

  cinfo.err = jpeg_std_error( &jerr.pub );
  jerr.pub.error_exit = jpeg_error;
  // Establish the setjmp return context
  if ( setjmp( jerr.setjmp_buffer ) )
  {
    // If we get here, the JPEG code has signaled an error.
    jpeg_destroy_decompress( &cinfo );
    fclose( infile );
    return 0;
  }
  jpeg_create_decompress( &cinfo );
  jpeg_stdio_src( &cinfo, infile );
  jpeg_read_header( &cinfo, TRUE );
  jpeg_start_decompress( &cinfo );
  if ( cinfo.output_components != 3 )
  {
    fclose( infile );
    return 0;
  }
  *raster = malloc( cinfo.output_width * cinfo.output_height * 3 );
  if ( *raster )
  {
    row_stride = cinfo.output_width * cinfo.output_components;
    row[0] = *raster;
    while ( cinfo.output_scanline < cinfo.output_height )
    {
      jpeg_read_scanlines( &cinfo, row, 1 );
      row[0] += row_stride;
    }
  }
  jpeg_finish_decompress( &cinfo );
  jpeg_destroy_decompress( &cinfo );
  fclose( infile );
  return 1;
}
