// Author: Zelea
// Date: 31 July 2007
// License: http://www.gnu.org/licenses/gpl.txt

#include <X11/Xft/Xft.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include "rivers.h"

static char  *about_txt =
    "The game's goal is to remove all tiles from the board by matching them as "
    "pairs. To check if two tiles can be removed imagine a line that connects "
    "them through the free space. If the line has two corners or less then "
    "they may be removed. If the tiles are adjacent they may also be removed.|"
    "Use the 'Hint' button a few times to better understand the rules.|"
    "This game was inspired by Shisensho/Kyodai but is a complete rewrite.|"
    "If you don't like the colors & fonts you may edit them in the '"
    RIVERS_INI "' file.";

// justify the text to fit the [x1,y1 x2,y2] rectangle
// '.' followed by '|' means start new paragraph
static void
justify_txt( char *txt, XftFont * fn, Display * dpy, XftDraw * draw,
    XftColor * color, int x1, int y1, int x2, int y2 )
{
  XGlyphInfo    jext;
  int           x, gap, ws, words;
  char         *p, *lp, *linep;

  ws = fn->max_advance_width;
  y1 += fn->ascent + fn->descent;
  linep = p = txt;
  x = x1;
  gap = -1;
  words = 0;
  while ( 1 )
  {
    lp = p;
    while ( *p )
    {
      if ( *p == ' ' )
	break;
      if ( *p == '.' )
      {
	p++;
	if ( *p && ( *p == ' ' || *p == '|' ) )
	  break;
	else
	  continue;
      }
      p++;
    }
    if ( gap == -1 )
      words++;
    XftTextExtents8( dpy, fn, ( FcChar8 * ) lp, p - lp, &jext );
    if ( gap == -1 && x + jext.xOff > x2 )
    {
      words--;
      x -= ws;
      // calculate the extra gap to fill a line up to both ends
      if ( words > 1 && x2 > x )
	gap = ( x2 - x ) / ( words - 1 );
      else
	gap = 0;
      p = linep;
      x = x1;
      continue;
    }
    if ( gap != -1 )
    {
      XftDrawString8( draw, color, fn, x, y1, ( FcChar8 * ) lp, p - lp );
      x += gap;
      words--;
    }
    x += ws + jext.xOff;
    if ( *p && *p == ' ' )
      p++;
    if ( !words )
    {
      if ( *( p - 1 ) == '.' && *p && *p == '|' )	// paragraph
      {
	p++;
	y1 += fn->ascent + fn->descent;
      }
      y1 += fn->ascent + fn->descent;
      if ( y1 > y2 )
	return;
      gap = -1;
      linep = p;
      x = x1;
      continue;
    }
    if ( !*p || ( *( p - 1 ) == '.' && *p && *p == '|' ) )	// paragraph
    {
      gap = 0;
      p = linep;
      x = x1;
      continue;
    }
  }
}

extern Display *dpy;
extern XftFont *fontn;
extern XftDraw *dxft;
extern XftColor cxft;

void
justify_about( int x1, int y1, int x2, int y2 )
{
  justify_txt( about_txt, fontn, dpy, dxft, &cxft, x1, y1, x2, y2 );
}
